/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob.ui.driver;

import com.tridium.batchJob.BBatchJobLogFile;
import com.tridium.batchJob.BBatchJobStepLogFile;
import com.tridium.batchJob.ui.JobTable;
import com.tridium.batchJob.ui.ViewQueryParameter;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BCommandBoundTable;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.BIJobQueryManager;
import javax.baja.batchJob.BIJobStepSummary;
import javax.baja.batchJob.BJobStep;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceNetworkJob;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.BIDeviceStepSummary;
import javax.baja.batchJob.driver.BINetworkStepSummary;
import javax.baja.batchJob.driver.BNetworkBatchAgent;
import javax.baja.batchJob.driver.BNetworkJobStep;
import javax.baja.batchJob.driver.BNetworkStepDetails;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.io.BIEncodable;
import javax.baja.job.BJobService;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.ViewQuery;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IterableCursor;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.TableModel;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbComponentView;

public abstract class BDeviceJobList
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType(BDeviceJobList.class);
    private Model model;
    private BSimple deviceId = null;
    private BDeviceNetwork network = null;
    private BBatchJobService batchJobSvc = null;
    private static Lexicon lex = Lexicon.make((String)"batchJob");
    public static final int COL_STEP_DESC = 0;
    public static final int COL_STEP_START = 1;
    public static final int COL_STEP_END = 2;
    public static final int COL_BUTTONS = 3;

    public Type getType() {
        return TYPE;
    }

    public BDeviceJobList() {
        this.autoRegisterForComponentEvents = false;
        CommandBindings bindings = new CommandBindings();
        LogCommand logCommand = new LogCommand();
        bindings.addCommand((Command)logCommand, BCommandEnablePolicy.singleSelection);
        StepCommand stepCommand = new StepCommand();
        bindings.addCommand((Command)stepCommand, BCommandEnablePolicy.singleSelection);
        bindings.addCommand((Command)new JobCommand(), BCommandEnablePolicy.singleSelection);
        bindings.setDoubleClickCommand((Command)logCommand);
        this.model = new Model();
        BCommandBoundTable table = JobTable.makeListTable(this.model, bindings, 3, stepCommand, null);
        table.setMultipleSelection(false);
        this.setContent((BWidget)new BBorderPane((BWidget)new BEdgePane(null, (BWidget)new BBorderPane((BWidget)new BButtonPane(bindings.getCommands()), BInsets.make((double)4.0, (double)5.0, (double)4.0, (double)5.0)), null, null, (BWidget)new BBorderPane((BWidget)new BScrollPane((BWidget)table), BBorder.inset, BInsets.DEFAULT)), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        this.model.load();
    }

    public void handleComponentEvent(BComponentEvent evt) {
        if (evt.getSourceComponent() instanceof BBatchJobService) {
            if (evt.getId() == 5 && evt.getSlot() == BBatchJobService.jobDisposed) {
                this.model.handleJobDisposed((BAbsTime)evt.getValue());
            }
        } else if (evt.getId() == 1) {
            if (evt.getValue() instanceof BDeviceNetworkJob) {
                for (BJobStepDetails detail : ((BDeviceNetworkJob)evt.getValue()).getJobStepDetails()) {
                    try {
                        this.model.updateDetails(detail);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.registerForComponentEvents((BComponent)((BDeviceNetworkJob)evt.getValue()), Integer.MAX_VALUE);
            } else if (evt.getValue() instanceof BJobStep) {
                BJobStep step = (BJobStep)evt.getValue();
                for (BJobStepDetails detail : step.getJobStepDetails()) {
                    try {
                        this.model.updateDetails(detail);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.registerForComponentEvents((BComponent)step, Integer.MAX_VALUE);
            } else if (evt.getValue() instanceof BJobStepDetails) {
                BJobStepDetails details = (BJobStepDetails)evt.getValue();
                try {
                    this.model.updateDetails(details);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.registerForComponentEvents((BComponent)details, Integer.MAX_VALUE);
            }
        } else if (evt.getSourceComponent() instanceof BJobStepDetails) {
            try {
                this.model.updateDetails((BJobStepDetails)evt.getSourceComponent());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected BSimple getDeviceId() {
        if (this.deviceId == null) {
            this.deviceId = BNetworkBatchAgent.get((BDevice)this.getDevice()).getBatchDeviceId(this.getDevice());
        }
        return this.deviceId;
    }

    protected BDeviceNetwork getNetwork() {
        if (this.network == null) {
            this.network = BNetworkBatchAgent.get((BDevice)this.getDevice()).getDeviceNetwork(this.getDevice());
        }
        return this.network;
    }

    protected abstract BDevice getDevice();

    protected BDeviceNetworkJob getJob(BJobStepDetails details) {
        BJobStep step;
        if (details.getParent() instanceof BJobStep && (step = (BJobStep)details.getParent()).getJob() instanceof BDeviceNetworkJob) {
            return (BDeviceNetworkJob)step.getJob();
        }
        return null;
    }

    protected BBatchJobService getBatchJobService() throws Exception {
        if (this.batchJobSvc == null) {
            this.batchJobSvc = (BBatchJobService)BOrd.make((String)"service:batchJob:BatchJobService").get(this.getCurrentValue());
        }
        return this.batchJobSvc;
    }

    protected BIJobQueryManager getQueryManager() throws Exception {
        return this.getBatchJobService().getJobQueryManager();
    }

    private static class Key {
        private BSimple deviceId;
        private BAbsTime stepStart;
        private BTypeSpec stepType;

        public Key(BJobStepDetails details) {
            this.deviceId = details instanceof BDeviceStepDetails ? ((BDeviceStepDetails)details).getDeviceId() : BString.DEFAULT;
            this.stepStart = details.getStartTime();
            this.stepType = details.getStepType();
        }

        public Key(BIJobStepSummary summary) {
            this.deviceId = summary instanceof BIDeviceStepSummary ? ((BIDeviceStepSummary)summary).getDeviceId() : BString.DEFAULT;
            this.stepStart = summary.getStartTime();
            this.stepType = summary.getStepType();
        }

        public boolean equals(Object o) {
            if (o instanceof Key) {
                Key k = (Key)o;
                return k.deviceId.equals((Object)this.deviceId) && k.stepStart.equals((Object)this.stepStart) && k.stepType.equals((Object)this.stepType);
            }
            return false;
        }

        public String toString() {
            return this.deviceId + ":" + this.stepStart + ":" + this.stepType;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }

    private class LogCommand
    extends Command {
        public LogCommand() {
            super((BWidget)BDeviceJobList.this, lex, "DeviceJobList.logCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BJobStepDetails details = BDeviceJobList.this.model.summary(BDeviceJobList.this.model.getTable().getSelection().getRow()).getStepDetails(BDeviceJobList.this.getCurrentValue());
                JobTable.showLogDialog((BWidget)BDeviceJobList.this.model.getTable(), details.readLog().toString());
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }

    private class JobCommand
    extends Command {
        public JobCommand() {
            super((BWidget)BDeviceJobList.this, lex, "DeviceJobList.jobCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BOrd jobOrd;
                BIJobStepSummary summary = BDeviceJobList.this.model.summary(BDeviceJobList.this.model.getTable().getSelection().getRow());
                BDeviceNetworkJob job = (BDeviceNetworkJob)summary.getJob(BDeviceJobList.this.getCurrentValue());
                if (job.getParent() instanceof BJobService) {
                    jobOrd = job.getAbsoluteOrd();
                } else {
                    BBatchJobLogFile file = BBatchJobLogFile.find((BBatchJob)job, (BObject)BDeviceJobList.this.getCurrentValue());
                    jobOrd = file.getAbsoluteOrd();
                    jobOrd = BOrd.make((BOrd)jobOrd, (OrdQuery)new ViewQuery("?displayTzId=" + ViewQueryParameter.encode((BIEncodable)BString.make((String)job.getStartTime().getTimeZone().getId()))));
                }
                if (job != null) {
                    BDeviceJobList.this.getWbShell().hyperlink(jobOrd);
                }
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }

    private class StepCommand
    extends Command {
        public StepCommand() {
            super((BWidget)BDeviceJobList.this, lex, "DeviceJobList.stepCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BOrd ord;
                BIJobStepSummary summary = BDeviceJobList.this.model.summary(BDeviceJobList.this.model.getTable().getSelection().getRow());
                BJobStepDetails details = summary.getStepDetails(BDeviceJobList.this.getCurrentValue());
                if (details.getParent() instanceof BJobStep) {
                    ord = BOrd.make((BOrd)((BComponent)BDeviceJobList.this.getCurrentValue()).getAbsoluteOrd(), (BOrd)details.getHandleOrd());
                } else {
                    BBatchJobStepLogFile logFile = BBatchJobStepLogFile.find((BTypeSpec)summary.getStepType(), (BAbsTime)summary.getLocalStartTime(), (BObject)BDeviceJobList.this.getCurrentValue());
                    ord = BOrd.make((BOrd)((BComponent)BDeviceJobList.this.getCurrentValue()).getAbsoluteOrd(), (BOrd)logFile.getOrdInSession());
                    ord = BOrd.make((BOrd)ord, (OrdQuery)new ViewQuery("?displayTzId=" + ViewQueryParameter.encode((BIEncodable)BString.make((String)summary.getStartTime().getTimeZone().getId()))));
                }
                BDeviceJobList.this.getWbShell().hyperlink(ord);
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }

    private class Model
    extends TableModel {
        private List<BIJobStepSummary> rows = new ArrayList<BIJobStepSummary>();
        private Map<Key, BIJobStepSummary> summaryByKey = new HashMap<Key, BIJobStepSummary>();
        private Map<BAbsTime, List<BIJobStepSummary>> summariesByJobStartTime = new HashMap<BAbsTime, List<BIJobStepSummary>>();

        private Model() {
        }

        public synchronized void updateDetails(BJobStepDetails details) throws Exception {
            if (details instanceof BDeviceStepDetails) {
                this.updateDeviceStepDetails((BDeviceStepDetails)details);
            } else if (details instanceof BNetworkStepDetails) {
                this.updateNetworkStepDetails((BNetworkStepDetails)details);
            }
        }

        public synchronized void updateNetworkStepDetails(BNetworkStepDetails details) throws Exception {
            BNetworkJobStep step;
            BDeviceNetworkJob job;
            Key key;
            BIJobStepSummary summary;
            if (details.getNetworkOrd().equals((Object)BDeviceJobList.this.getNetwork().getOrdInSpace()) && (summary = this.summaryByKey.get(key = new Key((BJobStepDetails)details))) == null && details.getParent() instanceof BNetworkJobStep && (job = (BDeviceNetworkJob)(step = (BNetworkJobStep)details.getParent()).getJob()) != null) {
                summary = BDeviceJobList.this.getQueryManager().makeStepSummary((BJobStepDetails)details, job.getStartTime());
                List<BIJobStepSummary> summaries = this.summariesByJobStartTime.get(job.getStartTime());
                if (summaries == null) {
                    summaries = new ArrayList<BIJobStepSummary>();
                    this.summariesByJobStartTime.put(job.getStartTime(), summaries);
                }
                summaries.add(summary);
                this.rows.add(0, summary);
                this.summaryByKey.put(key, summary);
                this.updateTable(true);
            }
        }

        public synchronized void updateDeviceStepDetails(BDeviceStepDetails details) throws Exception {
            if (details.getDeviceId().equals((Object)BDeviceJobList.this.getDeviceId())) {
                Key key = new Key((BJobStepDetails)details);
                BIJobStepSummary summary = this.summaryByKey.get(key);
                if (summary == null) {
                    BDeviceJobStep step;
                    BDeviceNetworkJob job;
                    if (details.getParent() instanceof BDeviceJobStep && (job = (BDeviceNetworkJob)(step = (BDeviceJobStep)details.getParent()).getJob()) != null) {
                        summary = BDeviceJobList.this.getQueryManager().makeStepSummary((BJobStepDetails)details, job.getStartTime());
                        List<BIJobStepSummary> summaries = this.summariesByJobStartTime.get(job.getStartTime());
                        if (summaries == null) {
                            summaries = new ArrayList<BIJobStepSummary>();
                            this.summariesByJobStartTime.put(job.getStartTime(), summaries);
                        }
                        summaries.add(summary);
                        this.rows.add(0, summary);
                        this.summaryByKey.put(key, summary);
                        this.updateTable(true);
                    }
                } else {
                    summary.update((BJobStepDetails)details);
                    this.updateTable(true);
                }
            }
        }

        public synchronized void handleJobDisposed(BAbsTime jobStartTime) {
            List<BIJobStepSummary> summaries = this.summariesByJobStartTime.get(jobStartTime);
            if (summaries != null) {
                for (BIJobStepSummary summary : summaries) {
                    this.rows.remove(summary);
                    this.summaryByKey.remove(new Key(summary));
                }
                this.summariesByJobStartTime.remove(jobStartTime);
                this.updateTable(false);
            }
        }

        public synchronized void load() throws Exception {
            ArrayList<BIJobStepSummary> summaries;
            BIJobStepSummary summary;
            BJobService jobSvc = (BJobService)BOrd.make((String)"service:baja:JobService").get(BDeviceJobList.this.getCurrentValue());
            BBatchJobService batchJobSvc = (BBatchJobService)BOrd.make((String)"service:batchJob:BatchJobService").get(BDeviceJobList.this.getCurrentValue());
            ArrayList<BIJobStepSummary> tempRows = new ArrayList<BIJobStepSummary>();
            HashMap<BAbsTime, List<BIJobStepSummary>> tempSummariesByJobStartTime = new HashMap<BAbsTime, List<BIJobStepSummary>>();
            HashMap<Key, BIJobStepSummary> tempSummaryByKey = new HashMap<Key, BIJobStepSummary>();
            SlotCursor cJob = jobSvc.getProperties();
            while (cJob.next(BDeviceNetworkJob.class)) {
                BDeviceNetworkJob job = (BDeviceNetworkJob)cJob.get();
                if (job.getJobState().isComplete()) continue;
                ArrayList<BIJobStepSummary> summaries2 = null;
                for (BJobStepDetails detail : job.getJobStepDetails()) {
                    BNetworkStepDetails nwDetails;
                    BIJobStepSummary summary2;
                    if (detail instanceof BDeviceStepDetails) {
                        BDeviceStepDetails deviceStepDetails = (BDeviceStepDetails)detail;
                        if (!deviceStepDetails.getDeviceId().equals((Object)BDeviceJobList.this.getDeviceId())) continue;
                        summary2 = BDeviceJobList.this.getQueryManager().makeStepSummary((BJobStepDetails)deviceStepDetails, job.getStartTime());
                        if (summaries2 == null) {
                            summaries2 = new ArrayList<BIJobStepSummary>();
                        }
                        summaries2.add(summary2);
                        tempSummaryByKey.put(new Key((BJobStepDetails)deviceStepDetails), summary2);
                        tempRows.add(summary2);
                        continue;
                    }
                    if (!(detail instanceof BNetworkStepDetails) || !(nwDetails = (BNetworkStepDetails)detail).getNetworkOrd().equals((Object)BDeviceJobList.this.getNetwork().getOrdInSpace())) continue;
                    summary2 = BDeviceJobList.this.getQueryManager().makeStepSummary((BJobStepDetails)nwDetails, job.getStartTime());
                    if (summaries2 == null) {
                        summaries2 = new ArrayList();
                    }
                    summaries2.add(summary2);
                    tempSummaryByKey.put(new Key((BJobStepDetails)nwDetails), summary2);
                    tempRows.add(summary2);
                }
                if (summaries2 == null) continue;
                tempSummariesByJobStartTime.put(job.getStartTime(), summaries2);
            }
            try (IterableCursor c = BDeviceJobList.this.getQueryManager().listStepSummaries(BDeviceJobStep.TYPE, "deviceId", BDeviceJobList.this.getDeviceId(), (BObject)BDeviceJobList.this.getDevice());){
                while (c.next()) {
                    summary = (BIJobStepSummary)c.get();
                    tempRows.add(summary);
                    this.summaryByKey.put(new Key(summary), summary);
                    summaries = this.summariesByJobStartTime.get(summary.getJobStartTime());
                    if (summaries == null) {
                        summaries = new ArrayList<BIJobStepSummary>();
                        this.summariesByJobStartTime.put(summary.getJobStartTime(), summaries);
                    }
                    summaries.add(summary);
                }
            }
            c = BDeviceJobList.this.getQueryManager().listStepSummaries(BNetworkJobStep.TYPE, (BObject)BDeviceJobList.this.getDevice());
            var7_7 = null;
            try {
                while (c.next()) {
                    summary = (BINetworkStepSummary)c.get();
                    if (!summary.getDevicesToProcess().contains((BValue)BDeviceJobList.this.getDeviceId())) continue;
                    tempRows.add(summary);
                    this.summaryByKey.put(new Key(summary), summary);
                    summaries = (ArrayList<BIJobStepSummary>)tempSummariesByJobStartTime.get(summary.getJobStartTime());
                    if (summaries == null) {
                        summaries = new ArrayList<BIJobStepSummary>();
                        tempSummariesByJobStartTime.put(summary.getJobStartTime(), summaries);
                    }
                    summaries.add(summary);
                }
            }
            catch (Throwable throwable) {
                var7_7 = throwable;
                throw throwable;
            }
            finally {
                if (c != null) {
                    if (var7_7 != null) {
                        try {
                            c.close();
                        }
                        catch (Throwable throwable) {
                            var7_7.addSuppressed(throwable);
                        }
                    } else {
                        c.close();
                    }
                }
            }
            tempRows.sort(Comparator.comparing(BIJobStepSummary::getStartTime).reversed());
            this.summaryByKey = tempSummaryByKey;
            this.rows = tempRows;
            this.summariesByJobStartTime = tempSummariesByJobStartTime;
            this.updateTable(true);
            BDeviceJobList.this.registerForComponentEvents((BComponent)jobSvc, Integer.MAX_VALUE);
            BDeviceJobList.this.registerForComponentEvents((BComponent)batchJobSvc, Integer.MAX_VALUE);
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return lex.getText("DeviceJobList.col.stepDesc");
                }
                case 1: {
                    return lex.getText("DeviceJobList.col.stepStart");
                }
                case 2: {
                    return lex.getText("DeviceJobList.col.stepEnd");
                }
                case 3: {
                    return "";
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.summary(row).getStepDescription();
                }
                case 1: {
                    return this.summary(row).getStartTime().toString();
                }
                case 2: {
                    return this.summary(row).getEndTime() == null ? "" : this.summary(row).getEndTime().toString();
                }
                case 3: {
                    return this.summary(row).getStepState();
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public BIJobStepSummary summary(int row) {
            return this.rows.get(row);
        }

        public BImage getRowIcon(int row) {
            return JobTable.stateToIcon(this.summary(row).getStepState());
        }
    }
}

