/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob.ui;

import com.tridium.batchJob.ui.JobStepChooser;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BCommandDialog;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.DialogCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BIJobStepContainer;
import javax.baja.batchJob.BJobStage;
import javax.baja.batchJob.BJobStep;
import javax.baja.batchJob.ui.BJobStepFactory;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.space.Mark;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListController;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.list.ListSelection;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;

public class BJobStageBuilder
extends BList
implements CommandBindings.Support {
    public static final Topic listUpdated = BJobStageBuilder.newTopic((int)0, null);
    public static final Topic transferWidgetFocusGained = BJobStageBuilder.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BJobStageBuilder.class);
    private BObject jobTarget = null;
    private BBatchJob currentBatchJob = null;
    private JobStepChooser chooser;
    private BWidget container;
    private Model model;
    private static final ExcludeGenericAgents EXCLUDE_GENERIC = new ExcludeGenericAgents();
    public static final Lexicon lex = Lexicon.make((String)"batchJob");

    public void fireListUpdated(BWidgetEvent event) {
        this.fire(listUpdated, (BValue)event, null);
    }

    public void fireTransferWidgetFocusGained(BFocusEvent event) {
        this.fire(transferWidgetFocusGained, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BJobStageBuilder() {
        throw new UnsupportedOperationException();
    }

    public BJobStageBuilder(String headerText, Type stageType) {
        this.chooser = new JobStepChooser(stageType);
        CommandBindings bindings = new CommandBindings();
        bindings.setSupport((CommandBindings.Support)this);
        AddStep addStep = new AddStep();
        bindings.addCommand((Command)addStep, BCommandEnablePolicy.always);
        MoveStepUp moveStepUp = new MoveStepUp();
        bindings.addCommand((Command)moveStepUp, BCommandEnablePolicy.singleSelection);
        MoveStepDown moveStepDown = new MoveStepDown();
        bindings.addCommand((Command)moveStepDown, BCommandEnablePolicy.singleSelection);
        RemoveStep removeStep = new RemoveStep();
        bindings.addCommand((Command)removeStep, BCommandEnablePolicy.anySelection);
        ViewStepDetails viewStepDetails = new ViewStepDetails();
        bindings.addCommand((Command)viewStepDetails, BCommandEnablePolicy.singleSelection);
        bindings.setDoubleClickCommand((Command)viewStepDetails);
        this.setController((ListController)new Controller(bindings));
        this.setSelection((ListSelection)new CommandBindings.ListSelection(bindings));
        this.model = new Model();
        this.setModel(this.model);
        BBorderPane border = new BBorderPane((BWidget)new BEdgePane(null, (BWidget)new BButtonPane(BButtonStyle.toolBar, new Command[]{addStep, moveStepUp, moveStepDown, removeStep}, false, true), null, null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)this, BBorder.inset, BInsets.DEFAULT), 4.0, 0.0, 4.0, 0.0)));
        border.setBorder(BBorder.solid);
        border.setLabel((BWidget)new BLabel(headerText));
        border.setPadding(BInsets.make((double)4.0, (double)4.0, (double)4.0, (double)4.0));
        this.container = border;
    }

    public BWidget getContainer() {
        return this.container;
    }

    public BJobStep[] getJobSteps() {
        BJobStep[] result = new BJobStep[this.model.getItemCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.model.getJobStep(i);
        }
        return result;
    }

    public void addJobStep(BJobStep step) {
        this.model.addItem(null, step);
    }

    public void load(BJobStage stage, BObject jobTarget) {
        this.currentBatchJob = stage == null ? null : stage.getJob();
        this.jobTarget = jobTarget;
        this.model.removeAllItems();
        if (stage != null) {
            for (BJobStep step : stage.getAllSteps()) {
                this.addJobStep(step);
            }
        }
    }

    public void saveToStage(BJobStage stage) {
        List<BJobStep> stageSteps = Arrays.asList(stage.getAllSteps());
        List<BJobStep> newSteps = Arrays.asList(this.getJobSteps());
        BComponent stepsContainer = stage.get("steps").asComponent();
        Property[] propertiesArray = new Property[newSteps.size()];
        for (BJobStep step : newSteps) {
            if (!stageSteps.contains(step)) {
                stage.addStep(step);
                Property[] folderProperties = stepsContainer.getPropertiesArray();
                propertiesArray[newSteps.indexOf((Object)step)] = folderProperties[folderProperties.length - 1];
                continue;
            }
            propertiesArray[newSteps.indexOf((Object)step)] = stepsContainer.getProperty(step.getName());
        }
        for (BJobStep step : stageSteps) {
            if (newSteps.contains(step)) continue;
            stepsContainer.remove((BComplex)step);
        }
        if (propertiesArray.length != 0) {
            stepsContainer.reorder(propertiesArray);
        }
    }

    public void setBoundCommandEnabled(Command command, boolean bindingBasedState) {
        if (command instanceof StepListCommand) {
            ((StepListCommand)command).checkEnabled(bindingBasedState);
        } else {
            command.setEnabled(bindingBasedState);
        }
    }

    public int dragOver(TransferContext cx) {
        Mark mark;
        BObject[] values;
        if (this.jobTarget == null) {
            return 0;
        }
        if (cx.isCopy() && cx.getEnvelope().supports(TransferFormat.mark) && (values = (mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark)).getValues()).length == 1) {
            try {
                if (values[0] instanceof BJobStepFactory && ((BJobStepFactory)values[0]).isValidFor(this.currentBatchJob, this.jobTarget, this.chooser.getStageType(), values[0])) {
                    return 16;
                }
                AgentList agents = values[0].getAgents().filter(AgentFilter.is((Type)BJobStepFactory.TYPE)).filter((AgentFilter)new ValidFactory(this.currentBatchJob, this.jobTarget, this.chooser.getStageType(), values[0]));
                if (agents.size() > 0) {
                    return 16;
                }
            }
            catch (Exception e) {
                Logger.getLogger("batchJob").log(Level.SEVERE, "Error testing validity of job step factory", e);
            }
        }
        return 0;
    }

    public CommandArtifact drop(TransferContext cx) throws Exception {
        if (this.jobTarget == null) {
            return null;
        }
        if (cx.isCopy() && cx.getEnvelope().supports(TransferFormat.mark)) {
            int row = this.getItemIndexAt(cx.getX(), cx.getY());
            Mark mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark);
            BObject[] values = mark.getValues();
            if (values.length == 1) {
                BJobStep step;
                BJobStepFactory factory = null;
                if (values[0] instanceof BJobStepFactory && ((BJobStepFactory)values[0]).isValidFor(this.currentBatchJob, this.jobTarget, this.chooser.getStageType(), values[0])) {
                    factory = (BJobStepFactory)values[0];
                } else {
                    AgentList agents = values[0].getAgents().filter(AgentFilter.is((Type)BJobStepFactory.TYPE)).filter((AgentFilter)new ValidFactory(this.currentBatchJob, this.jobTarget, this.chooser.getStageType(), values[0]));
                    if (agents.size() > 0) {
                        ArrayList<BJobStepFactory> protos = new ArrayList<BJobStepFactory>();
                        for (int i = 0; i < agents.size(); ++i) {
                            protos.add((BJobStepFactory)agents.get(i).getInstance());
                        }
                        factory = this.chooser.chooseFactory((BWidget)this, this.currentBatchJob, this.jobTarget, protos, (Context)cx);
                    }
                }
                if (factory != null && (step = factory.makeStep((BWidget)this, this.currentBatchJob, this.jobTarget, values[0], (Context)cx)) != null) {
                    if (row < 0) {
                        this.model.addItem(null, step);
                    } else {
                        this.model.insertItem(row, null, step);
                    }
                }
            }
        }
        return null;
    }

    private static class SaveEditorCommand
    extends DialogCommand {
        private BWbEditor editor;

        public SaveEditorCommand(BWidget owner, BWbEditor editor) {
            super(owner, 1, UiLexicon.bajaui().getText("commands.save.label"), null, null, null);
            this.editor = editor;
        }

        public CommandArtifact doInvoke() throws Exception {
            this.editor.saveValue();
            return super.doInvoke();
        }
    }

    private static class ValidFactory
    extends AgentFilter {
        private BBatchJob currentBatchJob;
        private BObject jobTarget;
        private Type stageType;
        private BObject source;

        public ValidFactory(BBatchJob currentBatchJob, BObject jobTarget, Type stageType, BObject source) {
            this.currentBatchJob = currentBatchJob;
            this.jobTarget = jobTarget;
            this.stageType = stageType;
            this.source = source;
        }

        public boolean include(AgentInfo agent) {
            try {
                return ((BJobStepFactory)agent.getInstance()).isValidFor(this.currentBatchJob, this.jobTarget, this.stageType, this.source);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    private static class ExcludeGenericAgents
    extends AgentFilter {
        private AgentList agents = new BComponent().getAgents();

        public boolean include(AgentInfo agent) {
            return this.agents.indexOf(agent) == -1;
        }
    }

    private class Controller
    extends CommandBindings.ListController {
        public Controller(CommandBindings bindings) {
            super(bindings);
        }

        public void focusGained(BFocusEvent event) {
            BJobStageBuilder.this.fireTransferWidgetFocusGained(event);
        }
    }

    private class Model
    extends ListModel {
        private List<BJobStep> steps = new ArrayList<BJobStep>();

        private Model() {
        }

        public synchronized void swapItems(int idx1, int idx2) {
            BJobStep temp = this.steps.get(idx1);
            this.steps.set(idx1, this.steps.get(idx2));
            this.steps.set(idx2, temp);
            this.updateList();
        }

        public synchronized void addItem(BImage icon, Object value) {
            this.steps.add((BJobStep)value);
            this.updateList();
        }

        public synchronized void insertItem(int index, BImage icon, Object value) {
            this.steps.add(index, (BJobStep)value);
            this.updateList();
        }

        public synchronized void removeItem(Object value) {
            this.steps.remove(value);
            this.updateList();
        }

        public void removeItem(int index) {
            this.removeItem(this.getJobStep(index));
        }

        public synchronized void removeAllItems() {
            this.steps.clear();
            this.updateList();
        }

        public int getItemCount() {
            return this.steps.size();
        }

        public void updateList() {
            super.updateList();
            BJobStageBuilder.this.fireListUpdated(new BWidgetEvent(1, (BWidget)this.getList()));
        }

        public BImage getItemIcon(int index) {
            return BImage.make((BIcon)this.getJobStep(index).getIcon());
        }

        public BJobStep getJobStep(int index) {
            return this.steps.get(index);
        }

        public Object getItem(int index) {
            return this.getJobStep(index).toString(null);
        }
    }

    private class RemoveStep
    extends StepListCommand {
        public RemoveStep() {
            super("JobStageBuilder.remove");
        }

        public CommandArtifact doInvoke() {
            int[] sel = BJobStageBuilder.this.model.getSelection().getItems();
            for (int i = sel.length; i > 0; --i) {
                BJobStageBuilder.this.model.removeItem(sel[i - 1]);
            }
            BJobStageBuilder.this.model.getSelection().deselectAll();
            return null;
        }
    }

    private class MoveStepDown
    extends StepListCommand {
        public MoveStepDown() {
            super("JobStageBuilder.moveDown");
        }

        public CommandArtifact doInvoke() {
            int sel = BJobStageBuilder.this.model.getSelection().getItems()[0];
            BJobStageBuilder.this.model.swapItems(sel, sel + 1);
            BJobStageBuilder.this.model.getSelection().select(sel + 1, true);
            return null;
        }

        @Override
        public void checkEnabled(boolean bindingBasedState) {
            if (bindingBasedState) {
                int sel = BJobStageBuilder.this.model.getSelection().getItems()[0];
                if (sel == BJobStageBuilder.this.model.getModel().getItemCount() - 1) {
                    this.setEnabled(false);
                } else {
                    this.setEnabled(bindingBasedState);
                }
            } else {
                this.setEnabled(bindingBasedState);
            }
        }
    }

    private class MoveStepUp
    extends StepListCommand {
        public MoveStepUp() {
            super("JobStageBuilder.moveUp");
        }

        public CommandArtifact doInvoke() {
            int sel = BJobStageBuilder.this.model.getSelection().getItems()[0];
            BJobStageBuilder.this.model.swapItems(sel, sel - 1);
            BJobStageBuilder.this.model.getSelection().select(sel - 1, true);
            return null;
        }

        @Override
        public void checkEnabled(boolean bindingBasedState) {
            if (bindingBasedState) {
                int sel = BJobStageBuilder.this.model.getSelection().getItems()[0];
                if (sel == 0) {
                    this.setEnabled(false);
                } else {
                    this.setEnabled(bindingBasedState);
                }
            } else {
                this.setEnabled(bindingBasedState);
            }
        }
    }

    private class AddStep
    extends StepListCommand {
        public AddStep() {
            super("JobStageBuilder.add");
        }

        public CommandArtifact doInvoke() {
            try {
                BJobStep toAdd = BJobStageBuilder.this.chooser.choose((BWidget)BJobStageBuilder.this, BJobStageBuilder.this.currentBatchJob, BJobStageBuilder.this.jobTarget, null);
                if (toAdd != null) {
                    if (toAdd instanceof BIJobStepContainer) {
                        List steps = ((BIJobStepContainer)toAdd).getSubSteps();
                        if (steps != null && steps.size() > 0) {
                            for (BJobStep step : steps) {
                                BJobStageBuilder.this.model.addItem(null, step);
                            }
                        }
                    } else {
                        BJobStageBuilder.this.model.addItem(null, toAdd);
                    }
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }

    private class ViewStepDetails
    extends StepListCommand {
        public ViewStepDetails() {
            super("JobStageBuilder.details");
        }

        @Override
        public void checkEnabled(boolean bindingBasedState) {
            BJobStep step;
            AgentList agents;
            if (bindingBasedState && (agents = (step = BJobStageBuilder.this.model.getJobStep(BJobStageBuilder.this.model.getSelection().getItems()[0])).getAgents().filter(AgentFilter.is((Type)BWbEditor.TYPE)).filter((AgentFilter)EXCLUDE_GENERIC)).size() > 0) {
                this.setEnabled(true);
            }
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            try {
                BJobStep step = BJobStageBuilder.this.model.getJobStep(BJobStageBuilder.this.model.getSelection().getItems()[0]);
                AgentList agents = step.getAgents().filter(AgentFilter.is((Type)BWbEditor.TYPE)).filter((AgentFilter)EXCLUDE_GENERIC);
                if (agents.size() > 0) {
                    BWbEditor editor = (BWbEditor)agents.getDefault().getInstance();
                    editor.loadValue((BObject)step);
                    BCommandDialog.open((BWidget)BJobStageBuilder.this, (String)step.toString(null), (Object)editor, (DialogCommand[])new DialogCommand[]{new SaveEditorCommand((BWidget)BJobStageBuilder.this, editor), DialogCommand.makeCancel((BWidget)BJobStageBuilder.this)}, null);
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }

    private abstract class StepListCommand
    extends Command {
        public StepListCommand(String tag) {
            super((BWidget)BJobStageBuilder.this, lex, tag);
        }

        public void checkEnabled(boolean bindingBasedState) {
            this.setEnabled(bindingBasedState);
        }
    }
}

