/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.ui;

import com.tridium.ace.component.BAceComponent;
import com.tridium.ace.kit.AceType;
import com.tridium.ace.kit.CatalogKit;
import com.tridium.ace.kit.LocalKitRegistry;
import com.tridium.ace.sys.BAceFolder;
import com.tridium.ace.ui.CatalogListUtil;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeSelection;
import javax.baja.util.Lexicon;
import javax.baja.workbench.nav.tree.BNavTree;
import javax.baja.workbench.nav.tree.DefaultNavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeModel;
import javax.baja.workbench.sidebar.BWbSideBar;

@NiagaraType
@NiagaraAction(name="updateTree", flags=4)
public class BAcePaletteSideBar
extends BWbSideBar {
    public static final Action updateTree = BAcePaletteSideBar.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BAcePaletteSideBar.class);
    private BListDropDown openPals;
    private BEdgePane content;
    private BNavTree tree;
    private BTreePane treePane;
    private BSpace lastAppSpace;
    private CatalogListUtil catalogList = new CatalogListUtil();
    private static final Logger LOG = Logger.getLogger("AceNetwork");
    private static final Lexicon LEX = Lexicon.make((String)"ace");

    public void updateTree() {
        this.invoke(updateTree, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAcePaletteSideBar() {
        this.openPals = new BListDropDown();
        this.linkTo(null, (BComponent)this.openPals, (Slot)BListDropDown.listActionPerformed, (Slot)updateTree);
        BEdgePane top = new BEdgePane();
        top.setCenter((BWidget)new BBorderPane((BWidget)this.openPals, 0.0, 0.0, 0.0, 5.0));
        BBorderPane topPane = new BBorderPane((BWidget)top, 5.0, 5.0, 5.0, 5.0);
        this.content = new BEdgePane();
        this.content.setTop((BWidget)topPane);
        this.tree = new BNavTree((NavTreeModel)new EmptyModel());
        this.tree.setMultipleSelection(true);
        this.treePane = new BTreePane((BTree)this.tree);
        StyleUtils.addStyleClass((IStylable)this.treePane, (String)"sidebar-scroll-pane");
        this.content.setCenter((BWidget)this.treePane);
        this.setContent((BWidget)this.content);
        this.loadPalette();
        if (this.openPals.getList().getItemCount() > 0) {
            int index = 0;
            this.openPals.getList().setSelectedIndex(index);
            this.doUpdateTree();
        }
    }

    public void doUpdateTree() {
        int index = this.openPals.getList().getSelectedIndex();
        String df = this.catalogList.getItem(index);
        String catalogAddress = Sys.getRegistry().getDef(df);
        try {
            BOrd moduleCatalogOrd = BOrd.make((String)catalogAddress);
            BIFile catalogFile = (BIFile)moduleCatalogOrd.resolve().get();
            BAceFolder root = new BAceFolder();
            LocalKitRegistry registry = new LocalKitRegistry(catalogFile);
            ArrayList<CatalogKit> kits = new ArrayList<CatalogKit>(registry.kits());
            kits.sort(Comparator.comparing(CatalogKit::name));
            for (CatalogKit kit : kits) {
                BAceFolder kitFolder = new BAceFolder();
                for (AceType aceType : kit.types()) {
                    if (aceType.getTypeName().equalsIgnoreCase("app")) continue;
                    BAceComponent typeNode = aceType.newInstance(true);
                    kitFolder.add(SlotPath.escape((String)aceType.getTypeName()), (BValue)typeNode, Context.decoding);
                }
                root.add(SlotPath.escape((String)kit.displayName()), (BValue)kitFolder, Context.decoding);
            }
            DefaultNavTreeModel model = new DefaultNavTreeModel((BINavNode)root);
            this.tree.setModel((TreeModel)model);
            TreeSelection sel = this.tree.getSelection();
            if (sel != null) {
                sel.deselectAll();
            }
            this.tree.relayout();
        }
        catch (Exception e) {
            this.setContent((BWidget)new BLabel(LEX.getText("ace.palette.cannotLoadCatalog", new Object[]{e.getLocalizedMessage()})));
            LOG.log(Level.FINE, "Cannot load ACE Catalog", e);
        }
    }

    private void loadPalette() {
        this.openPals.getList().removeAllItems();
        this.catalogList.addItemToCatalogList(this.openPals);
    }

    public String getLabel() {
        return LEX.getText("ace.palette.label");
    }

    static class EmptyModel
    extends NavTreeModel {
        EmptyModel() {
        }

        public int getRootCount() {
            return 0;
        }

        public TreeNode getRoot(int index) {
            return null;
        }
    }
}

