/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.ui;

import com.tridium.ace.BAceNetwork;
import com.tridium.ace.sys.BAceAppFile;
import com.tridium.workbench.nav.BFileMenuAgent;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.menu.BIMenu;
import javax.baja.workbench.nav.menu.BNavMenuAgent;
import javax.baja.workbench.nav.menu.NavMenuUtil;

@NiagaraType(agent={@AgentOn(types={"ace:AceAppFile"})})
public class BAceFileMenuAgent
extends BNavMenuAgent {
    public static final BAceFileMenuAgent INSTANCE = new BAceFileMenuAgent();
    public static final Type TYPE = Sys.loadType(BAceFileMenuAgent.class);
    public static final BModule module = TYPE.getModule();

    public Type getType() {
        return TYPE;
    }

    public int hashCode() {
        return this.toString(null).hashCode();
    }

    protected BMenu doMakeMenu(BWidget owner, BObject target, Context cx) {
        BAceAppFile aceFile = (BAceAppFile)target;
        BMenu menu = new BMenu();
        BMenu fileViews = NavMenuUtil.makeViewsMenu((BWidget)owner, (BObject)target, (BOrd)aceFile.getAbsoluteOrd());
        menu.add("fileViews", (BValue)new BSubMenuItem((BIMenu)fileViews));
        menu.add(null, (BValue)new BSeparator());
        menu.add("save", (Command)new Save(owner, aceFile));
        menu.add("close", (Command)new Close(owner, aceFile));
        menu.add(null, (BValue)new BSeparator());
        BFileMenuAgent.addEditCommands((BMenu)menu, (BWidget)owner, (BIFile)aceFile);
        return menu;
    }

    public static class Close
    extends Command {
        BAceAppFile aceAppFile;

        public Close(BWidget owner, BAceAppFile appFile) {
            super(owner, module, "aceFile.close");
            this.aceAppFile = appFile;
            this.setEnabled(appFile.isOpen());
        }

        public CommandArtifact doInvoke() throws Exception {
            if (this.aceAppFile.isModified()) {
                String msg = BAceNetwork.LEX.getText("aceFile.confirmClose", new Object[]{this.aceAppFile.getFileName()});
                int buttons = 14;
                int result = BDialog.confirm((BWidget)this.getOwner(), null, (Object)msg, (int)buttons);
                if (result == 2) {
                    return null;
                }
                if (result == 4) {
                    this.aceAppFile.save();
                }
            }
            this.aceAppFile.close();
            return null;
        }
    }

    public static class Save
    extends Command {
        BAceAppFile aceAppFile;

        public Save(BWidget owner, BAceAppFile appFile) {
            super(owner, module, "aceFile.save");
            this.aceAppFile = appFile;
            this.setEnabled(appFile.isModified());
        }

        public CommandArtifact doInvoke() throws Exception {
            this.aceAppFile.save();
            this.getShell().repaint();
            return null;
        }
    }
}

