/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.ui;

import com.tridium.ace.enums.BAceSlotTypeEnum;
import com.tridium.driver.util.StringUtil;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.ui.theme.Theme;
import javax.baja.sys.BString;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.Lexicon;

public class BAceDialog {
    private static final Lexicon LEX = Lexicon.make((String)"ace");
    private static final String[] annoNames = new String[]{BAceSlotTypeEnum.enumRange.getTag(), BAceSlotTypeEnum.niagaraType.getTag(), "agent", "command", BAceSlotTypeEnum.fieldEditor.getTag()};

    static Object getMessageForMissingModules(String missingModules, boolean confirm) {
        String[] modules = StringUtil.getStringArray((String)missingModules, (String)"\n");
        StringBuffer[] modulesPerAnno = new StringBuffer[annoNames.length];
        for (int i = 0; i < modulesPerAnno.length; ++i) {
            modulesPerAnno[i] = new StringBuffer();
        }
        for (String module : modules) {
            BAceDialog.classifyModule(module, modulesPerAnno);
        }
        BIndentPane indent = new BIndentPane();
        BScrollPane scroll = new BScrollPane((BWidget)new BBorderPane((BWidget)indent));
        scroll.setBorderPolicy(BScrollBarPolicy.asNeeded);
        scroll.setViewportBackground(Theme.scrollPane().getControlBackground());
        BEdgePane contentPane = new BEdgePane();
        contentPane.setCenter((BWidget)scroll);
        for (int i = 0; i < annoNames.length; ++i) {
            if (modulesPerAnno[i].length() <= 1) continue;
            BString bs = BString.make((String)annoNames[i]);
            indent.add(LEX.getText("ace.missingModules.msg", new Object[]{bs}));
            indent.add(LEX.getText("ace.missingModules.consequence." + annoNames[i]));
            indent.indent();
            indent.add(modulesPerAnno[i].toString());
            indent.indent(-1);
            indent.add("\n");
        }
        if (confirm) {
            indent.add(LEX.getText("ace.missingModules.question"));
        }
        return contentPane;
    }

    public static int confirmMissingModules(BWidget parent, String missingModules) {
        String title = LEX.getText("ace.missingModules.title");
        Object message = BAceDialog.getMessageForMissingModules(missingModules, true);
        return BDialog.confirm((BWidget)parent, (String)title, (Object)message);
    }

    public static int warningMissingModules(BWidget parent, String missingModules) {
        String title = LEX.getText("ace.missingModules.title");
        Object message = BAceDialog.getMessageForMissingModules(missingModules, false);
        return BDialog.warning((BWidget)parent, (String)title, (Object)message);
    }

    static void classifyModule(String module, StringBuffer[] modulesPerAnno) {
        String[] split = module.split(":");
        for (int i = 0; i < annoNames.length; ++i) {
            if (!split[0].equals(annoNames[i])) continue;
            modulesPerAnno[i].append(split[1] + "\n");
            break;
        }
    }
}

