/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.ui;

import com.tridium.ace.BAceDevice;
import com.tridium.ace.datatypes.BAceDownloadParams;
import com.tridium.ace.datatypes.BAcePrimitive;
import com.tridium.ace.datatypes.BAceReadFileParams;
import com.tridium.ace.datatypes.BAceReadParams;
import com.tridium.ace.program.BAceAppDownloadJob;
import com.tridium.ace.program.BAceReadFileJob;
import com.tridium.ace.program.BAceViewApp;
import com.tridium.ace.sys.BAceApp;
import com.tridium.ace.sys.BAceAppFile;
import com.tridium.ace.ui.BAceDialog;
import com.tridium.driver.util.DrUtil;
import com.tridium.driver.util.StringUtil;
import com.tridium.workbench.nav.BComponentMenuAgent;
import java.io.File;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

@NiagaraType(agent={@AgentOn(types={"ace:AceDevice"})})
public class BAceDeviceMenuAgent
extends BComponentMenuAgent {
    public static final BAceDeviceMenuAgent INSTANCE = new BAceDeviceMenuAgent();
    public static final Type TYPE = Sys.loadType(BAceDeviceMenuAgent.class);
    private static final Lexicon LEX = Lexicon.make((String)"ace");
    static BImage openIcon = BImage.make((String)"module://icons/x16/open.png");

    public Type getType() {
        return TYPE;
    }

    public BMenu doMakeMenu(BWidget owner, BObject target, Context cx) {
        BMenu menu = super.doMakeMenu(owner, target, cx);
        if (!((BComponent)target).isMounted()) {
            return menu;
        }
        menu.add(null, (BValue)new BSeparator());
        menu.add("aceApplication", (BValue)new BSubMenuItem((BIMenu)BAceDeviceMenuAgent.getApplicationMenu(owner, (BAceDevice)target)));
        Property[] a = menu.getDynamicPropertiesArray();
        for (int i = 1; i < a.length - 2; ++i) {
            if (!a[i - 1].getName().equals("actions")) continue;
            Property p = a[a.length - 2];
            Property p1 = a[a.length - 1];
            System.arraycopy(a, i, a, i + 2, a.length - i - 2);
            a[i] = p;
            a[i + 1] = p1;
            break;
        }
        menu.reorder(a);
        return menu;
    }

    public int hashCode() {
        return this.toString(null).hashCode();
    }

    private static BMenu getApplicationMenu(BWidget owner, BAceDevice tgt) {
        BMenu appMenu = new BMenu(LEX.getText("aceDevice.command.app"));
        appMenu.add(null, (Command)new ViewApp(owner, tgt));
        appMenu.add(null, (Command)new DownLoadApp(owner, tgt));
        appMenu.add(null, (Command)new UpLoadApp(owner, tgt));
        appMenu.add(null, (Command)new SaveApp(owner, tgt));
        return appMenu;
    }

    static boolean verifyAceFolder(BWidget owner) {
        File f = new File(Sys.getNiagaraUserHome().getAbsolutePath() + File.separator + "ace");
        if (!f.exists()) {
            try {
                f.mkdir();
            }
            catch (Exception e) {
                BDialog.error((BWidget)owner, (Object)LEX.get("aceDevice.error.createAce"));
                return false;
            }
        }
        return true;
    }

    static BJob getJob(BOrd jobOrd, BAceDevice dev) {
        try {
            dev.getComponentSpace().sync();
            BJob job = (BJob)jobOrd.get((BObject)dev);
            return job;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static class SaveAceFile
    extends Command {
        BTextField txt;

        SaveAceFile(BWidget owner, BTextField t) {
            super(owner, "");
            this.txt = t;
        }

        public BImage getIcon() {
            return openIcon;
        }

        public CommandArtifact doInvoke() {
            BOrd file = null;
            try {
                BFileChooser c = BFileChooser.makeSave((BWidget)this.getShell());
                String fname = this.txt.getText();
                int ndx = fname.lastIndexOf(47);
                if (ndx > 0) {
                    fname = fname.substring(0, ndx);
                }
                c.setCurrentDirectory(BOrd.make((String)("local:|file:" + fname)));
                c.clearFilters();
                c.addFilter((IFileFilter)new ExtFileFilter(LEX.getText("ace.appFileDescription"), "ace"));
                c.setUpdateFilenameExtensionFromFilter(true);
                file = c.show();
            }
            catch (Throwable c) {
                // empty catch block
            }
            if (file != null) {
                OrdQuery[] q = file.parse();
                this.txt.setText(q[q.length - 1].getBody());
                this.txt.repaint();
            }
            return null;
        }
    }

    public static class BrowseAceFile
    extends Command {
        BTextField txt;

        BrowseAceFile(BWidget owner, BTextField t) {
            super(owner, "");
            this.txt = t;
        }

        public BImage getIcon() {
            return openIcon;
        }

        public CommandArtifact doInvoke() {
            BOrd file = null;
            try {
                BFileChooser c = BFileChooser.makeOpen((BWidget)this.getShell());
                c.setCurrentDirectory(BOrd.make((String)("local:|file:" + this.txt.getText())));
                c.clearFilters();
                c.addFilter((IFileFilter)new ExtFileFilter(LEX.getText("ace.appFileDescription"), "ace"));
                file = c.show();
            }
            catch (Throwable c) {
                // empty catch block
            }
            if (file != null) {
                OrdQuery[] q = file.parse();
                this.txt.setText(q[q.length - 1].getBody());
                this.txt.repaint();
            }
            return null;
        }
    }

    public static class SaveApp
    extends AceDeviceCommand {
        public SaveApp(BWidget owner, BAceDevice target) {
            super(owner, target, "aceDevice.command.saveApp");
        }

        public CommandArtifact doInvoke() {
            if (!this.verifyDev()) {
                return null;
            }
            BOrd ord = this.dev.saveAppJob();
            BJob job = BAceDeviceMenuAgent.getJob(ord, this.dev);
            if (job == null) {
                BDialog.error((BWidget)this.getOwner(), (Object)LEX.get("aceDevice.error.saveApp.job"));
            }
            return null;
        }
    }

    public static class DownLoadApp
    extends AceDeviceCommand {
        public DownLoadApp(BWidget owner, BAceDevice target) {
            super(owner, target, "aceDevice.command.downloadApp");
        }

        public CommandArtifact doInvoke() {
            try {
                BString missingModules;
                if (!this.verifyDev()) {
                    return null;
                }
                if (!BAceDeviceMenuAgent.verifyAceFolder((BWidget)this.getOwner().getShell())) {
                    return null;
                }
                BTextField tf = new BTextField("~ace", 60);
                tf.setEditable(false);
                BButton appFileBtn = new BButton((Command)new BrowseAceFile((BWidget)this.getOwner().getShell(), tf));
                appFileBtn.setButtonStyle(BButtonStyle.toolBar);
                BGridPane appFilePn = new BGridPane(2);
                appFilePn.add(null, (BValue)tf);
                appFilePn.add(null, (BValue)appFileBtn);
                int retVal = BDialog.open((BWidget)this.getOwner(), (String)LEX.getText("ace.appDownload.enterFile"), (Object)appFilePn, (int)3);
                if (retVal == 2) {
                    return null;
                }
                if (tf.getText().equals("~ace")) {
                    BDialog.error((BWidget)this.getOwner(), (String)LEX.getText("ace.appDownload.error"), (Object)LEX.getText("ace.appDownload.error.nofile"));
                    return null;
                }
                BOrd appOrd = BOrd.make((String)("file:" + tf.getText()));
                BIFile appFile = (BIFile)appOrd.resolve().get();
                if (appFile instanceof BAceAppFile && ((BAceAppFile)appFile).isModified()) {
                    BDialog.error((BWidget)this.getOwner(), (Object)LEX.getText("ace.appDownload.error.modified"));
                    return null;
                }
                byte[] a = appFile.read();
                BBlob blob = BBlob.make((byte[])a);
                BOrd[] ords = new BOrd[]{this.dev.getHandleOrd()};
                String szOrds = StringUtil.toString((BSimple[])ords);
                BAceAppDownloadJob job = this.startDownloadJob(szOrds, blob, true);
                this.waitForJobComplete(job);
                if (job.getJobState() != BJobState.success && (missingModules = job.getMissingModules()) != null) {
                    boolean confirmYes = this.getConfirmResult(missingModules);
                    if (!confirmYes) {
                        return null;
                    }
                    job = this.startDownloadJob(szOrds, blob, false);
                    this.waitForJobComplete(job);
                }
                if (job.getJobState() != BJobState.success) {
                    return null;
                }
                String title = LEX.getText("ace.appDownload.viewApp.title");
                String msg = LEX.getText("ace.appDownload.viewApp");
                if (BDialog.confirm((BWidget)this.getOwner(), (String)title, (Object)msg) != 4) {
                    return null;
                }
                return ViewApp.implViewApp(this.getOwner(), this.dev, false);
            }
            catch (Exception e) {
                BDialog.error((BWidget)this.getOwner(), (String)LEX.getText("ace.appDownload.error"), (Object)e);
                return null;
            }
        }

        private boolean getConfirmResult(BString missingModules) {
            int ret = BAceDialog.confirmMissingModules(this.getOwner(), missingModules.getString());
            boolean confirm = false;
            if (ret == 4) {
                confirm = true;
            }
            return confirm;
        }

        private BAceAppDownloadJob startDownloadJob(String szOrds, BBlob blob, boolean checkMissModules) {
            BAceDownloadParams params = new BAceDownloadParams(szOrds, "app.ace", blob, checkMissModules);
            BOrd ord = this.dev.getAceNetwork().downloadApp(params);
            BAceAppDownloadJob job = (BAceAppDownloadJob)BAceDeviceMenuAgent.getJob(ord, this.dev);
            return job;
        }

        private void waitForJobComplete(BAceAppDownloadJob job) {
            for (int cnt = 0; !job.getJobState().isComplete() && cnt < 600; ++cnt) {
                DrUtil.wait((int)500);
            }
        }
    }

    public static class UpLoadApp
    extends AceDeviceCommand {
        public UpLoadApp(BWidget owner, BAceDevice target) {
            super(owner, target, "aceDevice.command.uploadApp");
        }

        public CommandArtifact doInvoke() {
            try {
                if (!this.verifyDev()) {
                    return null;
                }
                if (!BAceDeviceMenuAgent.verifyAceFolder((BWidget)this.getOwner().getShell())) {
                    return null;
                }
                this.dev.saveApp();
                BAcePrimitive prim = this.dev.readProp(BAceReadParams.make((int)0, (int)2));
                String appName = prim.getString();
                String def = appName.length() > 0 ? "~ace/" + appName + ".ace" : "~ace";
                BTextField tf = new BTextField(def, 60);
                tf.setEditable(false);
                BButton appFileBtn = new BButton((Command)new SaveAceFile((BWidget)this.getOwner().getShell(), tf));
                appFileBtn.setButtonStyle(BButtonStyle.toolBar);
                BGridPane appFilePn = new BGridPane(2);
                appFilePn.add(null, (BValue)tf);
                appFilePn.add(null, (BValue)appFileBtn);
                int retVal = BDialog.open((BWidget)this.getOwner(), (String)LEX.getText("ace.appUpload.enterFile"), (Object)appFilePn, (int)3);
                if (retVal == 2) {
                    return null;
                }
                FilePath fp = new FilePath(tf.getText());
                BOrd dirOrd = BOrd.make((OrdQuery)fp.getParent());
                BDirectory dir = (BDirectory)dirOrd.resolve().get();
                BIFile appFile = dir.getFileSpace().makeFile(fp);
                if (appFile instanceof BAceAppFile && ((BAceAppFile)appFile).isModified()) {
                    BDialog.error((BWidget)this.getOwner(), (Object)LEX.getText("ace.appUpload.error.modified"));
                    return null;
                }
                BAceReadFileParams params = new BAceReadFileParams(this.dev.getHandleOrd(), "app.ace");
                BOrd ord = this.dev.getAceNetwork().uploadApp(params);
                BJob job = BAceDeviceMenuAgent.getJob(ord, this.dev);
                for (int cnt = 0; !job.getJobState().isComplete() && cnt < 600; ++cnt) {
                    DrUtil.wait((int)500);
                }
                if (job.getJobState() != BJobState.success) {
                    appFile.delete();
                    return null;
                }
                BAceReadFileJob readJob = (BAceReadFileJob)job;
                appFile.getOutputStream().write(readJob.getData().copyBytes());
                return null;
            }
            catch (Exception e) {
                BDialog.error((BWidget)this.getOwner(), (String)LEX.getText("ace.appUpload.error"), (Object)e);
                return null;
            }
        }
    }

    public static class ViewApp
    extends AceDeviceCommand {
        public ViewApp(BWidget owner, BAceDevice target) {
            super(owner, target, "aceDevice.command.viewApp");
        }

        public CommandArtifact doInvoke() {
            if (!this.verifyDev()) {
                return null;
            }
            return ViewApp.implViewApp(this.getOwner(), this.dev, true);
        }

        public static CommandArtifact implViewApp(BWidget owner, BAceDevice dev, boolean checkMissingModules) {
            BOrd ord = dev.viewApp();
            BAceViewApp job = (BAceViewApp)BAceDeviceMenuAgent.getJob(ord, dev);
            if (job == null) {
                BDialog.error((BWidget)owner, (Object)LEX.get("aceDevice.error.viewApp.job"));
                return null;
            }
            for (int cnt = 0; !job.getJobState().isComplete() && cnt < 600; ++cnt) {
                DrUtil.wait((int)500);
            }
            if (job.getJobState() == BJobState.success) {
                BString missingModules;
                if (checkMissingModules && (missingModules = job.getMissingModules()) != null) {
                    BAceDialog.warningMissingModules(owner, missingModules.getString());
                }
                dev.getComponentSpace().update((BComponent)dev, 1);
                BAceApp app = (BAceApp)dev.get("App");
                if (app != null) {
                    ((BWbShell)owner.getShell()).hyperlink(app.getNavOrd());
                    return null;
                }
            } else {
                BDialog.error((BWidget)owner, (Object)LEX.get("aceDevice.error.viewApp.job"));
                return null;
            }
            BDialog.error((BWidget)owner, (Object)LEX.get("aceDevice.error.viewApp"));
            return null;
        }
    }

    public static class AceDeviceCommand
    extends Command {
        BAceDevice dev;

        public AceDeviceCommand(BWidget owner, BAceDevice target, String key) {
            super(owner, LEX.get(key));
            this.dev = target;
        }

        boolean verifyDev() {
            if (this.dev.getStatus().isDisabled()) {
                BDialog.error((BWidget)this.getOwner(), (Object)LEX.get("aceDevice.error.deviceDisabled"));
                return false;
            }
            if (this.dev.getStatus().isFault()) {
                BDialog.error((BWidget)this.getOwner(), (Object)LEX.get("aceDevice.error.deviceFault"));
                return false;
            }
            return true;
        }
    }
}

