/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mobile.px.ui;

import com.tridium.mobile.px.ui.BBasicMobilePane;
import com.tridium.mobile.px.ui.BIMobilePane;
import com.tridium.mobile.px.ui.BMobileGridPane;
import com.tridium.mobile.px.ui.BMobilePxMedia;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.baja.agent.BDynamicPxView;
import javax.baja.agent.BPxView;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFile;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BCanvasPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.px.PxDecoder;
import javax.baja.ui.px.PxEncoder;
import javax.baja.util.BTypeSpec;

public final class BPxToMobilePx
extends BDynamicPxView {
    public static final Property pxView = BPxToMobilePx.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (String)"wbutil:PxViewSelectFE"));
    public static final Type TYPE = Sys.loadType(BPxToMobilePx.class);
    private static final BTypeSpec mobilePxMedia = BTypeSpec.make((String)"mobile:MobilePxMedia");

    public String getPxView() {
        return this.getString(pxView);
    }

    public void setPxView(String v) {
        this.setString(pxView, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BFacets getSlotFacets(Slot slot) {
        BComponent comp = this.getParentComponent();
        if (comp != null && comp.isMounted() && slot == pxView) {
            return BFacets.make((BFacets)super.getSlotFacets(slot), (String)"handleOrd", (BIDataValue)BString.make((String)comp.getHandleOrd().toString()));
        }
        return super.getSlotFacets(slot);
    }

    public BTypeSpec getMedia() {
        return mobilePxMedia;
    }

    @NiagaraRpc(transports={@Transport(type=TransportType.fox)}, permissions="r")
    public String generateXml(Object arg, Context context) {
        BComponent comp = this.getParentComponent();
        comp.loadSlots();
        BPxView pxView = null;
        String pxViewName = this.getPxView();
        BPxView[] views = (BPxView[])comp.getChildren(BPxView.class);
        if (views.length == 0) {
            throw new BajaRuntimeException("Could not find any available Px Views");
        }
        if (pxViewName.equals("")) {
            pxView = views[0];
        } else {
            for (int i = 0; i < views.length; ++i) {
                if (!views[i].getName().equals(pxViewName)) continue;
                pxView = views[i];
                break;
            }
        }
        if (pxView == null) {
            throw new BajaRuntimeException("Could not find Px View: " + pxViewName);
        }
        try {
            BIFile file = (BIFile)pxView.getPxFile().get((BObject)comp);
            BWidget root = new PxDecoder(file).decodeDocument();
            Object newRoot = null;
            if (root instanceof BIMobilePane) {
                newRoot = root;
            } else {
                newRoot = new BBasicMobilePane();
                this.convert(root, (BWidget)newRoot);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            new PxEncoder((OutputStream)out).encodeDocument(newRoot);
            return new String(out.toByteArray());
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    private void convert(BWidget oldWidget, BWidget newWidget) {
        Property[] kidProps = oldWidget.getPropertiesArray();
        for (int i = 0; i < kidProps.length; ++i) {
            if (kidProps[i].getType().is(BLink.TYPE) || Flags.isTransient((BComplex)oldWidget, (Slot)kidProps[i])) continue;
            BValue val = oldWidget.get(kidProps[i]);
            if (kidProps[i].getType().is(BWidget.TYPE)) {
                BWidget w = (BWidget)val;
                Object newW = newWidget;
                if (BMobilePxMedia.INSTANCE.isWidgetSupported(w.getType().getTypeInfo()) && !w.getType().is(BCanvasPane.TYPE) && !w.getType().is(BScrollPane.TYPE) && !w.getType().is(BBorderPane.TYPE) || w.getType().is(BGridPane.TYPE)) {
                    if (w.getType().is(BGridPane.TYPE)) {
                        BGridPane gridPane = (BGridPane)w;
                        newW = new BMobileGridPane(Math.min(gridPane.getColumnCount(), 5));
                    } else {
                        newW = (BWidget)w.newCopy(true);
                    }
                    newW.removeAll();
                    newWidget.add(kidProps[i].getName() + "?", (BValue)newW, oldWidget.getFlags((Slot)kidProps[i]), oldWidget.getSlotFacets((Slot)kidProps[i]), null);
                }
                this.convert(w, (BWidget)newW);
                continue;
            }
            if (!kidProps[i].isDynamic()) continue;
            newWidget.add(kidProps[i].getName() + "?", val.newCopy(true), oldWidget.getFlags((Slot)kidProps[i]), oldWidget.getSlotFacets((Slot)kidProps[i]), null);
        }
    }
}

