/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.driver.history.ui;

import com.tridium.obix.driver.history.BObixHistoryDeviceExt;
import com.tridium.obix.driver.history.BObixHistoryDiscoveryJob;
import com.tridium.obix.driver.history.BObixHistoryDiscoveryResult;
import com.tridium.obix.driver.history.BObixHistoryImport;
import com.tridium.obix.driver.history.ui.BObixHistoryManager;
import com.tridium.obix.driver.history.ui.ObixHistoryModel;
import com.tridium.obix.driver.ui.BObixLearnTable;
import javax.baja.driver.ui.history.ArchiveModel;
import javax.baja.gx.BImage;
import javax.baja.history.BHistoryId;
import javax.baja.job.BJob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Type;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class ObixHistoryLearn
extends MgrLearn {
    private static BImage historyImg = BImage.make((BIcon)BIcon.std((String)"history.png"));
    private static BImage obixImg = BImage.make((BIcon)BIcon.std((String)"obix.png"));
    private static BImage objImg = BImage.make((BIcon)BIcon.std((String)"object.png"));
    BObixHistoryDiscoveryJob obixJob;

    public ObixHistoryLearn(BObixHistoryManager mgr) {
        super((BAbstractManager)mgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChildren(Object discovered) {
        try {
            this.getManager().enterBusy();
            BObixHistoryDiscoveryResult r = ObixHistoryLearn.x(discovered);
            Object[] objectArray = r.getChildren(this.obixJob);
            return objectArray;
        }
        finally {
            this.getManager().exitBusy();
        }
    }

    public BImage getIcon(Object discovered) {
        if (!ObixHistoryLearn.x(discovered).getQuery().equals("")) {
            return historyImg;
        }
        if (ObixHistoryLearn.x(discovered).getObixName().equals("lobby")) {
            return obixImg;
        }
        return objImg;
    }

    public boolean hasChildren(Object discovered) {
        BObixHistoryDiscoveryResult r = ObixHistoryLearn.x(discovered);
        return r.getKids().getSlotCount() > 0;
    }

    public boolean isDepthExpandable(int depth) {
        return true;
    }

    public boolean isExisting(Object discovered, BComponent db) {
        BObixHistoryDiscoveryResult res = ObixHistoryLearn.x(discovered);
        if (db instanceof BObixHistoryImport) {
            return ObixHistoryLearn.proxy(db).getHref().equals(res.getHref());
        }
        return false;
    }

    public boolean isGroup(Object discovered) {
        return false;
    }

    public boolean isMatchable(Object discovered, BComponent db) {
        return this.isGroup(discovered) && db instanceof BObixHistoryImport;
    }

    public void jobComplete(BJob job) {
        this.obixJob = (BObixHistoryDiscoveryJob)job;
        job.lease(Integer.MAX_VALUE);
        this.updateRoots(job.getChildComponents());
    }

    protected BLearnTable makeTable() {
        return new BObixLearnTable(this);
    }

    public void toRow(Object discovered, MgrEditRow row) throws Exception {
        BObixHistoryDiscoveryResult res = ObixHistoryLearn.x(discovered);
        ObixHistoryModel m = (ObixHistoryModel)this.getManager().getModel();
        row.setDefaultName(res.getObixName());
        row.setCell(m.href, (BValue)BString.make((String)res.getQuery()));
        BHistoryId hid = BHistoryId.make((String)((BObixHistoryDeviceExt)this.getManager().getCurrentValue()).getDevice().getName(), (String)res.getObixName());
        row.setCell(((ArchiveModel)this.getManager().getModel()).idCol, (BValue)hid);
    }

    public MgrTypeInfo[] toTypes(Object discovered) {
        BObixHistoryDiscoveryResult res = ObixHistoryLearn.x(discovered);
        if (res.isHistory()) {
            return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BObixHistoryImport.TYPE)};
        }
        return new MgrTypeInfo[0];
    }

    public void updateTable() {
        this.getTable().getSelection().deselectAll();
        ((BObixLearnTable)this.getTable()).treeTableModel.updateTreeTable(true);
    }

    protected MgrColumn[] makeColumns() {
        return new MgrColumn[]{new MgrColumn.Prop(BObixHistoryDiscoveryResult.obixName), new MgrColumn.Prop(BObixHistoryDiscoveryResult.href), new MgrColumn.Prop(BObixHistoryDiscoveryResult.start), new MgrColumn.Prop(BObixHistoryDiscoveryResult.end), new MgrColumn.Prop(BObixHistoryDiscoveryResult.count), new MgrColumn.Prop(BObixHistoryDiscoveryResult.query)};
    }

    private static BObixHistoryImport proxy(Object o) {
        return (BObixHistoryImport)o;
    }

    private static BObixHistoryDiscoveryResult x(Object discovered) {
        return (BObixHistoryDiscoveryResult)discovered;
    }
}

