/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonProTransform.functions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.seriestransform.graph.BTransformFunction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BEnumModeFunction
extends BTransformFunction {
    public static final Type TYPE = Sys.loadType(BEnumModeFunction.class);
    private static final Lexicon lex = Lexicon.make(BEnumModeFunction.class);
    private static final String FUNCTION_NAME = lex.getText("functions.name.enumMode");
    private static final String FUNCTION_DESC = lex.getText("functions.desc.enumMode");

    public Type getType() {
        return TYPE;
    }

    public void applyFunction(Map series, String[] srcProps, Property destProp, BComplex resultRecord) throws TransformException {
        BDynamicEnum result = null;
        HashMap<Integer, Integer> hash = new HashMap<Integer, Integer>();
        for (int i = 0; i < srcProps.length; ++i) {
            String name = srcProps[i];
            List records = this.getSeriesRecords(series, BEnumModeFunction.getSeriesName((String)name));
            if (records == null) continue;
            for (BComplex record : records) {
                Property field = record.getProperty(BEnumModeFunction.getFieldName((String)name));
                BValue value = record.get(field);
                try {
                    BDynamicEnum de = (BDynamicEnum)value;
                    Integer ordinal = new Integer(de.getOrdinal());
                    Integer mapValue = (Integer)hash.get(ordinal);
                    if (mapValue == null) {
                        hash.put(ordinal, new Integer(0));
                        continue;
                    }
                    int intValue = mapValue;
                    hash.put(ordinal, new Integer(++intValue));
                }
                catch (Exception e) {
                    System.out.println("Failed to determine value for field " + field);
                    e.printStackTrace();
                }
            }
        }
        int maxValue = Integer.MIN_VALUE;
        int maxKey = Integer.MIN_VALUE;
        for (Integer key : hash.keySet()) {
            Integer value = (Integer)hash.get(key);
            if (value <= maxValue) continue;
            maxValue = value;
            maxKey = key;
        }
        result = BDynamicEnum.make((int)maxKey);
        BEnumModeFunction.setRecordValue((BComplex)resultRecord, (Property)destProp, (BValue)result);
    }

    public Type[] getArgumentTypes() {
        Type[] types = new Type[]{BDynamicEnum.TYPE};
        return types;
    }

    public String getFunctionDesc() {
        return FUNCTION_DESC;
    }

    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    public Type getReturnType() {
        return BDynamicEnum.TYPE;
    }
}

