/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.util;

import com.tridium.lonworks.device.DeviceFacets;
import com.tridium.lonworks.file.LonFileReadWrite;
import com.tridium.lonworks.file.LonFileTransfer;
import com.tridium.lonworks.file.NoDirectoryException;
import javax.baja.lonworks.BINetworkVariable;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.lonworks.LonException;

public abstract class LonFile {
    public static final boolean ALLOW_RANDOM_ACCESS = true;
    public static final boolean NO_RANDOM_ACCESS = false;
    public static final boolean CREATE_FILE = true;
    public static final boolean ACCESS_FILE = false;
    public static final int CONFIG_TEMPLATE_FILE = 0;
    public static final int READ_WRITE_CONFIG_FILE = 1;
    public static final int READ_ONLY_CONFIG_FILE = 2;
    public static final int CONFIG_PARAM_TEMPLATE_FILE = 2;
    public static final int CONFIG_PARAM_VALUE_FILE = 1;

    public static LonFile createFile(BLonDevice dev) throws LonException {
        LonFile file = null;
        BINetworkVariable[] nvs = dev.getNetworkVariables();
        BNetworkVariable dirNv = LonFile.findNvByObjectAndType(dev, nvs, 114);
        if (dirNv != null) {
            file = new LonFileReadWrite(dev, dirNv);
        } else {
            BNetworkVariable statNv;
            BNetworkVariable reqNv = LonFile.findNvByObjectAndType(dev, nvs, 73);
            if (reqNv != null && (statNv = LonFile.findNvByObjectAndType(dev, nvs, 74)) != null) {
                BNetworkVariable posNv = LonFile.findNvByObjectAndType(dev, nvs, 90);
                try {
                    file = new LonFileTransfer(dev, reqNv, statNv, posNv);
                }
                catch (NoDirectoryException e) {
                    dev.log().warning(dev.getDisplayName(null) + " has file snvts but reports no file directory");
                    return null;
                }
            } else {
                return null;
            }
        }
        return file;
    }

    private static BNetworkVariable findNvByObjectAndType(BLonDevice dev, BINetworkVariable[] nvs, int snvtType) {
        int nodObjNdx = DeviceFacets.getNodeObjectIndex(dev);
        for (int i = 0; i < nvs.length; ++i) {
            BNetworkVariable nv;
            if (nvs[i] == null || !nvs[i].isNetworkVariable() || (nv = (BNetworkVariable)nvs[i]).getNvProps().getObjectIndex() != nodObjNdx || nv.getSnvtType() != snvtType) continue;
            return nv;
        }
        return null;
    }

    public abstract LonFile copy();

    public abstract void open(int var1, boolean var2, boolean var3) throws LonException;

    public abstract byte[] read(int var1, int var2) throws LonException;

    public abstract byte[] read(int var1) throws LonException;

    public abstract byte[] read() throws LonException;

    public abstract void write(byte[] var1, int var2) throws LonException;

    public abstract void write(byte[] var1) throws LonException;

    public abstract void close() throws LonException;

    public abstract void flush() throws LonException;

    public abstract String getDirectoryString() throws LonException;

    public abstract int findFileNum(int var1);

    public abstract int findFileNum(int var1, int var2);

    public abstract boolean isOpen();

    public boolean supportsRandomAccess() {
        return true;
    }
}

