/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.proxy;

import com.tridium.lonworks.util.NmUtil;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.point.BTuningPolicy;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.lonworks.enums.BLonLinkType;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.proxy.BLonPointDeviceExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;
import javax.baja.util.Worker;

public abstract class BLonProxyExt
extends BProxyExt {
    public static final Property tuningPolicyName = BLonProxyExt.newProperty((int)5, (String)"defaultProxyPolicy", null);
    public static final Property status = BLonProxyExt.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property deviceFacets = BLonProxyExt.newProperty((int)1, (BValue)BFacets.NULL, null);
    public static final Property targetComp = BLonProxyExt.newProperty((int)8, (String)"value", null);
    public static final Property targetName = BLonProxyExt.newProperty((int)8, (String)"value", null);
    public static final Property linkType = BLonProxyExt.newProperty((int)0, (BValue)BLonLinkType.standard, null);
    public static final Property priority = BLonProxyExt.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BLonProxyExt.class);
    Worker wrkr = null;
    ProxyRequest req = null;
    private static final String RESOLVE_FAULT_MSG = "Can not resolve target: ";
    protected BLonData datPnt = null;
    protected Property targetProp = null;
    private boolean isDataPointWriteable = true;
    private int dataPntMismatchCount = 0;
    private boolean dataPntSubscribed = false;

    public String getTargetComp() {
        return this.getString(targetComp);
    }

    public void setTargetComp(String v) {
        this.setString(targetComp, v, null);
    }

    public String getTargetName() {
        return this.getString(targetName);
    }

    public void setTargetName(String v) {
        this.setString(targetName, v, null);
    }

    public BLonLinkType getLinkType() {
        return (BLonLinkType)this.get(linkType);
    }

    public void setLinkType(BLonLinkType v) {
        this.set(linkType, (BValue)v, null);
    }

    public boolean getPriority() {
        return this.getBoolean(priority);
    }

    public void setPriority(boolean v) {
        this.setBoolean(priority, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BLonProxyExt() {
    }

    public BLonProxyExt(OrdTarget ordTgt) {
        BComponent comp = ordTgt.getComponent();
        BLonDevice dev = this.getLonDevice(comp);
        String tgtCmp = comp.getSlotPath().toString().substring(dev.getSlotPath().toString().length() + 1);
        this.setTargetComp(tgtCmp);
        this.setTargetName(ordTgt.getSlotInComponent().getName());
    }

    private BLonDevice getLonDevice(BComponent c) {
        while (!(c instanceof BLonDevice)) {
            c = (BComponent)c.getParent();
        }
        return (BLonDevice)c;
    }

    public Type getDeviceExtType() {
        return BLonPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return this.isDataPointWriteable ? BReadWriteMode.writeonly : BReadWriteMode.readonly;
    }

    public final void readSubscribed(Context cx) throws Exception {
        BLonData dataPoint = this.getDataPoint();
        if (dataPoint != null && !this.dataPntSubscribed) {
            dataPoint.readSubscribed();
            this.dataPntSubscribed = true;
        }
    }

    public final void readUnsubscribed(Context cx) throws Exception {
        BLonData dataPoint = this.datPnt;
        if (dataPoint != null && this.dataPntSubscribed) {
            dataPoint.readUnsubscribed();
            this.dataPntSubscribed = false;
        }
    }

    public boolean write(Context cx) throws Exception {
        if (!this.isDataPointWriteable || this.isUnoperational()) {
            return false;
        }
        Worker w = this.getProxyQueue();
        if (w == null || !w.isRunning()) {
            return false;
        }
        try {
            ((Queue)w.getTodo()).enqueue((Object)this.getRequest(cx));
        }
        catch (Throwable e) {
            this.doProxyWrite(cx);
        }
        return false;
    }

    public final void forceUpdate() {
        this.doProxyWrite(BLonNetwork.lonNoWrite);
    }

    private void doProxyWrite(Context cx) {
        if (this.isUnoperational()) {
            return;
        }
        try {
            boolean stateWrite;
            BStatusValue value = this.getWriteValue();
            if (value.getStatus().isNull()) {
                return;
            }
            BLonData dataPoint = this.getDataPoint();
            if (dataPoint == null) {
                return;
            }
            BLonPrimitive prim = this.getPrimitiveValue(value);
            if (prim == null) {
                this.writeFail("Unable to convert status value to lonPrimitive.");
                return;
            }
            boolean bl = stateWrite = cx == BTuningPolicy.maxWriteTimeContext || cx == BTuningPolicy.writeOnStartContext || cx == BTuningPolicy.writeOnUpContext || cx == BTuningPolicy.writeOnEnabledContext;
            if (!stateWrite) {
                dataPoint.set(this.targetProp, (BValue)prim, cx);
            }
        }
        catch (Throwable e) {
            this.writeFail(e.toString());
        }
    }

    private Worker getProxyQueue() {
        if (this.wrkr == null) {
            this.wrkr = ((BLonNetwork)((BLonDevice)this.getDevice()).getNetwork()).getProxyQueue();
        }
        return this.wrkr;
    }

    private Runnable getRequest(Context cx) {
        if (this.req == null) {
            this.req = new ProxyRequest();
        }
        this.req.setContext(cx);
        return this.req;
    }

    public final void started() throws Exception {
        BLonComponent lc;
        super.started();
        this.setStale(false, null);
        this.registerProxy(this.getDataPoint());
        this.checkIfWriteable();
        this.extStarted();
        if (this.getLinkType() == BLonLinkType.unknown && (lc = this.getLonComponent()) != null && lc.isNetworkVariable()) {
            this.setLinkType(NmUtil.getLinkType(((BNetworkVariable)lc).getNvConfigData()));
        }
    }

    protected void extStarted() {
        this.setReadValue(this.getStatusValue());
    }

    public final void stopped() throws Exception {
        try {
            this.unregisterProxy();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.stopped();
    }

    private void registerProxy(BLonData dataPoint) {
        if (dataPoint != null) {
            if (this.isSubscribedDesired() && !this.dataPntSubscribed) {
                dataPoint.readSubscribed();
                this.dataPntSubscribed = true;
            }
            dataPoint.registerProxyExt(this);
        }
    }

    private void unregisterProxy() {
        BLonData dataPoint = this.datPnt;
        if (dataPoint != null) {
            if (this.dataPntSubscribed) {
                dataPoint.readUnsubscribed();
                this.dataPntSubscribed = false;
            }
            dataPoint.unregisterProxyExt(this);
        }
    }

    public boolean isReadWriteProxy() {
        return false;
    }

    public void changed(Property prop, Context context) {
        try {
            if (!this.isRunning()) {
                return;
            }
            if (prop == targetName || prop == targetComp) {
                this.renew();
            }
        }
        finally {
            super.changed(prop, context);
        }
    }

    public BLonComponent getLonComponent() {
        BLonData dataPoint = this.datPnt;
        if (dataPoint == null) {
            return null;
        }
        return dataPoint.getLonComponent();
    }

    public void renew() {
        this.renew(false);
    }

    public void renew(boolean updateFacets) {
        this.unregisterProxy();
        this.datPnt = null;
        if (updateFacets) {
            this.deviceFacetsChanged();
        }
        this.registerProxy(this.getDataPoint());
    }

    protected void deviceFacetsChanged() {
    }

    public BLonData getDataPoint() {
        BLonData orig = this.datPnt;
        this.resolveProxyLink();
        if (orig != null && this.datPnt != null && orig != this.datPnt) {
            System.out.println(NmUtil.timeStamp() + " resolveProxyLink found new object orig=" + orig.getHandle() + " isMounted=" + orig.isMounted() + " new=" + this.datPnt.getHandle() + " isMounted=" + this.datPnt.isMounted());
            ++((BLonNetwork)this.getLonDevice((BComponent)this).getNetwork()).dataPntMismatchCount;
            ++this.dataPntMismatchCount;
            this.registerProxy(this.datPnt);
        }
        return this.datPnt;
    }

    private void resolveProxyLink() {
        BComponent refPoint = null;
        try {
            BLonDevice dev = this.getLonDevice((BComponent)this);
            BOrd tgtOrd = BOrd.make((String)("slot:" + this.getTargetComp()));
            refPoint = (BComponent)tgtOrd.get((BObject)dev);
            this.targetProp = refPoint.getProperty(this.getTargetName());
        }
        catch (Throwable e) {
            refPoint = null;
        }
        if (refPoint == null || this.targetProp == null) {
            if (this.datPnt != null) {
                System.out.println("\nunable to re-resolve proxy reference for " + this.getDevice().getDisplayName(null) + ":" + this.getParent().getDisplayName(null) + ":" + this.datPnt.getDisplayName(null));
                System.out.println("getTargetComp()=" + this.getTargetComp() + " getTargetName()=" + this.getTargetName());
                System.out.println("previous datPnt.isMounted()=" + this.datPnt.isMounted() + " handle=" + this.datPnt.getHandle());
                System.out.println();
            }
            this.datPnt = null;
            this.setFaultCause(RESOLVE_FAULT_MSG + this.toString(null));
            this.setStatus(BStatus.fault);
            this.executePoint();
            throw new UnresolvedException("Cannot resolve proxyLink in " + this.getDevice().getDisplayName(null) + ":" + this.getParent().getDisplayName(null));
        }
        if (this.getStatus().isFault() && this.getFaultCause().indexOf(RESOLVE_FAULT_MSG) >= 0) {
            this.setFaultCause("");
            this.setStatus(BStatus.ok);
            this.getTuning().writeDesired();
        }
        this.datPnt = (BLonData)refPoint;
    }

    protected abstract BLonPrimitive getPrimitiveValue(BStatusValue var1);

    public final BStatusValue getStatusValue() {
        BLonPrimitive target = this.getTarget();
        if (target == null) {
            return null;
        }
        return this.getStatusValue(target);
    }

    protected final BLonPrimitive getTarget() {
        BLonPrimitive target;
        BLonData dataPoint = this.getDataPoint();
        if (dataPoint == null || this.targetProp == null) {
            return null;
        }
        try {
            target = (BLonPrimitive)dataPoint.get(this.targetProp);
        }
        catch (Exception e) {
            System.out.println("ERROR: no property " + this.targetProp.getName() + " in " + dataPoint.getDisplayName(null));
            return null;
        }
        return target;
    }

    public abstract BStatusValue getStatusValue(BLonPrimitive var1);

    public String toString(Context c) {
        return this.getTargetComp() + "/" + this.getTargetName();
    }

    private void checkIfWriteable() {
        BLonComponent lc = this.getLonComponent();
        this.isDataPointWriteable = this.getParentPoint().isWritablePoint() && lc.isWriteable();
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        BLonData dataPoint = this.datPnt;
        out.startProps();
        out.trTitle((Object)"LonProxyExt", 2);
        BLonComponent lc = this.getLonComponent();
        out.prop((Object)"lonComponent", (Object)(lc == null ? "null" : lc.getName()));
        if (dataPoint == null) {
            out.prop((Object)"dataPoint", (Object)"null");
        } else {
            out.prop((Object)"dataPoint", (Object)dataPoint.getName());
            out.prop((Object)"dataPoint.handle", dataPoint.getHandle());
            out.prop((Object)"dataPoint.isMounted", dataPoint.isMounted());
            String name = dataPoint.getName();
            this.spySlot_(out, name, dataPoint.getSlotPath().getBody(), this.getFlags((Slot)this.targetProp), (Object)dataPoint);
        }
        out.prop((Object)"targetProp", (Object)(this.targetProp == null ? "null" : this.targetProp.getName()));
        out.prop((Object)"isDataPointWriteable", this.isDataPointWriteable);
        if (dataPoint != null && this.targetProp != null) {
            out.prop((Object)"primitive val", (Object)dataPoint.get(this.targetProp).toString(null));
        }
        out.prop((Object)"dataPntMismatchCount", this.dataPntMismatchCount);
        out.prop((Object)"dataPointSubscribed", this.dataPntSubscribed);
        out.endProps();
    }

    private void spySlot_(SpyWriter out, String name, String slotPath, int flags, Object value) {
        out.w((Object)"<tr><td align='left' nowrap='true'><b>").a("/nav/localhost/station" + slotPath, (Object)name).w((Object)"</b>");
        if (flags == 0) {
            out.w((Object)"{0}");
        } else {
            out.w((Object)" {").w((Object)Flags.encodeToString((int)flags)).w((Object)"}");
        }
        out.w((Object)"</td><td align='left' nowrap='true'>").w(value).w((Object)"</td></tr>\n");
    }

    private class ProxyRequest
    implements Runnable {
        Context cx = null;

        private ProxyRequest() {
        }

        @Override
        public void run() {
            BLonProxyExt.this.doProxyWrite(this.cx);
        }

        public void setContext(Context cx) {
            this.cx = cx;
        }
    }
}

