/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.proxy;

import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.data.BIDataValue;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonEnum;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.proxy.BLonProxyExt;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BLonEnumProxyExt
extends BLonProxyExt {
    public static final Property readValue = BLonEnumProxyExt.newProperty((int)3, (BValue)new BStatusEnum(), null);
    public static final Property writeValue = BLonEnumProxyExt.newProperty((int)3, (BValue)new BStatusEnum(), null);
    public static final Type TYPE = Sys.loadType(BLonEnumProxyExt.class);
    private boolean nullSpecified = false;
    private int nullVal;

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void extStarted() {
        this.checkFacets();
        this.updateFacets();
        BEnumRange range = (BEnumRange)this.getDeviceFacets().getFacet("range");
        if (range == null || range.getOrdinals().length == 0) {
            this.getDevice().getLogger().warning("Invalid range for enum proxy in " + this.getDevice().getDisplayName(null) + ":" + this.getDisplayName(null));
            return;
        }
        BDynamicEnum en = BDynamicEnum.make((int)range.getOrdinals()[0], (BEnumRange)range);
        BLonPrimitive tgt = this.getTarget();
        BEnum v = tgt.getDataAsEnum((BEnum)en);
        this.setReadValue((BStatusValue)new BStatusEnum(v));
    }

    public void pointFacetsChanged() {
        this.updateFacets();
        super.pointFacetsChanged();
        this.checkFacets();
    }

    private void updateFacets() {
        BFacets f = ((BControlPoint)this.getParent()).getFacets();
        BFacets DeviceFacets2 = this.getDeviceFacets();
        BIDataValue idv = (BIDataValue)f.get("range");
        if (idv == null) {
            return;
        }
        this.setDeviceFacets(BFacets.make((BFacets)DeviceFacets2, (String)"range", (BIDataValue)idv));
    }

    @Override
    protected void deviceFacetsChanged() {
        BLonPrimitive tgt = this.getTarget();
        if (tgt == null || !tgt.getType().is(BLonEnum.TYPE)) {
            return;
        }
        BEnumRange rng = ((BLonEnum)tgt).getEnum().getRange();
        BFacets cpFacets = ((BControlPoint)this.getParent()).getFacets();
        BFacets newFacets = BFacets.make((BFacets)cpFacets, (String)"range", (BIDataValue)rng);
        ((BControlPoint)this.getParent()).setFacets(newFacets);
    }

    @Override
    public BStatusValue getStatusValue(BLonPrimitive newValue) {
        BStatusEnum msElem = (BStatusEnum)((BEnumPoint)this.getParent()).getOutStatusValue();
        BEnum v = newValue.getDataAsEnum((BEnum)msElem.getValue());
        BStatusEnum sEnum = new BStatusEnum(v);
        if (this.nullSpecified && v.getOrdinal() == this.nullVal) {
            sEnum.setStatusNull(true);
        }
        return sEnum;
    }

    @Override
    public BLonPrimitive getPrimitiveValue(BStatusValue value) {
        BLonData dataPoint = this.getDataPoint();
        BDynamicEnum val = ((BStatusEnum)value).getValue();
        return ((BLonPrimitive)dataPoint.get(this.targetProp)).makeFromEnum((BEnum)val);
    }

    private void checkFacets() {
        BControlPoint cp = (BControlPoint)this.getParent();
        BFacets pntFcts = cp.getFacets();
        int n = pntFcts.geti("isNull", Integer.MAX_VALUE);
        if (n == Integer.MAX_VALUE) {
            this.nullSpecified = false;
        } else {
            this.nullSpecified = true;
            this.nullVal = n;
        }
    }
}

