/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.londata;

import java.util.HashMap;
import javax.baja.data.BIDataValue;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.enums.BLonElementType;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonElementQualifiers;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.units.BUnit;

public class LonFacetsUtil {
    public static final String TYPE = "type";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String RES = "res";
    public static final String OFF = "off";
    public static final String BYT = "byt";
    public static final String BIT = "bit";
    public static final String LEN = "len";
    public static final String INVLD = "invld";
    public static final String UNITS = "units";

    public static BLonElementQualifiers getElementQualifiers(BLonData londata, Property prop) throws LonException {
        BLonElementQualifiers e = LonFacetsUtil.getQualifiers(prop.getFacets());
        if (e.hasOffset()) {
            return e;
        }
        return BLonElementQualifiers.make(e.getElemtype(), e.hasMinimum(), e.getMinimum(), e.hasMaximum(), e.getMaximum(), e.getResolution(), e.getOffset(), true, LonFacetsUtil.getByteOffset(londata, prop), 0, e.hasInvalidValue(), e.getInvalidValue(), e.getLength());
    }

    private static int getByteOffset(BLonData londata, Property prop) {
        EqSearch eqs = new EqSearch();
        eqs.sLd = londata;
        eqs.prop = prop;
        BLonData ld = londata;
        while (ld.getParent() instanceof BLonData) {
            ld = (BLonData)ld.getParent();
        }
        LonFacetsUtil.getByteOffset(eqs, ld);
        return eqs.offset;
    }

    private static void getByteOffset(EqSearch eqs, BLonData ld) {
        SlotCursor c = ld.getProperties();
        while (c.nextObject()) {
            BValue obj = c.get();
            if (BLonData.class.isInstance(obj)) {
                LonFacetsUtil.getByteOffset(eqs, (BLonData)obj);
                if (!eqs.found) continue;
                return;
            }
            if (!BLonPrimitive.class.isInstance(obj)) continue;
            Property prop = c.property();
            if (prop == eqs.prop && ld == eqs.sLd) {
                eqs.found = true;
                return;
            }
            BLonElementQualifiers e = LonFacetsUtil.getQualifiers(prop.getFacets());
            if (e.hasOffset()) {
                eqs.offset = e.getByteOffset();
            }
            try {
                eqs.offset += e.getDataByteLength();
            }
            catch (Exception ex) {
                System.out.println(ex);
            }
        }
    }

    public static BLonElementQualifiers getQualifiers(BFacets f) {
        Object pkl = f.getPickle();
        if (pkl != null && pkl instanceof BLonElementQualifiers) {
            return (BLonElementQualifiers)((Object)pkl);
        }
        BLonElementQualifiers elemQual = LonFacetsUtil.makeLonQualifiers(f, -1);
        BFacets.makePickle((BFacets)f, (Object)((Object)elemQual));
        return elemQual;
    }

    public static BFacets makeFacets(BLonElementQualifiers elemQual, BUnit unit) {
        HashMap<String, BIDataValue> map = new HashMap<String, BIDataValue>();
        if (unit != null) {
            map.put(UNITS, (BIDataValue)unit);
        }
        BLonElementType elemtype = elemQual.getElemtype();
        map.put(TYPE, (BIDataValue)BString.make((String)elemtype.getTag()));
        if (elemQual.getByteOffset() > 0) {
            map.put(BYT, (BIDataValue)BInteger.make((int)elemQual.getByteOffset()));
        }
        switch (elemtype.getOrdinal()) {
            case 0: 
            case 6: 
            case 7: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                float resolution = elemQual.getResolution();
                if (resolution != 0.0f && resolution != 1.0f) {
                    map.put(RES, (BIDataValue)BFloat.make((float)elemQual.getResolution()));
                }
                if (elemQual.getOffset() != 0.0f) {
                    map.put(OFF, (BIDataValue)BFloat.make((float)elemQual.getOffset()));
                }
                LonFacetsUtil.addMinMax(map, elemQual);
                LonFacetsUtil.addPrec(map, elemQual);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                map.put(BIT, (BIDataValue)BInteger.make((int)elemQual.getBitOffset()));
                map.put(LEN, (BIDataValue)BInteger.make((int)elemQual.getLength()));
                break;
            }
            case 12: 
            case 13: {
                map.put(BIT, (BIDataValue)BInteger.make((int)elemQual.getBitOffset()));
                map.put(LEN, (BIDataValue)BInteger.make((int)elemQual.getLength()));
                LonFacetsUtil.addMinMax(map, elemQual);
                map.put("precision", (BIDataValue)BInteger.make((int)0));
                break;
            }
            case 14: 
            case 15: {
                map.put(LEN, (BIDataValue)BInteger.make((int)elemQual.getLength()));
                break;
            }
            default: {
                System.out.println("LonFacetsUtil.makeFacets did not handle elemtype=" + (Object)((Object)elemtype));
            }
        }
        return BFacets.make(map);
    }

    private static void addMinMax(HashMap<String, BIDataValue> map, BLonElementQualifiers elemQual) {
        map.put(MIN, (BIDataValue)(elemQual.hasMinimum() ? LonFacetsUtil.toBNumber(elemQual.getMinimumN()) : LonFacetsUtil.getMinimumMin(elemQual)));
        map.put(MAX, (BIDataValue)(elemQual.hasMaximum() ? LonFacetsUtil.toBNumber(elemQual.getMaximumN()) : LonFacetsUtil.getMaximumMax(elemQual)));
        if (elemQual.hasInvalidValue()) {
            map.put(INVLD, (BIDataValue)LonFacetsUtil.toBNumber(elemQual.getInvalidValueN()));
        }
    }

    private static BNumber getMaximumMax(BLonElementQualifiers elemQual) {
        double max = 0.0;
        switch (elemQual.getElemtype().getOrdinal()) {
            case 1: {
                max = 127.0;
                break;
            }
            case 2: {
                max = 255.0;
                break;
            }
            case 3: {
                max = 32767.0;
                break;
            }
            case 4: {
                max = 65535.0;
                break;
            }
            case 5: {
                max = 2.147483647E9;
                break;
            }
            case 16: {
                max = 4.294967295E9;
                break;
            }
            case 18: {
                max = Math.pow(2.0, 63.0) - 1.0;
                break;
            }
            case 19: {
                max = 1.844674407370955E19;
                break;
            }
            case 8: {
                max = Double.POSITIVE_INFINITY;
                break;
            }
            case 17: {
                max = Double.POSITIVE_INFINITY;
                break;
            }
            case 12: {
                max = (1 << elemQual.getLength()) - 1;
                break;
            }
            case 13: {
                max = (1 << elemQual.getLength() - 1) - 1;
                break;
            }
            default: {
                max = Double.POSITIVE_INFINITY;
            }
        }
        if (max == (double)elemQual.getInvalidValue()) {
            max -= 1.0;
        }
        if ((max = max * (double)elemQual.getResolution() - (double)elemQual.getOffset()) < 3.4028234663852886E38) {
            return BFloat.make((float)((float)max));
        }
        return BDouble.make((double)max);
    }

    private static BNumber getMinimumMin(BLonElementQualifiers elemQual) {
        double min = 0.0;
        switch (elemQual.getElemtype().getOrdinal()) {
            case 1: {
                min = -128.0;
                break;
            }
            case 3: {
                min = -32768.0;
                break;
            }
            case 5: {
                min = -2.147483648E9;
                break;
            }
            case 18: {
                min = -9.223372036854776E18;
                break;
            }
            case 2: 
            case 4: 
            case 12: 
            case 16: 
            case 19: {
                min = 0.0;
                break;
            }
            case 13: {
                min = -(1 << elemQual.getLength() - 1);
                break;
            }
            case 17: {
                min = Double.NEGATIVE_INFINITY;
                break;
            }
            default: {
                min = Double.NEGATIVE_INFINITY;
            }
        }
        min = min * (double)elemQual.getResolution() - (double)elemQual.getOffset();
        if (min > (double)1.4E-45f) {
            return BFloat.make((float)((float)min));
        }
        return BDouble.make((double)min);
    }

    private static void addPrec(HashMap<String, BIDataValue> map, BLonElementQualifiers elemQual) {
        int pre;
        float res = elemQual.getResolution();
        int n = pre = elemQual.getElemtype().equals((Object)BLonElementType.f32) ? 2 : 0;
        if (res < 1.0f) {
            pre = (int)Math.ceil(-(Math.log(res) / Math.log(10.0)));
        }
        map.put("precision", (BIDataValue)BInteger.make((int)pre));
    }

    private static BLonElementQualifiers makeLonQualifiers(BFacets f, int bOffset) {
        float resolution = 1.0f;
        float offset = 0.0f;
        boolean hasMinimum = false;
        Number minimum = new Float(0.0f);
        boolean hasMaximum = false;
        Number maximum = new Float(0.0f);
        boolean hasOffset = false;
        int bitOffset = 0;
        int byteOffset = 0;
        boolean hasInvalid = false;
        Number invalidValue = new Float(Float.NaN);
        int length = 0;
        BLonElementType elemtype = (BLonElementType)BLonElementType.na.getRange().get(((BString)f.getFacet(TYPE)).getString());
        if (elemtype == null) {
            return BLonElementQualifiers.NONE;
        }
        BObject s = f.getFacet(RES);
        if (s != null) {
            resolution = ((BFloat)s).getFloat();
        }
        if ((s = f.getFacet(OFF)) != null) {
            offset = ((BFloat)s).getFloat();
        }
        if ((s = f.getFacet(MIN)) != null) {
            minimum = LonFacetsUtil.parseNumber(s);
            hasMinimum = true;
        }
        if ((s = f.getFacet(MAX)) != null) {
            maximum = LonFacetsUtil.parseNumber(s);
            hasMaximum = true;
        }
        if ((s = f.getFacet(BYT)) != null && (byteOffset = ((BInteger)s).getInt()) > 0) {
            hasOffset = true;
        }
        if ((s = f.getFacet(BIT)) != null) {
            bitOffset = ((BInteger)s).getInt();
            hasOffset = true;
        }
        if ((s = f.getFacet(LEN)) != null) {
            length = ((BInteger)s).getInt();
        }
        if ((s = f.getFacet(INVLD)) != null) {
            invalidValue = LonFacetsUtil.parseNumber(s);
            hasInvalid = true;
        }
        if (!hasOffset && bOffset >= 0) {
            byteOffset = bOffset;
            hasOffset = true;
        }
        return BLonElementQualifiers.make(elemtype, hasMinimum, minimum, hasMaximum, maximum, resolution, offset, hasOffset, byteOffset, bitOffset, hasInvalid, invalidValue, length);
    }

    private static Number parseNumber(BObject s) {
        if (s instanceof BLong) {
            return new Long(((BLong)s).getLong());
        }
        if (s instanceof BDouble) {
            return new Double(((BDouble)s).getDouble());
        }
        return new Float(((BFloat)s).getFloat());
    }

    private static BNumber toBNumber(Number n) {
        if (n instanceof Long) {
            return BLong.make((long)((Long)n));
        }
        if (n instanceof Double) {
            return BDouble.make((double)((Double)n));
        }
        return BFloat.make((float)((Float)n).floatValue());
    }

    public static BFacets makeFacets(BLonElementType elemtype, BUnit unit) {
        return LonFacetsUtil.makeFacets(BLonElementQualifiers.make(elemtype, 0), unit);
    }

    public static BFacets makeFacets(BLonElementType elemtype, int len, BUnit unit) {
        return LonFacetsUtil.makeFacets(BLonElementQualifiers.make(elemtype, len), unit);
    }

    public static BFacets makeFacets(BLonElementType elemtype, boolean hasMinimum, float minimum, boolean hasMaximum, float maximum, float resolution, float offset, boolean hasOffsets, int byteOffset, int bitOffset, boolean hasInvalid, float invalidValue, int length, BUnit unit) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(TYPE, BString.make((String)elemtype.getTag()));
        if (unit != null) {
            map.put(UNITS, unit);
        }
        if (hasOffsets) {
            map.put(BYT, BInteger.make((int)byteOffset));
        }
        switch (elemtype.getOrdinal()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 16: 
            case 17: {
                if (resolution != 0.0f && resolution != 1.0f) {
                    map.put(RES, BFloat.make((float)resolution));
                }
                if (offset != 0.0f) {
                    map.put(OFF, BFloat.make((float)offset));
                }
                if (hasMinimum) {
                    map.put(MIN, BFloat.make((float)minimum));
                }
                if (hasMaximum) {
                    map.put(MAX, BFloat.make((float)maximum));
                }
                if (!hasInvalid) break;
                map.put(INVLD, BFloat.make((float)invalidValue));
                break;
            }
            case 12: {
                if (!hasMinimum) {
                    map.put(MIN, BFloat.make((float)0.0f));
                }
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                map.put(BIT, BInteger.make((int)bitOffset));
                map.put(LEN, BInteger.make((int)length));
                if (hasMinimum) {
                    map.put(MIN, BFloat.make((float)minimum));
                }
                if (hasMaximum) {
                    map.put(MAX, BFloat.make((float)maximum));
                }
                if (!hasInvalid) break;
                map.put(INVLD, BFloat.make((float)invalidValue));
                break;
            }
            case 14: 
            case 15: {
                map.put(LEN, BInteger.make((int)length));
            }
        }
        return BFacets.make(map);
    }

    public static BFacets makeFacets(BLonElementType elemtype, float minimum, float maximum, float resolution, BUnit unit) {
        BLonElementQualifiers eq = BLonElementQualifiers.make(elemtype, true, minimum, true, maximum, resolution, 0.0f, false, 0, 0, false, 0.0f, 0);
        return LonFacetsUtil.makeFacets(eq, unit);
    }

    public static BFacets makeFacets(BLonElementType elemtype, float minimum, float maximum, float resolution, int byteOffset, BUnit unit) {
        BLonElementQualifiers eq = BLonElementQualifiers.make(elemtype, true, minimum, true, maximum, resolution, 0.0f, false, byteOffset, 0, false, 0.0f, 0);
        return LonFacetsUtil.makeFacets(eq, unit);
    }

    public static BFacets makeFacets(BLonElementType elemtype, float minimum, BUnit unit) {
        BLonElementQualifiers eq = BLonElementQualifiers.make(elemtype, true, minimum, false, 0.0f, 1.0f, 0.0f, false, 0, 0, false, 0.0f, 0);
        return LonFacetsUtil.makeFacets(eq, unit);
    }

    public static BFacets makeFacets(BLonElementType elemtype, int byteOffset) {
        BLonElementQualifiers eq = BLonElementQualifiers.make(elemtype, false, 0.0f, false, 0.0f, 1.0f, 0.0f, false, byteOffset, 0, false, 0.0f, 0);
        return LonFacetsUtil.makeFacets(eq, null);
    }

    public static BFacets makeFacets(BLonElementType elemtype, int byteOffset, int bitOffset, int len, BUnit unit) {
        BLonElementQualifiers eq = BLonElementQualifiers.make(elemtype, false, 0.0f, false, 0.0f, 1.0f, 0.0f, false, byteOffset, bitOffset, false, 0.0f, len);
        return LonFacetsUtil.makeFacets(eq, unit);
    }

    public static BFacets makeFacets(BLonElementType elemtype, float minimum, float maximum, float resolution, float invalidValue, BUnit unit) {
        BLonElementQualifiers eq = BLonElementQualifiers.make(elemtype, true, minimum, true, maximum, resolution, 0.0f, false, 0, 0, true, invalidValue, 0);
        return LonFacetsUtil.makeFacets(eq, unit);
    }

    public static BFacets makeFacets(BLonElementType elemtype, float minimum, float maximum, float resolution, float invalidValue, int byteOffset, int bitOffset, BUnit unit) {
        BLonElementQualifiers eq = BLonElementQualifiers.make(elemtype, true, minimum, true, maximum, resolution, 0.0f, false, byteOffset, bitOffset, true, invalidValue, 0);
        return LonFacetsUtil.makeFacets(eq, unit);
    }

    private static class EqSearch {
        BLonData sLd;
        Property prop;
        int offset = 0;
        boolean found = false;

        private EqSearch() {
        }
    }
}

