/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks;

import com.tridium.lonworks.BLonRouter;
import com.tridium.lonworks.NAddressManager;
import com.tridium.lonworks.NetMessageReceiver;
import com.tridium.lonworks.NvManager;
import com.tridium.lonworks.datatypes.BUtilCmdJob;
import com.tridium.lonworks.datatypes.BUtilitiesCommand;
import com.tridium.lonworks.device.BDownloadJob;
import com.tridium.lonworks.device.BUploadJob;
import com.tridium.lonworks.device.DynaDev;
import com.tridium.lonworks.device.NvDev;
import com.tridium.lonworks.loncomm.NAppBuffer;
import com.tridium.lonworks.loncomm.NLonComm;
import com.tridium.lonworks.netmgmt.BLonNetmgmt;
import com.tridium.lonworks.util.NmUtil;
import com.tridium.lonworks.util.TimedCoalesceQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.license.Feature;
import javax.baja.lonworks.AddressManager;
import javax.baja.lonworks.BINetworkVariable;
import javax.baja.lonworks.BLocalLonDevice;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonDeviceFolder;
import javax.baja.lonworks.LonComm;
import javax.baja.lonworks.datatypes.BLonCommConfig;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.ext.BLonPollService;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.tuning.BLonTuningPolicyMap;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Queue;
import javax.baja.util.Worker;

public class BLonNetwork
extends BDeviceNetwork
implements BIService {
    public static final Property lonCommConfig = BLonNetwork.newProperty((int)0, (BValue)new BLonCommConfig(), null);
    public static final Property pollService = BLonNetwork.newProperty((int)0, (BValue)new BLonPollService(), null);
    public static final Property lonNetmgmt = BLonNetwork.newProperty((int)0, (BValue)new BLonNetmgmt(), null);
    public static final Property tuningPolicies = BLonNetwork.newProperty((int)0, (BValue)new BLonTuningPolicyMap(), null);
    public static final Property localLonDevice = BLonNetwork.newProperty((int)0, (BValue)new BLocalLonDevice(), null);
    public static final Action upload = BLonNetwork.newAction((int)0, (BValue)new BUploadParameters(), null);
    public static final Action download = BLonNetwork.newAction((int)0, (BValue)new BDownloadParameters(), null);
    public static final Action executeCommand = BLonNetwork.newAction((int)4, (BValue)new BUtilitiesCommand(), null);
    public static final Action makeNvsNonCritical = BLonNetwork.newAction((int)0, null);
    public static final Topic deviceChange = BLonNetwork.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BLonNetwork.class);
    private static Type[] serviceTypes = new Type[]{TYPE};
    private boolean firstPass = true;
    private boolean disabledAtStart = true;
    private boolean serviceRunning = false;
    protected Worker workQueue = null;
    protected Worker coalesceQueue = null;
    protected Worker proxyQueue = null;
    protected Worker timedQueue = null;
    public int dataPntMismatchCount = 0;
    private Logger log = null;
    private NetMessageReceiver netMessageReceiver = null;
    private NLonComm lonComm = null;
    private NvManager nvManager = null;
    private AddressManager addressManager = null;
    private static BFacets noWrite = BFacets.make((String)"noWrite", (boolean)true);
    private static BFacets noPropagate = BFacets.make((String)"noPropagate", (boolean)true);
    public static final Context lonNoWrite = new BasicContext((Context)noWrite){

        public boolean equals(Object obj) {
            return obj != null && obj instanceof Context && ((Context)obj).getFacets().getb("noWrite", false);
        }

        public int hashCode() {
            return super.hashCode();
        }
    };
    public static final Context lonNoPropagate = new BasicContext((Context)noPropagate){

        public boolean equals(Object obj) {
            return obj != null && obj instanceof Context && ((Context)obj).getFacets().getb("noPropagate", false);
        }

        public int hashCode() {
            return super.hashCode();
        }
    };
    public static final Context lonNoPropagateNoWrite = new BasicContext((Context)BFacets.make((BFacets)noWrite, (BFacets)noPropagate));

    public BLonCommConfig getLonCommConfig() {
        return (BLonCommConfig)this.get(lonCommConfig);
    }

    public void setLonCommConfig(BLonCommConfig v) {
        this.set(lonCommConfig, (BValue)v, null);
    }

    public BLonPollService getPollService() {
        return (BLonPollService)this.get(pollService);
    }

    public void setPollService(BLonPollService v) {
        this.set(pollService, (BValue)v, null);
    }

    public BLonNetmgmt getLonNetmgmt() {
        return (BLonNetmgmt)this.get(lonNetmgmt);
    }

    public void setLonNetmgmt(BLonNetmgmt v) {
        this.set(lonNetmgmt, (BValue)v, null);
    }

    public BLonTuningPolicyMap getTuningPolicies() {
        return (BLonTuningPolicyMap)this.get(tuningPolicies);
    }

    public void setTuningPolicies(BLonTuningPolicyMap v) {
        this.set(tuningPolicies, (BValue)v, null);
    }

    public BLocalLonDevice getLocalLonDevice() {
        return (BLocalLonDevice)this.get(localLonDevice);
    }

    public void setLocalLonDevice(BLocalLonDevice v) {
        this.set(localLonDevice, (BValue)v, null);
    }

    public void upload(BUploadParameters parameters) {
        this.invoke(upload, (BValue)parameters, null);
    }

    public void download(BDownloadParameters parameters) {
        this.invoke(download, (BValue)parameters, null);
    }

    public BOrd executeCommand(BUtilitiesCommand cmd) {
        return (BOrd)this.invoke(executeCommand, (BValue)cmd, null);
    }

    public void makeNvsNonCritical() {
        this.invoke(makeNvsNonCritical, null, null);
    }

    public void fireDeviceChange(BValue event) {
        this.fire(deviceChange, event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "lonworks");
    }

    public final BOrd doExecuteCommand(BUtilitiesCommand cmd) {
        return new BUtilCmdJob(this, cmd).submit(null);
    }

    public final Type[] getServiceTypes() {
        return serviceTypes;
    }

    public final AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list = NvDev.fixWireSheet(list, cx);
        AgentInfo[] aia = list.list();
        for (int i = 0; i < aia.length; ++i) {
            if (!aia[i].getAgentType().getTypeName().equals("LonDeviceManager") || i == 0) continue;
            list.toTop(i);
        }
        return this.modifyAgentList(list, cx);
    }

    protected AgentList modifyAgentList(AgentList list, Context cx) {
        return list;
    }

    public final boolean isParentLegal(BComponent parent) {
        return !(parent instanceof BLonNetwork);
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        if (value instanceof BLocalLonDevice) {
            throw new LocalizableRuntimeException("lonworks", "addLocalDeviceError");
        }
    }

    public void added(Property prop, Context context) {
        try {
            if (!this.isRunning()) {
                return;
            }
            if (prop.getType().is(BLonDevice.TYPE)) {
                this.netmgmt().deviceAdded((BLonDevice)this.get(prop));
            } else if (prop.getType().is(BLonRouter.TYPE)) {
                this.netmgmt().routerAdded((BLonRouter)this.get(prop));
            }
        }
        finally {
            super.added(prop, context);
        }
    }

    public final Type getDeviceType() {
        return BLonDevice.TYPE;
    }

    public final Type getDeviceFolderType() {
        return BLonDeviceFolder.TYPE;
    }

    public final void doUpload(BUploadParameters p, Context cx) throws Exception {
        new BUploadJob((BIDeviceFolder)this, p, cx).submit(cx);
    }

    public final void doDownload(BDownloadParameters p, Context cx) throws Exception {
        new BDownloadJob((BIDeviceFolder)this, p, cx).submit(cx);
    }

    protected IFuture postPing() {
        return this.postAsync((Runnable)new Invocation((BComponent)this, ping, null, null));
    }

    public void doPing() throws Exception {
        Object[] pa = NmUtil.getDecendantsByClass((BComponent)this, BLonDevice.class);
        for (int i = 0; i < pa.length; ++i) {
            ((BLonDevice)pa[i]).doPing();
        }
        this.pingOk();
    }

    public void doMakeNvsNonCritical() {
        BLonDevice[] devA = this.getLonDevices();
        for (int i = 0; i < devA.length; ++i) {
            BINetworkVariable[] nvs = devA[i].getNetworkVariables();
            for (int n = 0; n < nvs.length; ++n) {
                if (nvs[n] == null || !nvs[n].isNetworkVariable() && !nvs[n].isLocalNv()) continue;
                DynaDev.setNonCritical((BLonData)((Object)nvs[n]));
            }
        }
    }

    public final void serviceStarted() {
        if (this.firstPass) {
            this.lonComm = new NLonComm(this);
            this.netMessageReceiver = new NetMessageReceiver(this);
            this.nvManager = new NvManager(this);
            this.addressManager = new NAddressManager(this);
            this.workQueue = new Worker((Worker.ITodo)new Queue(1000));
            this.coalesceQueue = new Worker((Worker.ITodo)new CoalesceQueue(5000));
            this.proxyQueue = new Worker((Worker.ITodo)new Queue(1000));
            this.timedQueue = new Worker((Worker.ITodo)new TimedCoalesceQueue(1000));
            this.firstPass = false;
        }
        if (this.isDisabled()) {
            return;
        }
        this.disabledAtStart = false;
        try {
            this.lonComm.start();
            this.workQueue.start(this.getLogName() + ".Async");
            this.setWorkQueuePriority();
            this.coalesceQueue.start(this.getLogName() + ".AsyncEvent");
            this.proxyQueue.start(this.getLogName() + ".Proxy");
            this.timedQueue.start(this.getLogName() + ".Delay");
            this.log().info("Service started on " + this.getLonCommConfig().getDeviceName());
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)4, (boolean)false));
            this.serviceRunning = true;
            this.configOk();
        }
        catch (Throwable e) {
            this.log().log(Level.SEVERE, "Error initializing LonNetwork " + this.getDisplayName(null), e);
            this.configFail(e.getMessage());
        }
    }

    public final void serviceStopped() {
        this.serviceRunning = false;
        this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)4, (boolean)true));
        this.workQueue.stop();
        this.coalesceQueue.stop();
        this.proxyQueue.stop();
        this.timedQueue.stop();
        this.lonComm.stop();
        this.log().info("Service stopped on " + this.getLonCommConfig().getDeviceName());
    }

    public boolean isServiceRunning() {
        return this.serviceRunning;
    }

    public void started() throws Exception {
        try {
            if (!(this.isServiceRunning() || this.isDisabled() || this.getStatus().isFault())) {
                this.serviceStarted();
            }
        }
        finally {
            super.started();
        }
    }

    public void changed(Property prop, Context context) {
        block14: {
            block15: {
                super.changed(prop, context);
                if (!this.isRunning()) {
                    return;
                }
                if (prop == enabled) {
                    boolean restartDevs = false;
                    if (!this.isDisabled() && !this.isServiceRunning()) {
                        if (this.disabledAtStart) {
                            restartDevs = true;
                        }
                        this.serviceStarted();
                    }
                    if (this.isDisabled() && this.isServiceRunning()) {
                        this.serviceStopped();
                    }
                    if (restartDevs) {
                        BLonDevice[] devs = (BLonDevice[])NmUtil.getDecendantsByClass((BComponent)this, BLonDevice.class);
                        for (int i = 0; i < devs.length; ++i) {
                            try {
                                devs[i].started();
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (prop != lonCommConfig) break block14;
                if (this.isServiceRunning() || this.isDisabled()) break block15;
                this.serviceStarted();
                if (!this.isServiceRunning()) break block14;
                BLonDevice[] devs = (BLonDevice[])NmUtil.getDecendantsByClass((BComponent)this, BLonDevice.class);
                for (int i = 0; i < devs.length; ++i) {
                    try {
                        devs[i].started();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                break block14;
            }
            if (!this.isServiceRunning()) break block14;
            try {
                this.lonComm.verifySettings();
                this.configOk();
            }
            catch (Throwable e) {
                this.log().log(Level.SEVERE, "Error initializing LonNetwork " + this.getDisplayName(null), e);
                this.configFail(e.getMessage());
            }
        }
    }

    public BINavNode[] getNavChildren() {
        BINavNode[] kids = super.getNavChildren();
        Array acc = new Array(BINavNode.class);
        acc.add((Object)this.getLocalLonDevice());
        for (int i = 0; i < kids.length; ++i) {
            acc.add((Object)kids[i]);
        }
        return (BINavNode[])acc.trim();
    }

    public String getLogName() {
        return this.getLonCommConfig().getDeviceName().toLowerCase();
    }

    public final IFuture postAsync(Runnable t) {
        if (!this.isServiceRunning()) {
            return null;
        }
        if (this.workQueue == null || !this.workQueue.isRunning()) {
            throw new NotRunningException();
        }
        ((Queue)this.workQueue.getTodo()).enqueue((Object)t);
        return null;
    }

    private void setWorkQueuePriority() {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setPriority(6);
            }
        };
        ((Queue)this.workQueue.getTodo()).enqueue((Object)t);
    }

    public final IFuture postWrite(Runnable t) {
        if (!this.isServiceRunning()) {
            return null;
        }
        if (this.coalesceQueue == null || !this.coalesceQueue.isRunning()) {
            throw new NotRunningException();
        }
        ((Queue)this.coalesceQueue.getTodo()).enqueue((Object)t);
        return null;
    }

    public final Worker getProxyQueue() {
        return this.proxyQueue;
    }

    public final Worker getTimedQueue() {
        return this.timedQueue;
    }

    public final LonComm lonComm() {
        return this.lonComm;
    }

    public final NetMessageReceiver netMessageReceiver() {
        return this.netMessageReceiver;
    }

    public final NvManager nvManager() {
        return this.nvManager;
    }

    public final AddressManager addressManager() {
        return this.addressManager;
    }

    public final BLonNetmgmt netmgmt() {
        return this.getLonNetmgmt();
    }

    public final BLonRouter[] getLonRouters() {
        return NmUtil.getLonRouters((BIDeviceFolder)this);
    }

    public final BLonDevice[] getLonDevices() {
        return NmUtil.getLonDevices((BIDeviceFolder)this);
    }

    public final BLonDevice findDevice(BNeuronId nid) {
        BLonDevice[] devs = this.getLonDevices();
        for (int i = 0; i < devs.length; ++i) {
            if (!devs[i].getNeuronIdAddress().equals(nid)) continue;
            return devs[i];
        }
        return null;
    }

    public final BLonRouter findRouter(BNeuronId nid) {
        BLonRouter[] rtrs = this.getLonRouters();
        for (int i = 0; i < rtrs.length; ++i) {
            if (!rtrs[i].getNeuronIdAddress().equals(nid)) continue;
            return rtrs[i];
        }
        return null;
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps("BLonNetwork");
        out.prop((Object)"serviceRunning", this.serviceRunning);
        out.prop((Object)"dataPntMismatchCount", this.dataPntMismatchCount);
        out.endProps();
        if (this.workQueue != null) {
            out.trTitle((Object)"Async Queue", 1);
            this.workQueue.spy(out);
        }
        if (this.coalesceQueue != null) {
            out.trTitle((Object)"Coalescing Write Queue", 1);
            this.coalesceQueue.spy(out);
        }
        if (this.proxyQueue != null) {
            out.trTitle((Object)"Proxy Queue", 1);
            this.proxyQueue.spy(out);
        }
        if (this.timedQueue != null) {
            out.trTitle((Object)"Delay Queue", 1);
            this.timedQueue.spy(out);
            ((TimedCoalesceQueue)this.timedQueue.getTodo()).spy(out);
        }
        if (this.nvManager != null) {
            out.trTitle((Object)"NvManager", 1);
            this.nvManager.spy(out);
        }
        if (this.addressManager != null) {
            out.trTitle((Object)"Address Manager", 1);
            ((NAddressManager)this.addressManager).spy(out);
        }
        NAppBuffer.spy(out);
        if (this.lonComm != null) {
            this.lonComm.spy(out);
        }
    }

    public final Logger log() {
        if (this.log == null) {
            this.log = Logger.getLogger(this.getLogName());
        }
        return this.log;
    }
}

