/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks;

import com.tridium.lonworks.util.NmUtil;
import com.tridium.lonworks.util.selfdoc.SelfDocUtil;
import java.util.logging.Level;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BConfigProps;
import javax.baja.lonworks.datatypes.BModifyFlags;
import javax.baja.lonworks.enums.BLonConfigScope;
import javax.baja.lonworks.enums.BLonNodeState;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.util.LonFile;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BConfigParameter
extends BLonComponent {
    public static final Property configProps = BConfigParameter.newProperty((int)0, (BValue)new BConfigProps(), null);
    public static final Type TYPE = Sys.loadType(BConfigParameter.class);
    private static final BIcon icon = BIcon.make((String)"module://lonworks/com/tridium/lonworks/ui/icons/cp.png");

    public BConfigProps getConfigProps() {
        return (BConfigProps)this.get(configProps);
    }

    public void setConfigProps(BConfigProps v) {
        this.set(configProps, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BConfigParameter() {
    }

    public BConfigParameter(BLonData data, int offset, int length, BModifyFlags modifyFlag, BLonConfigScope scope, String select) {
        BConfigProps cfgProps = this.getConfigProps();
        cfgProps.setOffset(offset);
        cfgProps.setLength(length);
        cfgProps.setModifyFlag(modifyFlag);
        cfgProps.setScope(scope);
        cfgProps.setSelect(select);
        this.setData(data);
    }

    @Override
    public boolean isConfigParameter() {
        return true;
    }

    @Override
    public boolean isForeignPersistent() {
        return true;
    }

    @Override
    public boolean isWriteable() {
        BModifyFlags mf = this.getConfigProps().getModifyFlag();
        return !mf.isMfgOnly() && !mf.isConst();
    }

    @Override
    protected void dataChanged(Context context) {
        if (BLonNetwork.lonNoWrite.equals(context)) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        this.doForceWrite();
    }

    @Override
    public void doForceWrite() {
        BConfigProps configProps = this.getConfigProps();
        if (configProps.getModifyFlag().isMfgOnly()) {
            throw new BajaRuntimeException("Can not write mfgOnly cp " + this.getDisplayName(null));
        }
        if (configProps.getModifyFlag().isConst()) {
            throw new BajaRuntimeException("Can not write constant cp " + this.getDisplayName(null));
        }
        BLonDevice dev = this.lonDevice();
        dev.checkState();
        boolean downloading = dev.isDownLoadInProgress();
        try {
            LonFile f = dev.getReadWriteFile();
            if (f == null) {
                throw new LonException("Error writing " + this.getDisplayName(null) + ": could not access file");
            }
            int[] sels = null;
            boolean[] objDis = null;
            boolean onlineReq = false;
            boolean failedObjDevOff = false;
            if (!downloading) {
                dev.beginConfigWrite();
                if (configProps.getModifyFlag().isDisabled() && configProps.getScope() == BLonConfigScope.object) {
                    sels = SelfDocUtil.selectToIntArray(configProps.getSelect());
                    objDis = new boolean[sels.length];
                    try {
                        dev.disableObjectsForWrite(sels, objDis);
                    }
                    catch (Throwable e) {
                        this.lonNetwork().log().log(Level.WARNING, "Unable to disable object " + configProps.getSelect(), e);
                        failedObjDevOff = true;
                    }
                }
                if (configProps.getModifyFlag().isOffline() || failedObjDevOff) {
                    try {
                        NmUtil.setDeviceState(dev, BLonNodeState.configOffline);
                    }
                    catch (LonException e) {
                        System.out.println((Object)e);
                    }
                    onlineReq = true;
                }
            }
            f.write(this.getData().toNetBytes(), configProps.getOffset());
            if (!downloading) {
                f.flush();
                if (onlineReq) {
                    try {
                        NmUtil.setDeviceState(dev, BLonNodeState.configOnline);
                    }
                    catch (LonException e) {
                        System.out.println((Object)e);
                    }
                }
                if (sels != null) {
                    dev.enableObjectsAfterWrite(sels, objDis);
                }
                if (configProps.getModifyFlag().isReset()) {
                    dev.doReset();
                }
                dev.endConfigWrite();
            }
            this.getData().writeOk();
        }
        catch (Throwable e) {
            this.getData().writeFail(e.toString());
            String errMsg = "Unable to write " + this.debugName();
            this.lonNetwork().log().log(Level.SEVERE, errMsg, e);
            throw new BajaRuntimeException(errMsg + " " + e.getMessage(), e);
        }
    }

    @Override
    public void doForceRead() {
        LonFile f;
        BLonDevice dev = this.lonDevice();
        dev.checkState();
        BConfigProps configProps = this.getConfigProps();
        LonFile lonFile = f = configProps.getModifyFlag().isConst() ? dev.getReadOnlyFile() : dev.getReadWriteFile();
        if (f == null) {
            throw new RuntimeException("Error reading " + this.getDisplayName(null) + ": could not access file");
        }
        try {
            this.getData().fromNetBytes(f.read(configProps.getOffset(), configProps.getLength()));
            this.getData().readOk();
        }
        catch (Throwable e) {
            this.getData().readFail(e.toString());
            String errMsg = "Unable to read " + this.debugName();
            this.lonNetwork().log().log(Level.SEVERE, errMsg, e);
            throw new BajaRuntimeException(errMsg + " " + e.getMessage(), e);
        }
    }

    @Override
    protected void lonComponentSubscribed() {
        BBoolean bb = (BBoolean)this.getPropertyInParent().getFacets().get("deviceSpecific");
        if (bb != null && bb.getBoolean()) {
            this.forceRead();
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

