/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.xml;

import com.tridium.lonworks.xml.XConfigProperty;
import com.tridium.lonworks.xml.XDeviceData;
import com.tridium.lonworks.xml.XElementQualifier;
import com.tridium.lonworks.xml.XEnumDef;
import com.tridium.lonworks.xml.XLonDataUtil;
import com.tridium.lonworks.xml.XLonDevice;
import com.tridium.lonworks.xml.XLonInterfaceFile;
import com.tridium.lonworks.xml.XLonTyped;
import com.tridium.lonworks.xml.XMessageTag;
import com.tridium.lonworks.xml.XNetworkConfig;
import com.tridium.lonworks.xml.XNetworkVariable;
import java.util.Vector;
import javax.baja.lonworks.BConfigParameter;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BMessageTag;
import javax.baja.lonworks.BNetworkConfig;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.lonworks.datatypes.BConfigProps;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BModifyFlags;
import javax.baja.lonworks.datatypes.BNcProps;
import javax.baja.lonworks.datatypes.BNvConfigData;
import javax.baja.lonworks.datatypes.BNvProps;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonElementQualifiers;
import javax.baja.lonworks.londata.BLonEnum;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.londata.LonFacetsUtil;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

public class DevToXLon {
    public static XLonInterfaceFile devToXLon(BLonDevice dev) {
        XLonInterfaceFile xfile = new XLonInterfaceFile();
        XLonDevice xdev = new XLonDevice();
        xdev.setName(dev.getName());
        SlotCursor sc = dev.getProperties();
        while (sc.nextObject()) {
            BValue o = sc.get();
            if (o.getType().is(BNetworkVariable.TYPE)) {
                xdev.addAttribute(sc.property().getName(), DevToXLon.getXNetworkVariable(xfile, (BNetworkVariable)o));
                continue;
            }
            if (o.getType().is(BNetworkConfig.TYPE)) {
                xdev.addAttribute(sc.property().getName(), DevToXLon.getXNetworkConfig(xfile, (BNetworkConfig)o));
                continue;
            }
            if (o.getType().is(BConfigParameter.TYPE)) {
                xdev.addAttribute(sc.property().getName(), DevToXLon.getXConfigProperty(xfile, (BConfigParameter)o));
                continue;
            }
            if (!o.getType().is(BMessageTag.TYPE) || !((BMessageTag)o).isOutput()) continue;
            xdev.addAttribute(sc.property().getName(), DevToXLon.getXMessageTag((BMessageTag)o));
        }
        xdev.deviceData = DevToXLon.getXDeviceData(dev);
        xfile.addAttribute(dev.getName(), xdev);
        return xfile;
    }

    private static XDeviceData getXDeviceData(BLonDevice dev) {
        XDeviceData xdd = new XDeviceData();
        xdd.setName("deviceData");
        BDeviceData dd = dev.getDeviceData();
        xdd.programID = dd.getProgramId().getByteArray();
        xdd.aliasCount = dd.getAliasTable().getAliasArray().length;
        xdd.bindingII = dd.getBindingII();
        xdd.applicationType = dd.getHosted() ? "hostSelect" : "unknown";
        xdd.domains = dd.getTwoDomains() ? 2 : 1;
        xdd.addressTableEntries = dd.getAddressCount();
        xdd.nodeSelfID = dd.getSelfDoc();
        xdd.freezeChannelPriorities = dd.getFreezeChannelPriorities();
        return xdd;
    }

    private static XNetworkVariable getXNetworkVariable(XLonInterfaceFile xfile, BNetworkVariable nv) {
        BNvProps nvProps = nv.getNvProps();
        XNetworkVariable xnv = new XNetworkVariable();
        xnv.setName(nv.getName());
        int snvt = nvProps.getSnvtType();
        xnv.snvtType = XLonDataUtil.getSnvtTypeName(snvt, "");
        xnv.index = nvProps.getNvIndex();
        xnv.objectIndex = DevToXLon.getObjectIndex(nvProps.getObjectIndex());
        xnv.memberIndex = nvProps.getMemberIndex();
        xnv.polled = nvProps.getPolled();
        xnv.authenticatedConfigurable = nvProps.getAuthConf();
        xnv.serviceTypeConfigurable = nvProps.getServiceConf();
        xnv.priorityConfigurable = nvProps.getPriorityConf();
        xnv.offline = nvProps.getModifyOffline();
        xnv.sync = nvProps.getSync();
        xnv.changeType = nvProps.getChangeableType();
        BNvConfigData nvConfig = nv.getNvConfigData();
        xnv.priority = nvConfig.getPriority();
        xnv.direction = nvConfig.getDirection().getTag();
        xnv.serviceType = nvConfig.getServiceType().getTag();
        xnv.authenticated = nvConfig.getAuthenticated();
        if (snvt <= 0) {
            DevToXLon.addData(xfile, xnv, nv.getData());
        }
        return xnv;
    }

    private static String getObjectIndex(int ndx) {
        if (ndx >= 0) {
            return Integer.toString(ndx);
        }
        return "";
    }

    private static XNetworkConfig getXNetworkConfig(XLonInterfaceFile xfile, BNetworkConfig nc) {
        XNetworkConfig xnc = new XNetworkConfig();
        xnc.setName(nc.getName());
        BNcProps ncProps = nc.getNcProps();
        xnc.index = ncProps.getNvIndex();
        int snvt = ncProps.getSnvtType();
        xnc.snvtType = XLonDataUtil.getSnvtTypeName(snvt, "");
        int scpt = ncProps.getConfigIndex();
        xnc.scptType = XLonDataUtil.getScptTypeName(scpt, "");
        xnc.modifyFlag = DevToXLon.getModifyFlags(ncProps.getModifyFlag());
        xnc.scope = ncProps.getScope().getTag();
        xnc.select = ncProps.getSelect();
        BNvConfigData nvConfig = nc.getNvConfigData();
        xnc.priority = nvConfig.getPriority();
        xnc.direction = nvConfig.getDirection().getTag();
        xnc.serviceType = nvConfig.getServiceType().getTag();
        xnc.authenticated = nvConfig.getAuthenticated();
        xnc.config = true;
        if (snvt <= 0 && scpt <= 0) {
            DevToXLon.addData(xfile, xnc, nc.getData());
        }
        return xnc;
    }

    private static XConfigProperty getXConfigProperty(XLonInterfaceFile xfile, BConfigParameter cp) {
        XConfigProperty xcp = new XConfigProperty();
        xcp.setName(cp.getName());
        BConfigProps cfgProps = cp.getConfigProps();
        int scpt = cfgProps.getConfigIndex();
        xcp.scptType = XLonDataUtil.getScptTypeName(scpt, "");
        xcp.length = cfgProps.getLength();
        xcp.modifyFlag = DevToXLon.getModifyFlags(cfgProps.getModifyFlag());
        xcp.scope = cfgProps.getScope().getTag();
        xcp.select = cfgProps.getSelect();
        if (scpt <= 0) {
            DevToXLon.addData(xfile, xcp, cp.getData());
        }
        return xcp;
    }

    private static void addData(XLonInterfaceFile xfile, XLonTyped xd, BLonData ld) {
        SlotCursor sc = ld.getProperties();
        while (sc.nextObject()) {
            BValue obj = sc.get();
            Type typ = obj.getType();
            if (typ.is(BLonPrimitive.TYPE)) {
                BUnit u;
                Property p = sc.property();
                BFacets f = p.getFacets();
                BLonElementQualifiers e = LonFacetsUtil.getQualifiers(f);
                XElementQualifier eq = new XElementQualifier(p.getName(), e);
                if (typ.is(BLonEnum.TYPE)) {
                    eq.setEnumDef(DevToXLon.addEnum(xfile, ((BLonEnum)obj).getEnum()));
                }
                if ((u = (BUnit)f.get("units")) != null) {
                    eq.setEngUnit(u.getUnitName());
                }
                xd.addAttribute(p.getName(), eq);
                continue;
            }
            if (!typ.is(BLonData.TYPE)) continue;
            DevToXLon.addData(xfile, xd, (BLonData)obj);
        }
    }

    private static String addEnum(XLonInterfaceFile xfile, BEnum en) {
        XEnumDef xe = new XEnumDef();
        BEnumRange er = en.getRange();
        int[] ords = er.getOrdinals();
        for (int i = 0; i < ords.length; ++i) {
            xe.addEnum(er.get(ords[i]).getTag(), Integer.toString(ords[i]));
        }
        Vector<XEnumDef> v = xfile.enums;
        for (int i = 0; i < v.size(); ++i) {
            XEnumDef vxd = v.elementAt(i);
            if (!xe.equals(vxd)) continue;
            return vxd.getName();
        }
        String name = "enum" + v.size();
        xe.setName(name);
        v.addElement(xe);
        return name;
    }

    private static String getModifyFlags(BModifyFlags flgs) {
        int len;
        StringBuffer sb = new StringBuffer();
        if (flgs.isDisabled()) {
            sb.append("objDisable ");
        }
        if (flgs.isOffline()) {
            sb.append("offline ");
        }
        if (flgs.isConst()) {
            sb.append("constant ");
        }
        if (flgs.isReset()) {
            sb.append("reset ");
        }
        if (flgs.isMfgOnly()) {
            sb.append("mfgOnly ");
        }
        if ((len = sb.length()) > 0) {
            return sb.toString().substring(0, len - 1);
        }
        return "anytime";
    }

    private static XMessageTag getXMessageTag(BMessageTag mtag) {
        XMessageTag xmtag = new XMessageTag();
        xmtag.setName(mtag.getName());
        return xmtag;
    }
}

