/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.util.xif;

import com.tridium.lonworks.local.BLocalNci;
import com.tridium.lonworks.local.BLocalNv;
import com.tridium.lonworks.util.LonByteArrayUtil;
import com.tridium.lonworks.util.selfdoc.DocToXDevice;
import com.tridium.lonworks.xml.XDeviceData;
import java.io.IOException;
import java.util.Date;
import javax.baja.lonworks.BINetworkVariable;
import javax.baja.lonworks.BLocalLonDevice;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BLocal;
import javax.baja.lonworks.datatypes.BLocalExtractXifParameter;
import javax.baja.lonworks.datatypes.BNvConfigData;
import javax.baja.lonworks.enums.BLonElementType;
import javax.baja.lonworks.enums.BLonServiceType;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonElementQualifiers;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.londata.LonFacetsUtil;
import javax.baja.nre.util.Array;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Type;

public class LocalToXif {
    private BLocalLonDevice bdev;
    private StringBuffer out;
    private static final int FIXED_STATIC_NV = 1;

    public static String extractXif(BLocalLonDevice ldev, BLocalExtractXifParameter p) throws IOException {
        LocalToXif toxif = new LocalToXif();
        return toxif.extract(ldev, p);
    }

    private String extract(BLocalLonDevice ldev, BLocalExtractXifParameter p) throws IOException {
        this.bdev = ldev;
        this.out = new StringBuffer();
        this.out.append("File: " + p.getFileName() + " generated by Niagara, XIF Version 4.4\n");
        this.out.append("Copyright (c) ").append(BAbsTime.now().getYear()).append(" Tridium \n");
        this.out.append("All Rights Reserved. Run on " + new Date() + "\n");
        this.out.append("\n");
        this.writeHeader();
        this.writeNetworkVariableDefinition();
        return this.out.toString();
    }

    private void writeHeader() {
        XDeviceData data = null;
        try {
            data = DocToXDevice.getDeviceData(BLocal.local, this.bdev.lonComm(), this.bdev.authenticate(), true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.out.append(LonByteArrayUtil.toString(LonByteArrayUtil.getBytes(data.getProgramID()), ':')).append("\n");
        int numNvs = this.bdev.getNetworkVariables().length;
        this.out.append(data.domains).append(" ");
        this.out.append(data.addressTableEntries >= 15 ? "15" : Integer.valueOf(data.addressTableEntries)).append(" ");
        this.out.append(this.booleanToInt(data.handlesIncomingExplicitMessages)).append(" ");
        this.out.append(numNvs).append(" ");
        this.out.append(data.numExplicitMessageTags).append(" ");
        this.out.append(data.networkInputBuffers).append(" ");
        this.out.append(data.networkOutputBuffers).append(" ");
        this.out.append(data.priorityNetworkOutputBuffers).append(" ");
        this.out.append(data.priorityApplicationOutputBuffers).append(" ");
        this.out.append(data.applicationOutputBuffers).append(" ");
        this.out.append(data.applicationInputBuffers).append(" ");
        this.out.append(data.sizeNetworkInputBuffer).append(" ");
        this.out.append(data.sizeNetworkOutputBuffer).append(" ");
        this.out.append(data.sizeAppOutputBuffer).append(" ");
        this.out.append(data.sizeAppInputBuffer).append(" ");
        this.out.append(this.appTypeToInt("hostSelect")).append(" ");
        this.out.append(data.numNetworkVariablesNISelect).append(" ");
        this.out.append(data.rcvTransactionBuffers).append(" ");
        this.out.append(data.aliasCount).append(" ");
        this.out.append(this.booleanToInt(data.bindingII)).append(" ");
        this.out.append(this.booleanToInt(data.allowStatRelativeAddressing)).append(" ");
        this.out.append(data.maxSizeWrite).append(" ");
        this.out.append(numNvs).append(" ");
        boolean ecs = data.addressTableEntries > 15;
        this.out.append(0).append(" ");
        this.out.append(ecs ? 1 : 0).append(" ");
        this.out.append(data.bindingII ? 2 : 1).append(" ");
        this.out.append(ecs ? 1 : 0).append(" ");
        this.out.append(0).append(" ");
        this.out.append(0).append(" ");
        this.out.append(0).append(" ");
        this.out.append(0).append(" ");
        this.out.append(0).append(" ");
        this.out.append(data.domains).append(" ");
        this.out.append(data.addressTableEntries).append(" ");
        this.out.append(data.numExplicitMessageTags).append(" ");
        this.out.append(0).append(" ");
        this.out.append(0).append(" ");
        this.out.append(0).append(" ");
        this.out.append(0).append(" ");
        this.out.append(data.firmwareRevision <= 13 ? 1 : 2).append(" ");
        this.out.append(data.firmwareRevision <= 13 ? 0 : 1).append(" ");
        this.out.append(0).append(" ");
        this.out.append(0).append("\n");
        this.out.append(data.neuronChipType).append(" ");
        this.out.append(data.clockRate).append(" ");
        this.out.append(data.firmwareRevision).append(" ");
        this.out.append(data.rcvTransactionBlockSize).append(" ");
        this.out.append(data.transControlBlockSize).append(" ");
        this.out.append(data.neuronFreeRam).append(" ");
        this.out.append(data.offChipFreeRam).append(" ");
        this.out.append(data.domainTableEntrySize).append(" ");
        this.out.append(data.addressTableEntrySize).append(" ");
        this.out.append(data.nvConfigTableEntrySize).append(" ");
        this.out.append(data.domainToUserSize).append(" ");
        this.out.append(data.nvAliasTableEntrySize).append(" ");
        this.out.append("10000000").append(" ");
        this.out.append("1").append("\n");
        this.out.append(this.booleanToInt(data.standardTransceiverTypeUsed)).append(" ");
        this.out.append(data.standardTransceiverTypeId).append(" ");
        this.out.append("1 ");
        this.out.append(data.transceiverType).append(" ");
        this.out.append(data.transceiverInterfaceRate).append(" ");
        this.out.append(data.numPrioritySlots).append(" ");
        this.out.append(data.minimumClockRate).append(" ");
        this.out.append(data.averagePacketSize).append(" ");
        this.out.append(data.oscillatorAccuracy).append(" ");
        this.out.append(data.oscillatorWakeupTime).append("\n");
        this.out.append(data.channelBitRate).append(" ");
        this.out.append(this.booleanToInt(data.specialBitRate)).append(" ");
        this.out.append(this.booleanToInt(data.specialPreambleControl)).append(" ");
        int wake = data.specialWakeupDirection.equals("output") ? 1 : 0;
        this.out.append(wake).append(" ");
        this.out.append(this.booleanToInt(data.overridesGenPurposeData)).append(" ");
        this.out.append(data.generalPurposeData1).append(" ");
        this.out.append(data.generalPurposeData2).append(" ");
        this.out.append(data.generalPurposeData3).append(" ");
        this.out.append(data.generalPurposeData4).append(" ");
        this.out.append(data.generalPurposeData5).append(" ");
        this.out.append(data.generalPurposeData6).append(" ");
        this.out.append(data.generalPurposeData7).append("\n");
        this.out.append(data.rcvStartDelay).append(" ");
        this.out.append(data.rcvEndDelay).append(" ");
        this.out.append(data.indeterminateTime).append(" ");
        this.out.append(data.minInterpacketTime).append(" ");
        this.out.append(data.preambleLength).append(" ");
        this.out.append(data.turnaroundTime).append(" ");
        this.out.append(data.missedPreambleTime).append(" ");
        this.out.append(data.packetQualificationTime).append(" ");
        this.out.append(this.booleanToInt(data.rawDataOverrides)).append(" ");
        this.out.append(data.rawDataClockRate).append(" ");
        this.out.append(data.rawData1).append(" ");
        this.out.append(data.rawData2).append(" ");
        this.out.append(data.rawData3).append(" ");
        this.out.append(data.rawData4).append(" ");
        this.out.append(data.rawData5).append("\n");
        this.out.append("*\n");
        String selfDoc = this.bdev.getSelfDoc();
        while (selfDoc.length() > 60) {
            String temp = selfDoc.substring(0, 60);
            this.out.append("\"" + temp + "\n");
            selfDoc = selfDoc.substring(60);
        }
        this.out.append("\"" + selfDoc + "\n");
        this.out.append("\n");
    }

    private void writeNetworkVariableDefinition() {
        BINetworkVariable[] netvars = this.bdev.getNetworkVariables();
        for (int i = 0; i < netvars.length; ++i) {
            BStruct props;
            BNvConfigData cfd;
            BLonComponent local;
            if (netvars[i].isLocalNv()) {
                local = (BLocalNv)netvars[i];
                cfd = ((BLocalNv)local).getNvConfigData();
                props = ((BLocalNv)local).getNvProps();
                this.out.append("VAR ").append(this.fixName(local.getName())).append(" ");
                this.out.append(((BLocalNv)local).getNvIndex()).append(" ");
                this.out.append("0 0 0\n");
                this.out.append("0").append(" ");
                this.out.append("1").append(" ");
                this.out.append("63").append(" ");
                this.out.append(this.booleanToInt(cfd.isOutput())).append(" ");
                this.out.append(this.srvTypeToInt(cfd.getServiceType())).append(" ");
                this.out.append(this.booleanToInt(props.getServiceConf())).append(" ");
                this.out.append(this.booleanToInt(cfd.getAuthenticated())).append(" ");
                this.out.append(this.booleanToInt(props.getAuthConf())).append(" ");
                this.out.append(this.booleanToInt(cfd.getPriority())).append(" ");
                this.out.append(this.booleanToInt(props.getPriorityConf())).append(" ");
                this.out.append(this.booleanToInt(props.getPolled())).append(" ");
                this.out.append(this.booleanToInt(props.getSync())).append(" ");
                this.out.append("0\n");
                this.appendSelfDoc(((BLocalNv)local).getSelfDoc());
                this.addNvSchema(((BLocalNv)local).getSnvtType(), local);
                continue;
            }
            if (!netvars[i].isLocalNci()) continue;
            local = (BLocalNci)netvars[i];
            cfd = ((BLocalNci)local).getNvConfigData();
            props = ((BLocalNci)local).getNcProps();
            this.out.append("VAR ").append(this.fixName(local.getName())).append(" ");
            this.out.append(((BLocalNci)local).getNvIndex()).append(" ");
            this.out.append("0 0 0\n");
            this.out.append(this.booleanToInt(props.getModifyFlag().isOffline())).append(" ");
            this.out.append("1 ");
            this.out.append("63 ");
            this.out.append(this.booleanToInt(cfd.isOutput())).append(" ");
            this.out.append(this.srvTypeToInt(cfd.getServiceType())).append(" ");
            this.out.append("1 ");
            this.out.append(this.booleanToInt(cfd.getAuthenticated())).append(" ");
            this.out.append("1 ");
            this.out.append(this.booleanToInt(cfd.getPriority())).append(" ");
            this.out.append("1 ");
            this.out.append("0 ");
            this.out.append("0 ");
            this.out.append("1\n");
            this.appendSelfDoc(((BLocalNci)local).getSelfDoc());
            this.addNvSchema(((BLocalNci)local).getSnvtType(), local);
        }
    }

    private String fixName(String name) {
        if (name.length() <= 16) {
            return name;
        }
        return name.substring(0, 16);
    }

    private void appendSelfDoc(String selfDoc) {
        if (selfDoc.length() == 0 || selfDoc.equals("*")) {
            this.out.append("*\n");
        } else {
            while (selfDoc.length() > 60) {
                this.out.append("\"" + selfDoc.substring(0, 60) + "\n");
                selfDoc = selfDoc.substring(60);
            }
            this.out.append("\"" + selfDoc + "\n");
        }
    }

    private void addNvSchema(int snvtType, BLonData dat) {
        BLonElementQualifiers[] quals = this.getElementQualifiers(dat);
        this.out.append(snvtType).append(" * ");
        int elemCntPos = this.out.length();
        int elemCnt = quals.length;
        this.out.append("\n");
        block5: for (int i = 0; i < quals.length; ++i) {
            BLonElementQualifiers q = quals[i];
            BLonElementType type = q.getElemtype();
            switch (type.getOrdinal()) {
                case 5: {
                    this.out.append("1 0 0 1 4\n");
                    continue block5;
                }
                case 16: {
                    this.out.append("1 0 0 0 4\n");
                    continue block5;
                }
                case 8: {
                    this.out.append("3 0 1 0 0\n");
                    this.out.append("3 1 7 0 0\n");
                    this.out.append("3 0 1 0 0\n");
                    this.out.append("3 1 7 0 0\n");
                    this.out.append("2 0 0 0 0\n");
                    elemCnt += 4;
                    continue block5;
                }
                default: {
                    int typ = this.typeToInt(type);
                    boolean bit = typ == 3;
                    boolean ary = typ == 0 || typ == 1;
                    this.out.append(typ).append(" ");
                    this.out.append(bit ? Math.abs(q.getBitOffset() + q.getLength() - 8) : 0).append(" ");
                    this.out.append(bit ? q.getLength() : 0).append(" ");
                    this.out.append(this.signed(type)).append(" ");
                    this.out.append(ary ? q.getLength() : 0).append("\n");
                }
            }
        }
        this.out.insert(elemCntPos, elemCnt);
    }

    private BLonElementQualifiers[] getElementQualifiers(BLonData dat) {
        Array a = new Array(BLonElementQualifiers.class);
        try {
            this.getElementQualifiers(dat, (Array<BLonElementQualifiers>)a);
        }
        catch (LonException e) {
            throw new BajaRuntimeException((Throwable)((Object)e));
        }
        return (BLonElementQualifiers[])a.trim();
    }

    private void getElementQualifiers(BLonData ldat, Array<BLonElementQualifiers> a) throws LonException {
        SlotCursor c = ldat.getProperties();
        while (c.nextObject()) {
            BValue obj = c.get();
            Type typ = obj.getType();
            if (typ.is(BLonPrimitive.TYPE)) {
                a.add((Object)LonFacetsUtil.getElementQualifiers(ldat, c.property()));
                continue;
            }
            if (!typ.is(BLonData.TYPE)) continue;
            this.getElementQualifiers((BLonData)obj, a);
        }
    }

    private int typeToInt(BLonElementType type) {
        switch (type.getOrdinal()) {
            case 0: 
            case 14: {
                return 0;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return 3;
            }
        }
        return 5;
    }

    private int signed(BLonElementType type) {
        switch (type.getOrdinal()) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                return 0;
            }
        }
        return 1;
    }

    private int booleanToInt(boolean bool) {
        if (bool) {
            return 1;
        }
        return 0;
    }

    private int appTypeToInt(String apptype) {
        if (apptype.equals("mip")) {
            return 1;
        }
        if (apptype.equals("neuron")) {
            return 2;
        }
        if (apptype.equals("hostSelect")) {
            return 3;
        }
        if (apptype.equals("hostNISelect")) {
            return 4;
        }
        return 0;
    }

    private int srvTypeToInt(BLonServiceType srvTyp) {
        if (srvTyp == BLonServiceType.acked) {
            return 0;
        }
        if (srvTyp == BLonServiceType.unackedRpt) {
            return 1;
        }
        if (srvTyp == BLonServiceType.unacked) {
            return 2;
        }
        return 2;
    }
}

