/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.resource;

import com.tridium.lonworks.resource.CatalogFile;
import com.tridium.lonworks.resource.FptFile;
import com.tridium.lonworks.resource.LanguageFile;
import com.tridium.lonworks.resource.ResFileInputStream;
import com.tridium.lonworks.resource.ResourceFile;
import com.tridium.lonworks.resource.TypeFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;

public class ResourceFileUtil {
    public static ResourceFile getResourceFile(String filename) throws IOException {
        String fname = filename.replace('\\', '/');
        BIFile f = (BIFile)BOrd.make((String)("file:/" + fname)).resolve().get();
        return ResourceFileUtil.getResourceFile(f);
    }

    public static ResourceFile getResourceFile(File file) throws IOException {
        return ResourceFileUtil.getResourceFile(new FileInputStream(file), file.getName());
    }

    public static ResourceFile getResourceFile(BIFile f) throws IOException {
        return ResourceFileUtil.getResourceFile(f.getInputStream(), f.getFileName());
    }

    private static ResourceFile getResourceFile(InputStream in, String fileName) throws IOException {
        int len = in.available();
        byte[] a = new byte[len];
        for (int i = 0; i < len; ++i) {
            a[i] = (byte)in.read();
        }
        return ResourceFileUtil.getResourceFile(new ResFileInputStream(a), fileName);
    }

    private static ResourceFile getResourceFile(ResFileInputStream in, String fileName) throws IOException {
        ResourceFile rf;
        int fileType;
        in.readCharacter();
        in.fileType = fileType = ResourceFileUtil.typeStringToInt(in.readString(3));
        in.seek(0L);
        switch (fileType) {
            case 1: {
                rf = new CatalogFile();
                break;
            }
            case 2: {
                rf = new LanguageFile();
                break;
            }
            case 3: {
                rf = new TypeFile();
                break;
            }
            case 4: {
                rf = new FptFile();
                break;
            }
            default: {
                throw new RuntimeException("Unsupported type " + fileType);
            }
        }
        rf.fileName = fileName;
        try {
            rf.parse(in);
        }
        catch (Throwable e) {
            System.out.println(e);
            e.printStackTrace();
        }
        return rf;
    }

    public static int typeStringToInt(String s) {
        if (s.equalsIgnoreCase("CAT")) {
            return 1;
        }
        if (s.equalsIgnoreCase("RES")) {
            return 2;
        }
        if (s.equalsIgnoreCase("TYP")) {
            return 3;
        }
        if (s.equalsIgnoreCase("FPT")) {
            return 4;
        }
        if (s.equalsIgnoreCase("FMT")) {
            return 5;
        }
        return 0;
    }

    public static String typeIntToString(int t) {
        switch (t) {
            case 1: {
                return "Catalog";
            }
            case 2: {
                return "Lanquage Resource";
            }
            case 3: {
                return "Type";
            }
            case 4: {
                return "FPT";
            }
            case 5: {
                return "Format";
            }
        }
        return "Unknown file type";
    }
}

