/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.resource;

import com.tridium.lonworks.resource.Conversion;
import com.tridium.lonworks.resource.CpType;
import com.tridium.lonworks.resource.EnumSet;
import com.tridium.lonworks.resource.Fpt;
import com.tridium.lonworks.resource.FptFile;
import com.tridium.lonworks.resource.LanguageFile;
import com.tridium.lonworks.resource.ResourceFile;
import com.tridium.lonworks.resource.ResourceFileUtil;
import com.tridium.lonworks.resource.Type;
import com.tridium.lonworks.resource.TypeFile;
import com.tridium.lonworks.util.LonFileUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.DefaultFileCopy;
import javax.baja.units.BUnit;

public class CrossReference {
    Conversion.UnitPrompt unitPrompt = null;
    boolean[] marks = new boolean[]{false, false, false, false, false, false, false};
    Resource resources = null;
    Resource standard = null;
    PrintStream out = System.out;

    public CrossReference(boolean createStandard, String dir) {
        String fname = "standard";
        Resource res = new Resource();
        res.fileName = fname;
        try {
            BIFile f = LonFileUtil.getFile(dir + "/STANDARD.typ");
            res.typFile = (TypeFile)ResourceFileUtil.getResourceFile(f);
            f = LonFileUtil.getFile(dir + "/STANDARD.fpt");
            res.fptFile = (FptFile)ResourceFileUtil.getResourceFile(f);
            f = LonFileUtil.getFile(dir + "/STANDARD.enu");
            res.lanFile = (LanguageFile)ResourceFileUtil.getResourceFile(f);
            File loc = new File(".");
            f = LonFileUtil.getFile(loc.getCanonicalPath() + "/StandardConversion.xml");
            res.conversion = new Conversion(f);
        }
        catch (Throwable e) {
            System.out.println(e);
        }
        this.standard = res;
        res.standard = true;
        res.next = this.resources;
        this.resources = res;
    }

    public CrossReference() {
        this.addStandard();
    }

    public CrossReference(PrintStream out) {
        this.out = out;
        this.addStandard();
    }

    private void addStandard() {
        String fname = "standard";
        Resource res = new Resource();
        res.fileName = fname;
        BIFile f = (BIFile)BOrd.make((String)"module://lonworks/type/Standard.typ").get();
        try {
            res.typFile = (TypeFile)ResourceFileUtil.getResourceFile(f);
        }
        catch (IOException e) {
            this.out.println(e);
        }
        f = (BIFile)BOrd.make((String)"module://lonworks/type/Standard.fpt").get();
        try {
            res.fptFile = (FptFile)ResourceFileUtil.getResourceFile(f);
        }
        catch (IOException e) {
            this.out.println("No \".fpt\" file for " + fname);
        }
        f = (BIFile)BOrd.make((String)"module://lonworks/type/Standard.enu").get();
        try {
            res.lanFile = (LanguageFile)ResourceFileUtil.getResourceFile(f);
        }
        catch (IOException e) {
            this.out.println("No \".enu\" file for " + fname);
        }
        try {
            DefaultFileCopy.copyFile((String)"lonStandardConversion.xml");
            f = (BIFile)BOrd.make((String)"file:!defaults/lonStandardConversion.xml").get();
        }
        catch (IOException | UnresolvedException e) {
            f = (BIFile)BOrd.make((String)"module://lonworks/type/StandardConversion.xml").get();
        }
        res.conversion = new Conversion(f);
        this.standard = res;
        res.standard = true;
        this.addResource(res);
    }

    private void addResource(Resource nres) {
        if (this.resources == null || this.resources.typFile.scope <= nres.typFile.scope) {
            nres.next = this.resources;
            this.resources = nres;
            return;
        }
        Resource res = this.resources;
        Resource nxt = res.next;
        while (nxt != null) {
            if (nxt.typFile.scope < nres.typFile.scope) {
                nres.next = nxt;
                res.next = nres;
                return;
            }
            res = nxt;
            nxt = res.next;
        }
        res.next = nres;
    }

    private void verifyUniqueResourceId(TypeFile tFile, String fName) throws DuplicateResourceException {
        Resource res = this.resources;
        while (res != null) {
            if (res.typFile.scope == tFile.scope && this.compareArray(res.typFile.refId, tFile.refId, 8)) {
                throw new DuplicateResourceException("Duplicate resource sets: " + fName + " & " + this.stripFilename(res.fileName) + " for scope " + res.typFile.scope + " and refId: " + ByteArrayUtil.toHexString((byte[])res.typFile.refId));
            }
            res = res.next;
        }
    }

    private boolean compareArray(byte[] a1, byte[] a2, int lenToComp) {
        if (lenToComp == 0) {
            return true;
        }
        if (a1[0] != 15) {
            if ((a1[0] & 0xF) != (a2[0] & 0xF)) {
                return false;
            }
            int a = a1[0] >> 4 & 0xF;
            int b = a2[0] >> 4 & 0xF;
            if (a != 8 && a != 9 || b != 8 && b != 9) {
                return false;
            }
        }
        for (int i = 1; i < lenToComp; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public void addResource(BDirectory dir, String fileName, TypeFile tFile) throws DuplicateResourceException {
        String fname = this.stripFilename(fileName);
        Resource res = new Resource();
        res.fileName = fname;
        res.typFile = tFile;
        if (res.typFile == null) {
            res.typFile = (TypeFile)this.getResourceFile(dir, fname, ".typ");
        }
        res.fptFile = (FptFile)this.getResourceFile(dir, fname, ".fpt");
        res.lanFile = this.getLanguageFile(dir, fname);
        this.verifyUniqueResourceId(res.typFile, fname);
        BIFile f = LonFileUtil.getOrMakeFile(dir, fname + "Conversion.xml");
        if (f != null) {
            res.conversion = new Conversion(f);
        }
        res.conversion.setUnitPrompt(this.unitPrompt);
        this.addResource(res);
    }

    private LanguageFile getLanguageFile(BDirectory resDir, String typName) {
        BIFile[] files = resDir.listFiles();
        LanguageFile lf = null;
        for (int i = 0; i < files.length; ++i) {
            if (!this.fileNameNoExt(files[i].getFileName()).equals(typName)) continue;
            ResourceFile rf = null;
            try {
                rf = ResourceFileUtil.getResourceFile(files[i]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (rf == null || rf.fileType != 2) continue;
            if (lf == null) {
                lf = (LanguageFile)rf;
                this.out.println("Using language file: " + files[i].getFileName());
                continue;
            }
            this.out.println("Detected duplicate language file: " + files[i].getFileName());
        }
        return null;
    }

    private String fileNameNoExt(String fName) {
        int n = fName.indexOf(".");
        return n > 0 ? fName.substring(0, n) : fName;
    }

    private String stripFilename(String fileName) {
        String fname = fileName.lastIndexOf(46) > 0 ? fileName.substring(0, fileName.lastIndexOf(46)) : fileName;
        return fname;
    }

    private ResourceFile getResourceFile(BDirectory dir, String fname, String ext) {
        try {
            BIFile lf = LonFileUtil.getFile(dir, fname + ext);
            if (lf != null) {
                return ResourceFileUtil.getResourceFile(lf);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.out.println("Error opening " + fname + ext);
        return null;
    }

    public Type findNvType(int scope, int index) {
        if (index <= 0) {
            throw new RuntimeException("Not a valid index (" + index + ")");
        }
        Resource res = this.getResouce(scope);
        TypeFile tf = res.typFile;
        if (tf == null) {
            Thread.dumpStack();
        }
        if (tf == null) {
            throw new RuntimeException("No type file for scope " + scope);
        }
        Type[] ta = tf.nvTypes;
        if (index > ta.length) {
            throw new RuntimeException("No nvType index (" + index + ") found in " + tf.fileName);
        }
        return ta[index - 1];
    }

    public CpType findCpType(int scope, int index) {
        Resource res = this.getResouce(scope);
        TypeFile tf = res.typFile;
        if (tf == null) {
            Thread.dumpStack();
        }
        if (tf == null) {
            throw new RuntimeException("No type file for scope " + scope);
        }
        CpType[] ta = tf.cpTypes;
        if (index < 0 || index > ta.length) {
            throw new RuntimeException("No cpType index (" + index + ") found in " + tf.fileName);
        }
        return ta[index - 1];
    }

    public EnumSet findEnum(int scope, int index) {
        Resource res = this.getResouce(scope);
        TypeFile tf = res.typFile;
        if (tf == null) {
            Thread.dumpStack();
        }
        if (tf == null) {
            throw new RuntimeException("No type file for scope " + scope);
        }
        EnumSet[] ea = tf.enumSets;
        if (index > ea.length) {
            throw new RuntimeException("No enum index " + index + " found in " + tf.fileName);
        }
        EnumSet es = ea[index - 1];
        if (res.conversion != null && res.conversion.isBooleanEnum(es.enumTag)) {
            es.isBoolean = true;
        }
        return es;
    }

    public Type findNvTypeByObject(int objType, int memNdx, boolean mfgMember) {
        Resource res = this.resources;
        while (res != null) {
            if (res.standard == mfgMember) {
                res = res.next;
                continue;
            }
            FptFile f = res.fptFile;
            Fpt fpt = f.getFptByKey(objType);
            if (fpt != null) {
                Fpt.Nv nv = fpt.getMemberNv(memNdx);
                if (nv == null) {
                    throw new RuntimeException("No member " + memNdx + " for object type " + objType + " in file " + f.fileName);
                }
                if (nv.nvTIndex <= 0) {
                    throw new RuntimeException("Member nv " + memNdx + " for object type " + objType + " in file " + f.fileName + " has no type specified.");
                }
                Type typ = this.findNvType(nv.nvTScope, nv.nvTIndex);
                if (typ == null) {
                    throw new RuntimeException("Could not find nv type " + nv.nvTScope + "," + nv.nvTIndex);
                }
                return typ;
            }
            res = res.next;
        }
        throw new RuntimeException("Could not find object type " + objType);
    }

    public String getCpName(int objType, int scope, int index) {
        Fpt fpt;
        Resource res = this.resources;
        while (res != null) {
            if (res.standard) {
                res = res.next;
                continue;
            }
            FptFile f = res.fptFile;
            Fpt fpt2 = f.getFptByKey(objType);
            if (fpt2 != null) {
                Fpt sfpt;
                Fpt.Cp cp = fpt2.getMemberCp(scope, index);
                if (cp == null && fpt2.inheritMark && this.standard != null && (sfpt = this.standard.fptFile.getFptByKey(objType)) != null) {
                    cp = sfpt.getMemberCp(scope, index);
                }
                if (cp == null) {
                    throw new RuntimeException("No member cp with scope/index " + scope + "/" + index + " in " + fpt2.key + " " + f.fileName);
                }
                return cp.cpName;
            }
            res = res.next;
        }
        if (this.standard != null && (fpt = this.standard.fptFile.getFptByKey(objType)) != null) {
            Fpt.Cp cp = fpt.getMemberCp(scope, index);
            if (cp == null) {
                throw new RuntimeException("No member cp with scope/index " + scope + "/" + index + " in " + fpt.key + " " + this.standard.fileName);
            }
            return cp.cpName;
        }
        throw new RuntimeException("Could not find object type " + objType);
    }

    public String getResourceString(int scope, int index) {
        String str;
        block4: {
            Resource res = this.getResouce(scope);
            LanguageFile lf = res.lanFile;
            if (lf == null) {
                throw new RuntimeException("No language file for scope " + scope);
            }
            LanguageFile.LangRec[] recs = lf.langRecs;
            if (index > recs.length) {
                throw new RuntimeException("No index " + scope + "/" + index + " found in " + lf.fileName);
            }
            str = recs[index - 1].resStr;
            try {
                String ls = str.toLowerCase();
                BUnit.getUnit((String)ls);
                str = ls;
            }
            catch (Throwable e) {
                Conversion sc = res.conversion;
                if (sc == null) break block4;
                str = sc.getConversionString(scope, index, str);
            }
        }
        return str;
    }

    public String getPrincipalNv(int objType) {
        Resource res = this.resources;
        while (res != null) {
            if (res.standard) {
                res = res.next;
                continue;
            }
            boolean mfg = true;
            FptFile f = res.fptFile;
            Fpt fpt = f.getFptByKey(objType);
            if (fpt != null) {
                if (fpt.principalNV == 0 && fpt.inheritMark && this.standard != null) {
                    fpt = this.standard.fptFile.getFptByKey(objType);
                    mfg = false;
                }
                if (fpt.principalNV <= 0) {
                    throw new RuntimeException("No principalNV for objType " + objType);
                }
                return (mfg ? "#" : "|") + fpt.principalNV;
            }
            res = res.next;
        }
        if (this.standard != null) {
            Fpt fpt = this.standard.fptFile.getFptByKey(objType);
            if (fpt.principalNV <= 0) {
                throw new RuntimeException("No principalNV for objType " + objType);
            }
            return "|" + fpt.principalNV;
        }
        throw new RuntimeException("Could not find object type " + objType);
    }

    public void setUnitPrompt(Conversion.UnitPrompt u) {
        this.unitPrompt = u;
        Resource res = this.resources;
        while (res != null) {
            if (res.conversion != null) {
                res.conversion.setUnitPrompt(u);
            }
            res = res.next;
        }
    }

    public Conversion getConversion(String fName) {
        String fileName = this.stripFilename(fName);
        Resource res = this.resources;
        while (res != null && !res.fileName.equals(fileName)) {
            res = res.next;
        }
        if (res == null) {
            return null;
        }
        return res.conversion;
    }

    public TypeFile[] getTypeFiles(boolean marked) {
        Array a = new Array(TypeFile.class);
        Resource res = this.resources;
        while (res != null) {
            if (!(res.standard || marked && !this.marks[res.typFile.scope])) {
                a.add((Object)res.typFile);
            }
            res = res.next;
        }
        return (TypeFile[])a.trim();
    }

    public void flush() {
        Resource res = this.resources;
        while (res != null) {
            if (res.conversion != null) {
                res.conversion.flush();
            }
            res = res.next;
        }
    }

    Resource getResouce(int scope) {
        Resource res = this.resources;
        while (res != null && res.typFile != null && res.typFile.scope != scope) {
            res = res.next;
        }
        if (res == null) {
            throw new RuntimeException("No resource file for scope " + scope);
        }
        return res;
    }

    public LanguageFile getLanguageFile(int scope) {
        Resource res = this.getResouce(scope);
        LanguageFile lf = res.lanFile;
        if (lf == null) {
            throw new RuntimeException("No language file for scope " + scope);
        }
        return lf;
    }

    public void mark(int scope) {
        if (scope < 0 || scope >= this.marks.length) {
            return;
        }
        this.marks[scope] = true;
    }

    public void clearMarks() {
        this.marks = new boolean[]{false, false, false, false, false, false, false};
    }

    static class Resource {
        String fileName;
        TypeFile typFile = null;
        FptFile fptFile = null;
        LanguageFile lanFile = null;
        Conversion conversion = null;
        Resource next = null;
        boolean standard = false;

        Resource() {
        }
    }

    public static class DuplicateResourceException
    extends Exception {
        final String msg;

        DuplicateResourceException(String reason) {
            this.msg = reason;
        }

        @Override
        public String toString() {
            return this.msg;
        }
    }
}

