/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmgmt;

import com.tridium.lonworks.BLonRouter;
import com.tridium.lonworks.datatypes.BAppDownloadParameter;
import com.tridium.lonworks.datatypes.BCommissionParameter;
import com.tridium.lonworks.datatypes.BDescriptorTable;
import com.tridium.lonworks.datatypes.BDeviceEntry;
import com.tridium.lonworks.datatypes.BDeviceEntryTable;
import com.tridium.lonworks.datatypes.BDiscoverParameter;
import com.tridium.lonworks.datatypes.BLearnParameter;
import com.tridium.lonworks.datatypes.BLinkEntryTable;
import com.tridium.lonworks.datatypes.BMatchParameter;
import com.tridium.lonworks.datatypes.BRouterEntry;
import com.tridium.lonworks.datatypes.BRouterEntryTable;
import com.tridium.lonworks.datatypes.BServicePinData;
import com.tridium.lonworks.datatypes.BSetServiceTypeParameter;
import com.tridium.lonworks.datatypes.BTagLinkEntry;
import com.tridium.lonworks.datatypes.BTagLinkEntryTable;
import com.tridium.lonworks.datatypes.BUtilitiesCommand;
import com.tridium.lonworks.netmessages.ServicePin;
import com.tridium.lonworks.netmgmt.BLonAppDownloadJob;
import com.tridium.lonworks.netmgmt.BLonBindJob;
import com.tridium.lonworks.netmgmt.BLonCommissionJob;
import com.tridium.lonworks.netmgmt.BLonCommissionRouterJob;
import com.tridium.lonworks.netmgmt.BLonDiscoverJob;
import com.tridium.lonworks.netmgmt.BLonLearnJob;
import com.tridium.lonworks.netmgmt.BLonLearnLinksJob;
import com.tridium.lonworks.netmgmt.BLonReplaceJob;
import com.tridium.lonworks.netmgmt.BLonSetServiceTypeJob;
import com.tridium.lonworks.netmgmt.BLonUpdateRoutersJob;
import com.tridium.lonworks.netmgmt.ConnectionTable;
import com.tridium.lonworks.netmgmt.LonUtilRequest;
import com.tridium.lonworks.netmgmt.ProcessServicePin;
import com.tridium.lonworks.util.NmUtil;
import com.tridium.lonworks.util.RouterUtil;
import com.tridium.sys.station.Station;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.lonworks.AddressManager;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BAuthenticationKey;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BDomainId;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.naming.BOrd;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

public class BLonNetmgmt
extends BComponent {
    public static final Property deviceDiscoverTable = BLonNetmgmt.newProperty((int)6, (BValue)new BDeviceEntryTable(), null);
    public static final Property routerDiscoverTable = BLonNetmgmt.newProperty((int)6, (BValue)new BRouterEntryTable(), null);
    public static final Property domainId = BLonNetmgmt.newProperty((int)0, (BValue)BDomainId.DEFAULT, null);
    public static final Property authenticate = BLonNetmgmt.newProperty((int)0, (boolean)false, null);
    public static final Property authenticationKey = BLonNetmgmt.newProperty((int)0, (BValue)BAuthenticationKey.DEFAULT, null);
    public static final Property linkDescriptors = BLonNetmgmt.newProperty((int)0, (BValue)new BDescriptorTable(), null);
    public static final Property nonGroupTimer = BLonNetmgmt.newProperty((int)0, (int)4, null);
    public static final Property channelPriorities = BLonNetmgmt.newProperty((int)0, (int)0, null);
    public static final Property debug = BLonNetmgmt.newProperty((int)0, (boolean)false, null);
    public static final Property verifyNvDir = BLonNetmgmt.newProperty((int)0, (boolean)false, null);
    public static final Property servicePinWait = BLonNetmgmt.newProperty((int)0, (int)300, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"second")));
    public static final Property enabled = BLonNetmgmt.newProperty((int)7, (boolean)true, null);
    public static final Property tempBridge = BLonNetmgmt.newProperty((int)5, (boolean)false, null);
    public static final Property useLonObjects = BLonNetmgmt.newProperty((int)0, (boolean)false, null);
    public static final Property alwaysInZeroLengthDomain = BLonNetmgmt.newProperty((int)0, (boolean)false, null);
    public static final Action discover = BLonNetmgmt.newAction((int)4, null);
    public static final Action discoverSelect = BLonNetmgmt.newAction((int)4, (BValue)new BDiscoverParameter(), null);
    public static final Action learn = BLonNetmgmt.newAction((int)4, (BValue)new BLearnParameter(), null);
    public static final Action match = BLonNetmgmt.newAction((int)4, (BValue)new BMatchParameter(), null);
    public static final Action commissionDevice = BLonNetmgmt.newAction((int)4, (BValue)new BCommissionParameter(), null);
    public static final Action replaceDevice = BLonNetmgmt.newAction((int)4, (BValue)new BCommissionParameter(), null);
    public static final Action commissionRouter = BLonNetmgmt.newAction((int)4, (BValue)new BCommissionParameter(), null);
    public static final Action replaceRouter = BLonNetmgmt.newAction((int)4, (BValue)new BCommissionParameter(), null);
    public static final Action setServiceType = BLonNetmgmt.newAction((int)4, (BValue)new BSetServiceTypeParameter(), null);
    public static final Action bind = BLonNetmgmt.newAction((int)4, null);
    public static final Action bindLinkEntry = BLonNetmgmt.newAction((int)4, (BValue)BString.DEFAULT, null);
    public static final Action bindTagLinkEntry = BLonNetmgmt.newAction((int)4, (BValue)new BTagLinkEntry(), null);
    public static final Action bindDevice = BLonNetmgmt.newAction((int)4, (BValue)new BLonDevice(), null);
    public static final Action refreshLinkTable = BLonNetmgmt.newAction((int)4, null);
    public static final Action tempBridgeOn = BLonNetmgmt.newAction((int)0, null);
    public static final Action tempBridgeOff = BLonNetmgmt.newAction((int)0, null);
    public static final Action appDownLoad = BLonNetmgmt.newAction((int)4, (BValue)new BAppDownloadParameter(), null);
    public static final Action deviceForSubnetNodeId = BLonNetmgmt.newAction((int)4, (BValue)BSubnetNode.DEFAULT, null);
    public static final Action deviceForNeuronId = BLonNetmgmt.newAction((int)4, (BValue)BNeuronId.DEFAULT, null);
    public static final Action updateRouters = BLonNetmgmt.newAction((int)0, null);
    public static final Action cancelServicePin = BLonNetmgmt.newAction((int)0, null);
    public static final Topic deviceDiscoveryUpdated = BLonNetmgmt.newTopic((int)0, null);
    public static final Topic routerDiscoveryUpdated = BLonNetmgmt.newTopic((int)0, null);
    public static final Topic devicesUpdated = BLonNetmgmt.newTopic((int)0, null);
    public static final Topic routersUpdated = BLonNetmgmt.newTopic((int)0, null);
    public static final Topic linksUpdated = BLonNetmgmt.newTopic((int)0, null);
    public static final Topic tagLinksUpdated = BLonNetmgmt.newTopic((int)0, null);
    public static final Topic servicePinReceived = BLonNetmgmt.newTopic((int)0, null);
    public static final Topic learnComplete = BLonNetmgmt.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BLonNetmgmt.class);
    private static final BIcon icon = BIcon.std((String)"match.png");

    public BDeviceEntryTable getDeviceDiscoverTable() {
        return (BDeviceEntryTable)this.get(deviceDiscoverTable);
    }

    public void setDeviceDiscoverTable(BDeviceEntryTable v) {
        this.set(deviceDiscoverTable, (BValue)v, null);
    }

    public BRouterEntryTable getRouterDiscoverTable() {
        return (BRouterEntryTable)this.get(routerDiscoverTable);
    }

    public void setRouterDiscoverTable(BRouterEntryTable v) {
        this.set(routerDiscoverTable, (BValue)v, null);
    }

    public BDomainId getDomainId() {
        return (BDomainId)this.get(domainId);
    }

    public void setDomainId(BDomainId v) {
        this.set(domainId, (BValue)v, null);
    }

    public boolean getAuthenticate() {
        return this.getBoolean(authenticate);
    }

    public void setAuthenticate(boolean v) {
        this.setBoolean(authenticate, v, null);
    }

    public BAuthenticationKey getAuthenticationKey() {
        return (BAuthenticationKey)this.get(authenticationKey);
    }

    public void setAuthenticationKey(BAuthenticationKey v) {
        this.set(authenticationKey, (BValue)v, null);
    }

    public BDescriptorTable getLinkDescriptors() {
        return (BDescriptorTable)this.get(linkDescriptors);
    }

    public void setLinkDescriptors(BDescriptorTable v) {
        this.set(linkDescriptors, (BValue)v, null);
    }

    public int getNonGroupTimer() {
        return this.getInt(nonGroupTimer);
    }

    public void setNonGroupTimer(int v) {
        this.setInt(nonGroupTimer, v, null);
    }

    public int getChannelPriorities() {
        return this.getInt(channelPriorities);
    }

    public void setChannelPriorities(int v) {
        this.setInt(channelPriorities, v, null);
    }

    public boolean getDebug() {
        return this.getBoolean(debug);
    }

    public void setDebug(boolean v) {
        this.setBoolean(debug, v, null);
    }

    public boolean getVerifyNvDir() {
        return this.getBoolean(verifyNvDir);
    }

    public void setVerifyNvDir(boolean v) {
        this.setBoolean(verifyNvDir, v, null);
    }

    public int getServicePinWait() {
        return this.getInt(servicePinWait);
    }

    public void setServicePinWait(int v) {
        this.setInt(servicePinWait, v, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public boolean getTempBridge() {
        return this.getBoolean(tempBridge);
    }

    public void setTempBridge(boolean v) {
        this.setBoolean(tempBridge, v, null);
    }

    public boolean getUseLonObjects() {
        return this.getBoolean(useLonObjects);
    }

    public void setUseLonObjects(boolean v) {
        this.setBoolean(useLonObjects, v, null);
    }

    public boolean getAlwaysInZeroLengthDomain() {
        return this.getBoolean(alwaysInZeroLengthDomain);
    }

    public void setAlwaysInZeroLengthDomain(boolean v) {
        this.setBoolean(alwaysInZeroLengthDomain, v, null);
    }

    public BOrd discover() {
        return (BOrd)this.invoke(discover, null, null);
    }

    public BOrd discoverSelect(BDiscoverParameter param) {
        return (BOrd)this.invoke(discoverSelect, (BValue)param, null);
    }

    public BOrd learn(BLearnParameter param) {
        return (BOrd)this.invoke(learn, (BValue)param, null);
    }

    public BBoolean match(BMatchParameter param) {
        return (BBoolean)this.invoke(match, (BValue)param, null);
    }

    public BOrd commissionDevice(BCommissionParameter param) {
        return (BOrd)this.invoke(commissionDevice, (BValue)param, null);
    }

    public BOrd replaceDevice(BCommissionParameter entry) {
        return (BOrd)this.invoke(replaceDevice, (BValue)entry, null);
    }

    public BOrd commissionRouter(BCommissionParameter entry) {
        return (BOrd)this.invoke(commissionRouter, (BValue)entry, null);
    }

    public BOrd replaceRouter(BCommissionParameter entry) {
        return (BOrd)this.invoke(replaceRouter, (BValue)entry, null);
    }

    public BOrd setServiceType(BSetServiceTypeParameter param) {
        return (BOrd)this.invoke(setServiceType, (BValue)param, null);
    }

    public BOrd bind() {
        return (BOrd)this.invoke(bind, null, null);
    }

    public BOrd bindLinkEntry(BString selects) {
        return (BOrd)this.invoke(bindLinkEntry, (BValue)selects, null);
    }

    public BOrd bindTagLinkEntry(BTagLinkEntry entry) {
        return (BOrd)this.invoke(bindTagLinkEntry, (BValue)entry, null);
    }

    public BOrd bindDevice(BLonDevice device) {
        return (BOrd)this.invoke(bindDevice, (BValue)device, null);
    }

    public void refreshLinkTable() {
        this.invoke(refreshLinkTable, null, null);
    }

    public void tempBridgeOn() {
        this.invoke(tempBridgeOn, null, null);
    }

    public void tempBridgeOff() {
        this.invoke(tempBridgeOff, null, null);
    }

    public BOrd appDownLoad(BAppDownloadParameter param) {
        return (BOrd)this.invoke(appDownLoad, (BValue)param, null);
    }

    public BOrd deviceForSubnetNodeId(BSubnetNode para) {
        return (BOrd)this.invoke(deviceForSubnetNodeId, (BValue)para, null);
    }

    public BOrd deviceForNeuronId(BNeuronId para) {
        return (BOrd)this.invoke(deviceForNeuronId, (BValue)para, null);
    }

    public BOrd updateRouters() {
        return (BOrd)this.invoke(updateRouters, null, null);
    }

    public void cancelServicePin() {
        this.invoke(cancelServicePin, null, null);
    }

    public void fireDeviceDiscoveryUpdated(BDeviceEntryTable event) {
        this.fire(deviceDiscoveryUpdated, (BValue)event, null);
    }

    public void fireRouterDiscoveryUpdated(BRouterEntryTable event) {
        this.fire(routerDiscoveryUpdated, (BValue)event, null);
    }

    public void fireDevicesUpdated(BDeviceEntryTable event) {
        this.fire(devicesUpdated, (BValue)event, null);
    }

    public void fireRoutersUpdated(BRouterEntryTable event) {
        this.fire(routersUpdated, (BValue)event, null);
    }

    public void fireLinksUpdated(BLinkEntryTable event) {
        this.fire(linksUpdated, (BValue)event, null);
    }

    public void fireTagLinksUpdated(BTagLinkEntryTable event) {
        this.fire(tagLinksUpdated, (BValue)event, null);
    }

    public void fireServicePinReceived(BServicePinData event) {
        this.fire(servicePinReceived, (BValue)event, null);
    }

    public void fireLearnComplete(BValue event) {
        this.fire(learnComplete, event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        if (!(parent instanceof BLonNetwork)) {
            return false;
        }
        return !parent.getProperties().next(BLonNetmgmt.class);
    }

    public BLonNetwork lonNetwork() {
        return (BLonNetwork)this.getParent();
    }

    public Logger log() {
        return this.lonNetwork().log();
    }

    public final void started() {
        boolean disableNetmgmt = Boolean.getBoolean("lonworks.disableNetmgmt");
        this.setEnabled(!disableNetmgmt);
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (!this.isRunning() || context == BLonNetwork.lonNoWrite) {
            return;
        }
        if (prop == domainId || prop == authenticationKey) {
            try {
                NmUtil.updateDomainTable(this.lonNetwork().getLocalLonDevice(), this.getDomainId(), this.getAuthenticationKey(), false);
            }
            catch (LonException e) {
                this.log().log(Level.SEVERE, "Unable to update local domain table ", (Throwable)((Object)e));
            }
        }
    }

    public void doRefreshLinkTable() {
        BComponentSpace cs = this.getComponentSpace();
        if (cs == null || cs != Station.space) {
            return;
        }
        Runnable req = new Runnable(){

            @Override
            public void run() {
                BLonNetmgmt.this.asyncRefreshLinkTable();
            }
        };
        this.lonNetwork().postAsync(req);
    }

    private void asyncRefreshLinkTable() {
        try {
            ConnectionTable connTable = new ConnectionTable(this.lonNetwork());
            this.updateLinkTable(connTable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BOrd doBind() {
        return new BLonBindJob(this, null, null, this.getDebug()).submit(null);
    }

    public BOrd doBindDevice(BLonDevice dev) {
        return new BLonBindJob(this, dev, this.getDebug()).submit(null);
    }

    public BOrd doBindLinkEntry(BString selects) {
        return new BLonBindJob(this, selects, null, this.getDebug()).submit(null);
    }

    public BOrd doBindTagLinkEntry(BTagLinkEntry entry) {
        return new BLonBindJob(this, null, entry, this.getDebug()).submit(null);
    }

    void updateLinkTable(ConnectionTable connTable) {
        BLinkEntryTable lnkTab = connTable.getLonLinkTable();
        this.fireLinksUpdated(lnkTab);
        BTagLinkEntryTable tagTab = connTable.getLonMessageTagTable();
        this.fireTagLinksUpdated(tagTab);
    }

    public void deviceAdded(BLonDevice dev) {
        BDeviceEntry e = this.getDeviceDiscoverTable().findEntry(dev.getDeviceData().getNeuronId());
        if (e != null) {
            this.getDeviceDiscoverTable().removeEntry(e);
        }
        this.fireDeviceDiscoveryUpdated(this.getDeviceDiscoverTable());
    }

    public void routerAdded(BLonRouter dev) {
        BRouterEntry e = this.getRouterDiscoverTable().findEntry(dev.getNearDeviceData().getNeuronId());
        if (e != null) {
            this.getRouterDiscoverTable().removeEntry(e);
        }
        this.fireRouterDiscoveryUpdated(this.getRouterDiscoverTable());
    }

    public void receiveServicePin(ServicePin msg) {
        this.lonNetwork().postAsync(new ProcessServicePin(this, msg));
        this.fireServicePinReceived(new BServicePinData(msg.getNeuronId(), msg.getIdString()));
    }

    public BOrd doDiscover() {
        return new BLonDiscoverJob(this).submit(null);
    }

    public BOrd doDiscoverSelect(BDiscoverParameter param) {
        return new BLonDiscoverJob(this, param).submit(null);
    }

    public BOrd doLearn(BLearnParameter param) {
        if (param.isSelectedDevices()) {
            return new BLonLearnLinksJob(this, param).submit(null);
        }
        return new BLonLearnJob(this, param).submit(null);
    }

    public void doCancelServicePin() {
        this.lonNetwork().netMessageReceiver().cancelServicePin();
    }

    public BOrd doCommissionDevice(BCommissionParameter param) {
        return new BLonCommissionJob(this, param).submit(null);
    }

    public BOrd doCommissionRouter(BCommissionParameter param) {
        return new BLonCommissionRouterJob(this, param).submit(null);
    }

    public BOrd doReplaceDevice(BCommissionParameter param) {
        return new BLonReplaceJob(this, param).submit(null);
    }

    public BOrd doReplaceRouter(BCommissionParameter param) {
        return new BLonCommissionRouterJob(this, param).submit(null);
    }

    public void doTempBridgeOn() {
        Runnable req = new Runnable(){

            @Override
            public void run() {
                BLonNetmgmt.this.setTempBridge(true);
                RouterUtil.setTemporaryBridge(BLonNetmgmt.this.lonNetwork());
            }
        };
        this.lonNetwork().postAsync(req);
    }

    public void doTempBridgeOff() {
        Runnable req = new Runnable(){

            @Override
            public void run() {
                BLonNetmgmt.this.setTempBridge(false);
                RouterUtil.clearTemporaryBridge(BLonNetmgmt.this.lonNetwork());
            }
        };
        this.lonNetwork().postAsync(req);
    }

    public BOrd doAppDownLoad(BAppDownloadParameter param) {
        return new BLonAppDownloadJob(this, param).submit(null);
    }

    public BOrd doSetServiceType(BSetServiceTypeParameter param) {
        return new BLonSetServiceTypeJob(this, param).submit(null);
    }

    public BBoolean doMatch(BMatchParameter param) {
        BLonDevice dbDev = this.lonNetwork().addressManager().getDeviceByAddress(param.getDbDevSubnetNode());
        BDeviceEntry devEntry = param.getDeviceEntry();
        if (dbDev == null || devEntry == null) {
            return BBoolean.TRUE;
        }
        BDeviceData dd = dbDev.getDeviceData();
        BSubnetNode sn = BSubnetNode.make(devEntry.getSubnet(), devEntry.getNode());
        BLonDevice snDev = this.lonNetwork().addressManager().getDeviceByAddress(sn);
        if (snDev != null && snDev != dbDev) {
            return BBoolean.FALSE;
        }
        dd.set(BDeviceData.neuronId, (BValue)devEntry.getNeuronId(), AddressManager.noDeviceChange);
        dd.set(BDeviceData.subnetNodeId, (BValue)sn, AddressManager.noDeviceChange);
        dd.set(BDeviceData.nodeState, (BValue)devEntry.getState(), AddressManager.noDeviceChange);
        dd.set(BDeviceData.programId, (BValue)devEntry.getProgramId(), AddressManager.noDeviceChange);
        dd.setInt(BDeviceData.channelId, devEntry.getChannelId(), AddressManager.noDeviceChange);
        String n = devEntry.getDevName();
        if (!n.equals(dbDev.getName())) {
            dbDev.getParent().asComponent().rename(dbDev.getPropertyInParent(), n);
        }
        return BBoolean.TRUE;
    }

    public BOrd doDeviceForSubnetNodeId(BSubnetNode addr) {
        if (this.lonNetwork().addressManager() == null) {
            return null;
        }
        BLonDevice dev = this.lonNetwork().addressManager().getDeviceByAddress(addr);
        if (dev != null) {
            return dev.getHandleOrd();
        }
        BLonRouter rtr = this.lonNetwork().addressManager().getRouterByAddress(addr);
        if (rtr != null) {
            return rtr.getHandleOrd();
        }
        return null;
    }

    public BOrd doDeviceForNeuronId(BNeuronId nid) {
        if (this.lonNetwork().addressManager() == null) {
            return null;
        }
        BLonDevice dev = this.lonNetwork().addressManager().getDeviceByAddress(nid);
        if (dev != null) {
            return dev.getHandleOrd();
        }
        BLonRouter rtr = this.lonNetwork().addressManager().getRouterByAddress(nid);
        if (rtr != null) {
            return rtr.getHandleOrd();
        }
        return null;
    }

    public void executeUtilitiesCommand(BUtilitiesCommand cmd, PrintWriter out) {
        LonUtilRequest r = new LonUtilRequest(cmd, this, out);
        r.run();
        out.flush();
    }

    public BOrd doUpdateRouters() {
        return new BLonUpdateRoutersJob(this).submit(null);
    }

    public BIcon getIcon() {
        return icon;
    }
}

