/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmgmt;

import com.tridium.lonworks.BLonRouter;
import com.tridium.lonworks.datatypes.BDeviceEntryTable;
import com.tridium.lonworks.datatypes.BLearnParameter;
import com.tridium.lonworks.device.BUploadJob;
import com.tridium.lonworks.device.DynaDev;
import com.tridium.lonworks.enums.BLonRouterMode;
import com.tridium.lonworks.enums.BLonRouterType;
import com.tridium.lonworks.netmessages.QueryDomainResponse;
import com.tridium.lonworks.netmessages.QueryIdResponse;
import com.tridium.lonworks.netmessages.RouterStatusResponse;
import com.tridium.lonworks.netmgmt.BLonLearnLinksJob;
import com.tridium.lonworks.netmgmt.BLonNetmgmt;
import com.tridium.lonworks.netmgmt.BLonNetmgmtJob;
import com.tridium.lonworks.netmgmt.NetMgmtConst;
import com.tridium.lonworks.util.DeviceDef;
import com.tridium.lonworks.util.Neuron;
import com.tridium.lonworks.util.NmUtil;
import com.tridium.lonworks.util.RouterUtil;
import com.tridium.lonworks.util.selfdoc.DocToXDevice;
import com.tridium.lonworks.xml.XLonDevice;
import com.tridium.sys.transfer.TransferResult;
import com.tridium.sys.transfer.TransferStrategy;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.job.JobCancelException;
import javax.baja.lonworks.AddressManager;
import javax.baja.lonworks.BDynamicDevice;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.LonComm;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BDomainId;
import javax.baja.lonworks.datatypes.BImportParameters;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BProgramId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.enums.BLonNodeState;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IntHashMap;
import javax.baja.space.Mark;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BLonLearnJob
extends BLonNetmgmtJob
implements NetMgmtConst {
    public static final Type TYPE = Sys.loadType(BLonLearnJob.class);
    private BLonDevice[] origDevs;
    private BLonRouter[] origRtrs;
    private LonComm lonComm;
    private BDomainId ourDomain;
    private IntHashMap storage = new IntHashMap(127);
    private IntHashMap duplicateCheck = new IntHashMap(127);
    private boolean auth;
    private BLearnParameter command;
    private Array<BLonDevice> uploadDevs = new Array(BLonDevice.class);
    BComponent cont;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BLonLearnJob() {
    }

    public BLonLearnJob(BLonNetmgmt netMgmt, BLearnParameter param) {
        super(netMgmt);
        this.command = param;
        this.lonComm = this.lon.lonComm();
        this.auth = netMgmt.getAuthenticate();
        this.ourDomain = netMgmt.getDomainId();
        this.origDevs = this.lon.addressManager().getDeviceList(false);
        this.origRtrs = this.lon.addressManager().getRouterList();
        this.cont = param.getContainer().isNull() ? this.lon : (BComponent)param.getContainer().get();
    }

    @Override
    public void run() {
        try {
            BDeviceEntryTable det = this.netMgmt.getDeviceDiscoverTable();
            det.clearEntries();
            this.netMgmt.fireDeviceDiscoveryUpdated(det);
            this.doLearn();
        }
        catch (JobCancelException ce) {
            this.canceled();
        }
        catch (Throwable e) {
            this.fatal("Learn failed ", e);
        }
        this.netMgmt.fireLearnComplete(null);
        this.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLearn() {
        Array deviceIds = new Array(LonDeviceIds.class);
        this.log().start("Learning network");
        boolean unmanaged = this.command.getUnmanagedNetwork();
        boolean tmpBrdg = this.netMgmt.getTempBridge();
        try {
            BLonDevice[] devList;
            int i;
            QueryIdResponse resp;
            if (!tmpBrdg) {
                RouterUtil.setTemporaryBridge(this.lon);
            }
            NmUtil.initDiscover(this.lon, this.netMgmt, false);
            this.initDuplicateCheck();
            this.netMgmt.log().fine("Discovering devices ");
            int wrkDmn = this.lon.getLocalLonDevice().getDeviceData().getWorkingDomain();
            while ((resp = NmUtil.queryId(this.lonComm, 1, wrkDmn)) != null) {
                String msg = "Received QueryId response " + resp.toString();
                this.netMgmt.log().fine(msg);
                this.log().message(msg);
                NmUtil.wait(200);
                BProgramId pId = resp.getIdString();
                BNeuronId nId = resp.getNeuronId();
                NmUtil.setRespondToQuery(this.lonComm, nId, 0);
                this.incrementProgress(2, 70);
                boolean authOn = Neuron.isNMAuthSet(this.lonComm, nId, this.auth, false);
                BLonNodeState state = NmUtil.getDeviceState(this.lonComm, nId, authOn);
                if (!unmanaged && state != BLonNodeState.configOnline) continue;
                LonDeviceIds devIds = new LonDeviceIds(nId, pId, authOn, state);
                if (!this.processDomainAndSubnetNode(devIds, false)) {
                    return;
                }
                if (pId.isRouter()) {
                    BLonNodeState farState = NmUtil.getDeviceState(this.lonComm, nId, authOn, true);
                    devIds.farIds = new LonDeviceIds(devIds.nId, devIds.pId, devIds.authOn, farState);
                    if (!this.processDomainAndSubnetNode(devIds.farIds, true)) {
                        return;
                    }
                    if (this.matchExistingRouter(devIds)) continue;
                    RouterStatusResponse rtrStatus = RouterUtil.getRouterStatus(this.lonComm, nId, this.auth, false);
                    RouterUtil.setRouterMode(this.lonComm, nId, BLonRouterMode.temporaryBridge, this.auth);
                    devIds.rtrStatus = rtrStatus;
                } else if (this.matchExisting(devIds)) continue;
                deviceIds.add((Object)devIds);
            }
            this.progress(70);
            LonDeviceIds[] ids = (LonDeviceIds[])deviceIds.trim();
            this.netMgmt.log().fine("Seek matches for " + ids.length + " unmatched devices");
            for (i = 0; i < ids.length; ++i) {
                LonDeviceIds devIds = ids[i];
                ids[i] = null;
                this.incrementProgress(2, 90);
                if (devIds.pId.isRouter()) {
                    this.addNewRouter(devIds);
                    continue;
                }
                if (this.matchProgramId(devIds)) continue;
                if (devIds.duplicate) {
                    ids[i] = devIds;
                    continue;
                }
                this.addDynamic(devIds);
            }
            for (i = 0; i < ids.length; ++i) {
                if (ids[i] == null) continue;
                this.addDynamic(ids[i]);
            }
            this.emptyStorage();
            if (this.command.getLearnLinks() && (devList = this.lon.addressManager().getDeviceList(false)).length > 0) {
                BLonLearnLinksJob learnLinks = new BLonLearnLinksJob(this.netMgmt, devList, true);
                learnLinks.doLearnLinks();
            }
            if (this.command.getUploadConfigData()) {
                BLonDevice[] upDevs = (BLonDevice[])this.uploadDevs.trim();
                BUploadParameters up = new BUploadParameters();
                up.setUploadTransient(false);
                for (int i2 = 0; i2 < upDevs.length; ++i2) {
                    this.log().message("upload " + upDevs[i2].getDisplayName(null));
                    BUploadJob upJob = new BUploadJob(upDevs[i2], up, null);
                    upJob.run();
                }
            }
            this.success();
        }
        catch (JobCancelException ce) {
            throw ce;
        }
        catch (Exception e) {
            this.fatal("Learn request failed.", e);
        }
        finally {
            if (!tmpBrdg) {
                RouterUtil.clearTemporaryBridge(this.lon);
            }
        }
    }

    private boolean processDomainAndSubnetNode(LonDeviceIds devIds, boolean farSide) throws LonException {
        boolean authOn = devIds.authOn;
        BNeuronId nId = devIds.nId;
        BProgramId pId = devIds.pId;
        devIds.twoDomains = Neuron.isTwoDomains(this.lonComm, nId, authOn, farSide);
        QueryDomainResponse domain = NmUtil.queryDomain(this.lonComm, nId, 0, authOn, farSide);
        if (!devIds.twoDomains || domain.sameDomain(this.ourDomain)) {
            devIds.wrkDmn = 0;
        } else {
            domain = NmUtil.queryDomain(this.lonComm, nId, 1, authOn, farSide);
            devIds.wrkDmn = 1;
        }
        devIds.duplicate = this.detectDuplicate(domain, devIds.nId, farSide);
        if (!this.command.getUnmanagedNetwork() && devIds.duplicate) {
            this.fatal("Duplicate subnet node detected - " + Integer.toString(domain.getSubnet()) + "/" + Integer.toString(domain.getNodeId()));
            this.end();
            return false;
        }
        devIds.domain = domain;
        devIds.chanId = Neuron.getChannelId(this.lonComm, nId, authOn, farSide);
        return true;
    }

    private boolean matchExisting(LonDeviceIds devIds) throws LonException {
        QueryDomainResponse domain = devIds.domain;
        BLonDevice dev = this.lon.addressManager().getDeviceByAddress(BSubnetNode.make(domain.getSubnet(), domain.getNodeId()));
        if (dev == null) {
            return false;
        }
        BDeviceData dd = dev.getDeviceData();
        if (!dd.getNeuronId().isZero()) {
            return false;
        }
        BProgramId devPid = dd.getProgramId();
        if (devPid.isZero() || devPid.equals((Object)devIds.pId)) {
            this.netMgmt.log().fine("found match remove from device list for " + dev);
            this.setDeviceData(dd, devIds);
            this.uploadDevs.add((Object)dev);
            return true;
        }
        this.lon.addressManager().unregisterLonDevice(dev);
        this.storage.put(BLonLearnJob.getDeviceHash(dev), (Object)dev);
        this.netMgmt.log().fine("found subnet node - programIds don't match move " + dev.getDisplayName(null) + " to storage.");
        return false;
    }

    private boolean matchExistingRouter(LonDeviceIds devIds) throws LonException {
        for (int i = 0; i < this.origRtrs.length; ++i) {
            BLonRouter rtr;
            if (this.origRtrs[i] == null || !(rtr = this.origRtrs[i]).getNearDeviceData().getNeuronId().isZero() || rtr.getNearDeviceData().getChannelId() != devIds.chanId || rtr.getFarDeviceData().getChannelId() != devIds.farIds.chanId) continue;
            this.netMgmt.log().fine("found match for " + rtr.getDisplayName(null));
            this.setDeviceData(rtr.getNearDeviceData(), devIds);
            this.setDeviceData(rtr.getFarDeviceData(), devIds.farIds);
            RouterUtil.uploadTypeAndMode(rtr);
            return true;
        }
        return false;
    }

    private boolean matchProgramId(LonDeviceIds devIds) {
        int avalDev = -1;
        for (int i = 0; i < this.origDevs.length; ++i) {
            BLonDevice dev = this.origDevs[i];
            if (dev == null) continue;
            BDeviceData dd = dev.getDeviceData();
            if (dd.getNeuronId().isZero() && dd.getProgramId().equals((Object)devIds.pId)) {
                this.netMgmt.log().fine("found matching device " + dev.getDisplayName(null));
                this.matchDevice(dev, devIds);
                this.origDevs[i] = null;
                return true;
            }
            if (avalDev != -1 || !dd.getProgramId().isZero()) continue;
            avalDev = i;
        }
        if (avalDev >= 0) {
            this.netMgmt.log().fine(" matching node " + devIds.getNodeId() + " with dynamic device");
            BLonDevice aDev = this.origDevs[avalDev];
            this.origDevs[avalDev] = null;
            this.matchDevice(aDev, devIds);
            aDev.getDeviceData().setProgramId(devIds.pId);
            if (aDev.getType().is(BDynamicDevice.TYPE)) {
                this.importXmlFile((BDynamicDevice)aDev, devIds.pId);
                this.buildDevice((BDynamicDevice)aDev);
            }
            this.uploadDevs.add((Object)aDev);
            return true;
        }
        this.netMgmt.log().fine("no programid match found for node " + devIds.getNodeId());
        return false;
    }

    private void matchDevice(BLonDevice dev, LonDeviceIds devIds) {
        if (this.storage.get(BLonLearnJob.getDeviceHash(dev)) != null) {
            this.storage.remove(BLonLearnJob.getDeviceHash(dev));
            this.netMgmt.log().fine(" * match device from storage for s/n " + devIds.getSubnet() + "/" + devIds.getNodeId() + "\n");
        } else {
            this.lon.addressManager().unregisterLonDevice(dev);
            this.netMgmt.log().fine(" * device not in storage  s/n " + devIds.getSubnet() + "/" + devIds.getNodeId() + "\n");
        }
        this.setDeviceData(dev.getDeviceData(), devIds);
        this.lon.addressManager().registerLonDevice(dev);
    }

    private void setDeviceData(BDeviceData dd, LonDeviceIds devIds) {
        dd.set(BDeviceData.neuronId, (BValue)devIds.nId, AddressManager.noDeviceChange);
        dd.set(BDeviceData.programId, (BValue)devIds.pId, AddressManager.noDeviceChange);
        dd.setInt(BDeviceData.workingDomain, devIds.wrkDmn, AddressManager.noDeviceChange);
        dd.setBoolean(BDeviceData.authenticate, devIds.authOn, AddressManager.noDeviceChange);
        dd.setBoolean(BDeviceData.twoDomains, devIds.twoDomains, AddressManager.noDeviceChange);
        dd.setInt(BDeviceData.channelId, devIds.chanId, AddressManager.noDeviceChange);
        BLonNodeState ns = devIds.state;
        if (!devIds.duplicate) {
            dd.set(BDeviceData.subnetNodeId, (BValue)BSubnetNode.make(devIds.getSubnet(), devIds.getNodeId()), AddressManager.noDeviceChange);
        } else if (ns == BLonNodeState.configOnline || ns == BLonNodeState.configOffline) {
            ns = BLonNodeState.unconfigured;
        }
        dd.set(BDeviceData.nodeState, (BValue)ns, AddressManager.noDeviceChange);
    }

    private void emptyStorage() {
        Object[] devs = new BLonDevice[this.storage.size()];
        this.storage.toArray(devs);
        this.netMgmt.log().fine("EmptyStorage()");
        for (int i = 0; i < devs.length; ++i) {
            Object dev = devs[i];
            this.netMgmt.log().fine("moving " + dev.getDisplayName(null) + " addr " + ((BLonDevice)dev).getDeviceData().getSubnetNodeId());
            ((BLonDevice)dev).getDeviceData().set(BDeviceData.subnetNodeId, (BValue)BSubnetNode.DEFAULT, AddressManager.noDeviceChange);
            this.lon.addressManager().registerLonDevice((BLonDevice)dev);
            this.netMgmt.log().fine("new addr " + ((BLonDevice)dev).getDeviceData().getSubnetNodeId());
        }
    }

    private void initDuplicateCheck() {
        int i;
        for (i = 0; i < this.origDevs.length; ++i) {
            BLonDevice dev = this.origDevs[i];
            if (dev == null || dev.getDeviceData().getNeuronId().isZero() || dev.isLocal()) continue;
            this.duplicateCheck.put(BLonLearnJob.getDeviceHash(dev), (Object)dev);
        }
        for (i = 0; i < this.origRtrs.length; ++i) {
            BLonRouter rtr = this.origRtrs[i];
            if (rtr == null || rtr.getNearDeviceData().getNeuronId().isZero()) continue;
            this.duplicateCheck.put(BLonLearnJob.getDeviceHash(rtr.getNearDeviceData()), (Object)rtr);
            this.duplicateCheck.put(BLonLearnJob.getDeviceHash(rtr.getFarDeviceData()), (Object)rtr);
        }
    }

    private boolean detectDuplicate(QueryDomainResponse domain, BNeuronId nId, boolean farSide) {
        int hashKey = BLonLearnJob.getDeviceHash(domain.getSubnet(), domain.getNodeId());
        if (this.duplicateCheck.get(hashKey) != null) {
            BLonDevice dev = this.lon.addressManager().getDeviceByAddress(BSubnetNode.make(domain.getSubnet(), domain.getNodeId()));
            return dev == null || !dev.getDeviceData().getNeuronId().equals(nId);
        }
        this.duplicateCheck.put(hashKey, (Object)domain);
        return false;
    }

    private void addNewRouter(LonDeviceIds devIds) throws Exception {
        BNeuronId destAddr = devIds.nId;
        this.netMgmt.log().fine("Add router between channels " + devIds.chanId + " & " + devIds.farIds.chanId + ".");
        BLonRouter rtr = new BLonRouter();
        this.setDeviceData(rtr.getNearDeviceData(), devIds);
        this.setDeviceData(rtr.getFarDeviceData(), devIds.farIds);
        rtr = (BLonRouter)this.addDevice((BComplex)rtr, "LonRouter");
        rtr.set(BLonRouter.routerType, (BValue)BLonRouterType.make(devIds.rtrStatus.getType()), BLonNetwork.lonNoWrite);
        rtr.set(BLonRouter.routerMode, (BValue)BLonRouterMode.make(devIds.rtrStatus.getMode()), BLonNetwork.lonNoWrite);
        RouterUtil.uploadRouterTables(rtr);
    }

    private boolean addDynamic(LonDeviceIds devIds) throws Exception {
        DeviceDef def = new DeviceDef(devIds.pId);
        BLonDevice dev = this.createDeviceForPid(def);
        String devName = def.getName();
        if (devName == null) {
            devName = "LonDevice";
        }
        this.setDeviceData(dev.getDeviceData(), devIds);
        dev = (BLonDevice)this.addDevice((BComplex)dev, devName);
        if (dev.getType().is(BDynamicDevice.TYPE)) {
            this.buildDevice((BDynamicDevice)dev);
        }
        this.uploadDevs.add((Object)dev);
        return true;
    }

    private BComplex addDevice(BComplex dev, String devName) throws Exception {
        String n = devName;
        int cnt = 1;
        while (this.cont.get(n) != null) {
            n = devName + "_" + cnt++;
        }
        BComponent params = new BComponent();
        params.add("exact", (BValue)BBoolean.TRUE);
        Mark mark = new Mark((BObject)dev, n);
        TransferResult r = TransferStrategy.make((int)16, (Mark)mark, (BObject)this.cont, (BComponent)params, null).transfer();
        String[] a = r.getInsertNames();
        NmUtil.wait(500);
        return (BComplex)this.cont.get(a[0]);
    }

    private boolean importXmlFile(BDynamicDevice dev, BProgramId pId) {
        BOrd ord = null;
        DeviceDef def = new DeviceDef(pId);
        if (def.isXml()) {
            ord = def.getXmlOrd();
        }
        if (ord == null) {
            return false;
        }
        dev.setXmlFile(ord);
        return true;
    }

    private BLonDevice createDeviceForPid(DeviceDef def) {
        BOrd ord = null;
        if (def.isClass()) {
            return def.getDevice();
        }
        if (def.isXml()) {
            ord = def.getXmlOrd();
        }
        BDynamicDevice dev = new BDynamicDevice();
        if (ord != null) {
            dev.setXmlFile(ord);
        }
        return dev;
    }

    private void buildDevice(BDynamicDevice dev) {
        if (dev.getXmlFile() != BOrd.NULL) {
            try {
                dev.doImportXml(new BImportParameters(false, this.netMgmt.getUseLonObjects()));
                this.status("Import file for " + dev.getDisplayName(null));
                return;
            }
            catch (Throwable e) {
                this.warning(dev.getDisplayName(null) + " failed to import " + dev.getXmlFile().toString(), e);
            }
        }
        try {
            if (dev.getDeviceData().getNodeState() == BLonNodeState.applicationless) {
                return;
            }
            this.status("Import selfdoc for " + dev.getDisplayName(null));
            XLonDevice xdev = DocToXDevice.extract(dev.getNeuronIdAddress(), this.lonComm, this.auth);
            DynaDev.importXLon(dev, xdev, this.netMgmt.getUseLonObjects());
        }
        catch (Throwable e) {
            this.warning("Failed to learn nvs for " + dev.getDisplayName(null), e);
        }
    }

    private static int getDeviceHash(BLonDevice dev) {
        return BLonLearnJob.getDeviceHash(dev.getDeviceData());
    }

    private static int getDeviceHash(BDeviceData dd) {
        BSubnetNode sn = dd.getSubnetNodeId();
        return BLonLearnJob.getDeviceHash(sn.getSubnetId(), sn.getNodeId());
    }

    private static int getDeviceHash(int subnet, int node) {
        return (subnet << 7) + node;
    }

    private class LonDeviceIds {
        public QueryDomainResponse domain;
        public int wrkDmn;
        public boolean authOn;
        public BNeuronId nId;
        public BProgramId pId;
        public boolean twoDomains;
        public boolean duplicate;
        public int chanId;
        public BLonNodeState state;
        LonDeviceIds farIds;
        RouterStatusResponse rtrStatus = null;

        LonDeviceIds(BNeuronId nId, BProgramId pId, boolean authOn, BLonNodeState state) {
            this.nId = nId;
            this.pId = pId;
            this.authOn = authOn;
            this.state = state;
        }

        private int getSubnet() {
            return this.domain.getSubnet();
        }

        private int getNodeId() {
            return this.domain.getNodeId();
        }
    }
}

