/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.file;

import com.tridium.file.types.bog.BBogFile;
import com.tridium.file.types.bog.BBogSpace;
import com.tridium.template.BTemplateConfig;
import com.tridium.template.file.BNtplFile;
import com.tridium.template.file.PxFileRef;
import com.tridium.template.manifest.ManifestXMLWriter;
import com.tridium.template.manifest.TemplateManifest;
import com.tridium.util.PasswordUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.baja.file.BDataFile;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileSpace;
import javax.baja.file.BIFileStore;
import javax.baja.file.BMemoryFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.types.image.BImageFile;
import javax.baja.file.zip.BZipFileEntry;
import javax.baja.file.zip.BZipSpace;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.FileUtil;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUnrestrictedFolder;

public final class NtplUtil {
    public static final Logger log = Logger.getLogger("ntpl");
    public static final String COMPONENT_TEMPLATE_DIR = "templates";
    public static final String STATION_TEMPLATE_DIR = "stationTemplates";
    public static final String APPLICATION_TEMPLATE_DIR = "applicationTemplates";
    public static final String TEMPLATE_MANIFEST = "template-manifest.xml";

    private NtplUtil() {
    }

    public static BDirectory getTemplateDirectory() {
        try {
            return (BDirectory)NtplUtil.getTemplateDirectoryOrd().resolve().get();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BDirectory getApplicationDirectory() {
        try {
            return (BDirectory)NtplUtil.getApplicationDirectoryOrd().resolve().get();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BOrd getTemplateDirectoryOrd() throws Exception {
        return NtplUtil.getDirectoryOrd(COMPONENT_TEMPLATE_DIR);
    }

    public static BOrd getApplicationDirectoryOrd() throws Exception {
        return NtplUtil.getDirectoryOrd(APPLICATION_TEMPLATE_DIR);
    }

    private static BOrd getDirectoryOrd(String directory) throws Exception {
        BOrd directoryOrd = BOrd.make((String)("local:|file:~" + directory));
        try {
            directoryOrd.resolve();
        }
        catch (UnresolvedException e) {
            BDirectory userHome = BFileSystem.INSTANCE.getUserHome();
            userHome.getFileSpace().makeDir(userHome.getFilePath().merge(directory));
        }
        return directoryOrd;
    }

    public static void makeNtpl(String templateName, BComponent root, BTemplateConfig config, PxFileRef[] pxFiles, BImageFile image, BNtplFile ntplFile, boolean creatingNew) {
        try {
            boolean isStationOrApplicationTemplate = root.getChildComponents()[0].getType().is(BStation.TYPE);
            BImageFile[] pxImages = null;
            BNtplFile ntplFileHandle = null;
            FilePath outFilePath = null;
            if (ntplFile != null) {
                pxImages = ntplFile.getPxImageFiles();
                ntplFileHandle = ntplFile;
                outFilePath = ntplFile.getFilePath();
            }
            if (creatingNew) {
                outFilePath = NtplUtil.buildTemplateFilePath(templateName, isStationOrApplicationTemplate, config.getPropertyInParent().isFrozen());
                ntplFileHandle = BFileSystem.INSTANCE.makeFile(outFilePath);
            }
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(ntplFileHandle.getOutputStream());){
                BDataFile[] stationFiles;
                ZipEntry zipManifest = new ZipEntry(TEMPLATE_MANIFEST);
                zipManifest.setComment("Template Manifest");
                zipOutputStream.putNextEntry(zipManifest);
                TemplateManifest manifest = config.getManifest();
                ManifestXMLWriter manifestWriter = new ManifestXMLWriter(zipOutputStream);
                manifestWriter.encode(manifest);
                zipOutputStream.closeEntry();
                ZipEntry zipBog = new ZipEntry("template.bog");
                zipBog.setComment("BOG snippet");
                zipOutputStream.putNextEntry(zipBog);
                PasswordUtil.forceClearReversiblePasswords((BComponent)root);
                ValueDocEncoder encoder = new ValueDocEncoder((OutputStream)zipOutputStream);
                encoder.encodeDocument((BValue)root);
                zipOutputStream.closeEntry();
                HashMap<String, Object> filesToZip = new HashMap<String, Object>();
                for (PxFileRef pxFile1 : pxFiles) {
                    String memoryOrd = pxFile1.getPxFile().getAbsoluteOrd().encodeToString();
                    memoryOrd = memoryOrd.substring(memoryOrd.lastIndexOf(58) + 1);
                    filesToZip.putIfAbsent(memoryOrd, pxFile1.getPxFile());
                }
                if (isStationOrApplicationTemplate && ntplFile != null && (stationFiles = ntplFile.getStationFiles()) != null) {
                    BDataFile[] bDataFileArray = stationFiles;
                    int n = bDataFileArray.length;
                    for (int pxFile1 = 0; pxFile1 < n; ++pxFile1) {
                        BDataFile stationFile = bDataFileArray[pxFile1];
                        String relativePath = stationFile.getOrdInSpace().encodeToString();
                        relativePath = relativePath.substring(relativePath.indexOf(58) + 1);
                        filesToZip.putIfAbsent(relativePath, stationFile);
                    }
                }
                if (image != null) {
                    filesToZip.putIfAbsent("image.png", image);
                }
                if (pxImages != null && !isStationOrApplicationTemplate) {
                    for (BImageFile pxImage : pxImages) {
                        if (pxImage == null) continue;
                        filesToZip.putIfAbsent(pxImage.getFilePath().getBody(), pxImage);
                    }
                }
                for (Map.Entry entry : filesToZip.entrySet()) {
                    String zipPath = (String)entry.getKey();
                    BDataFile fileToZip = (BDataFile)entry.getValue();
                    ZipEntry zipEntry = new ZipEntry(zipPath);
                    zipEntry.setTime(fileToZip.getLastModified().getMillis());
                    zipOutputStream.putNextEntry(zipEntry);
                    try (InputStream inputStream = fileToZip.getInputStream();){
                        FileUtil.pipe((InputStream)inputStream, (OutputStream)zipOutputStream);
                    }
                    zipOutputStream.closeEntry();
                }
            }
            log.info("Niagara Template created: " + outFilePath.toString());
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Cannot create template:" + e.getLocalizedMessage(), e);
        }
    }

    public static String buildTemplateFileName(String templateName, boolean templateIsApplication) {
        return templateName + "." + (templateIsApplication ? "napl" : "ntpl");
    }

    public static FilePath buildTemplateFilePath(String templateName, boolean templateRootIsStation, boolean templateIsApplication) {
        StringBuilder filePath = new StringBuilder();
        filePath.append('~');
        if (!templateRootIsStation) {
            filePath.append(COMPONENT_TEMPLATE_DIR);
        } else if (templateIsApplication) {
            filePath.append(APPLICATION_TEMPLATE_DIR);
        } else {
            filePath.append(STATION_TEMPLATE_DIR);
        }
        filePath.append('/');
        filePath.append(NtplUtil.buildTemplateFileName(templateName, templateIsApplication));
        return new FilePath(filePath.toString());
    }

    public static void copyFile(BIFile fromFile, BIFile toFile) {
        try {
            InputStream in = fromFile.getInputStream();
            OutputStream out = toFile.getOutputStream();
            FileUtil.pipe((InputStream)in, (OutputStream)out);
            in.close();
            out.close();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Cannot copy file:" + e.getLocalizedMessage(), e);
        }
    }

    public static boolean isTemplate(BComponentSpace space) {
        boolean isTemplate = false;
        if (space instanceof BBogSpace) {
            boolean mightBeTemplate = false;
            BBogFile bogFile = ((BBogSpace)space).getBogFile();
            if (bogFile.getType() == BBogFile.TYPE) {
                BComponent[] children;
                BComponent root;
                BIFileStore fileStore = bogFile.getStore();
                if (fileStore instanceof BZipFileEntry) {
                    BIFile manifestFile;
                    BFileSpace zipSpace = fileStore.getFileSpace();
                    if (zipSpace instanceof BZipSpace && (manifestFile = zipSpace.findFile(new FilePath(TEMPLATE_MANIFEST))) != null) {
                        mightBeTemplate = true;
                    }
                } else if (fileStore instanceof BMemoryFileStore) {
                    mightBeTemplate = true;
                }
                if (mightBeTemplate && (root = space.getRootComponent()) instanceof BUnrestrictedFolder && (children = root.getChildComponents()) != null && (children.length == 1 || children.length == 2)) {
                    isTemplate = true;
                }
            }
        }
        return isTemplate;
    }

    public static void listAllEntries(BNtplFile ntplFile, List<BIFile> entryList) {
        NtplUtil.listEntries(ntplFile, entryList, true, true, null, null, true);
    }

    public static void listAllDirectories(BNtplFile ntplFile, List<BIFile> directoryList) {
        NtplUtil.listEntries(ntplFile, directoryList, true, false, null, null, true);
    }

    public static void listAllMatchingDirectories(BNtplFile ntplFile, List<BIFile> directoryList, String nameContains) {
        NtplUtil.listEntries(ntplFile, directoryList, true, false, null, f -> f.getFileName().contains(nameContains), true);
    }

    public static void listSubdirectories(BNtplFile ntplFile, List<BIFile> directoryList, String root) {
        NtplUtil.listEntries(ntplFile, directoryList, true, false, root, null, false);
    }

    public static void listMatchingSubdirectories(BNtplFile ntplFile, List<BIFile> directoryList, String root, String nameContains) {
        NtplUtil.listEntries(ntplFile, directoryList, true, false, root, f -> f.getFileName().contains(nameContains), false);
    }

    public static void listAllSubdirectories(BNtplFile ntplFile, List<BIFile> directoryList, String root) {
        NtplUtil.listEntries(ntplFile, directoryList, true, false, root, null, true);
    }

    public static void listAllMatchingSubdirectories(BNtplFile ntplFile, List<BIFile> directoryList, String root, String nameContains) {
        NtplUtil.listEntries(ntplFile, directoryList, true, false, root, f -> f.getFileName().contains(nameContains), true);
    }

    public static void listAllFiles(BNtplFile ntplFile, List<BIFile> fileList) {
        NtplUtil.listEntries(ntplFile, fileList, false, true, null, null, true);
    }

    public static void listAllMatchingFiles(BNtplFile ntplFile, List<BIFile> fileList, String nameContains) {
        NtplUtil.listEntries(ntplFile, fileList, false, true, null, f -> f.getFileName().contains(nameContains), true);
    }

    public static void listFilesInDirectory(BNtplFile ntplFile, List<BIFile> fileList, String directory) {
        NtplUtil.listEntries(ntplFile, fileList, false, true, directory, null, false);
    }

    public static void listAllFilesInDirectory(BNtplFile ntplFile, List<BIFile> fileList, String directory) {
        NtplUtil.listEntries(ntplFile, fileList, false, true, directory, null, true);
    }

    public static void listMatchingFilesInDirectory(BNtplFile ntplFile, List<BIFile> fileList, String directory, String nameContains) {
        NtplUtil.listEntries(ntplFile, fileList, false, true, directory, f -> f.getFileName().contains(nameContains), false);
    }

    public static void listAllMatchingFilesInDirectory(BNtplFile ntplFile, List<BIFile> fileList, String directory, String nameContains) {
        NtplUtil.listEntries(ntplFile, fileList, false, true, directory, f -> f.getFileName().contains(nameContains), true);
    }

    public static void listAllFilesOfTypeInDirectory(BNtplFile ntplFile, List<BIFile> fileList, String directory, String fileTypeExtension) {
        NtplUtil.listEntries(ntplFile, fileList, false, true, directory, f -> f.getFileName().endsWith("." + fileTypeExtension), true);
    }

    public static void listAllFilesOfTypeInDirectory(BNtplFile ntplFile, List<BIFile> fileList, String directory, Type fileType) {
        NtplUtil.listEntries(ntplFile, fileList, false, true, directory, f -> Sys.getRegistry().getFileTypeForExtension(f.getExtension()).is(fileType), true);
    }

    private static void listEntries(BNtplFile ntplFile, List<BIFile> fileList, boolean includeDirectories, boolean includeFiles, String rootDirectory, Predicate<BIFile> fileFilter, boolean recursive) {
        BSpace space;
        if (fileList == null) {
            fileList = new ArrayList<BIFile>();
        }
        if ((space = ntplFile.doOpen()) != null) {
            BIFile[] entries;
            if (rootDirectory != null) {
                BIFile root;
                if (!rootDirectory.startsWith("/")) {
                    rootDirectory = '/' + rootDirectory;
                }
                if (!((root = ((BIFileSpace)space).findFile(new FilePath(rootDirectory))) instanceof BIDirectory)) {
                    return;
                }
                entries = ((BIDirectory)root).listFiles();
            } else {
                entries = ((BIDirectory)space).listFiles();
            }
            if (recursive) {
                NtplUtil.listEntries(entries, fileList, includeDirectories, includeFiles, fileFilter, recursive);
            }
        }
    }

    private static void listEntries(BIFile[] entries, List<BIFile> fileList, boolean includeDirectories, boolean includeFiles, Predicate<BIFile> fileFilter, boolean recursive) {
        for (BIFile entry : entries) {
            boolean isDirectory = entry.isDirectory();
            if (includeDirectories && isDirectory || !isDirectory && includeFiles && (fileFilter == null || fileFilter.test(entry))) {
                fileList.add(entry);
            }
            if (!isDirectory || !recursive) continue;
            NtplUtil.listEntries(((BIDirectory)entry).listFiles(), fileList, includeDirectories, includeFiles, fileFilter, recursive);
        }
    }
}

