/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.file;

import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.install.part.BModulePart;
import com.tridium.neql.component.ComponentTreeIterator;
import com.tridium.sys.Nre;
import com.tridium.sys.module.NModule;
import com.tridium.template.file.NtplUtil;
import com.tridium.template.file.PxFileRef;
import com.tridium.util.ObjectUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.function.Consumer;
import java.util.logging.Level;
import javax.baja.file.types.text.BPxFile;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.platform.install.BVersionRelation;
import javax.baja.registry.ModuleInfo;
import javax.baja.registry.Registry;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.tag.Entity;
import javax.baja.util.Version;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class DependencyUtil {
    public static Hashtable<String, BDependency> getTemplatePxDependencies(PxFileRef[] pxFileRefs, Hashtable<String, BDependency> pxDependencies, boolean useMinor) {
        for (PxFileRef pxFileRef : pxFileRefs) {
            DependencyUtil.getPxFileDependencies(pxFileRef.getPxFile(), pxDependencies, useMinor);
        }
        return pxDependencies;
    }

    public static void getPxFileDependencies(BPxFile pxFile, Hashtable<String, BDependency> pxDependencies, boolean useMinor) {
        HashSet<String> modules = new HashSet<String>();
        Registry registry = Sys.getRegistry();
        try {
            try (Object in = pxFile.getInputStream();){
                XParser xParser = XParser.make((InputStream)in);
                XElem root = xParser.parse();
                XElem elem = root.elem("import");
                if (elem != null) {
                    XElem[] moduleElems;
                    for (XElem moduleElem : moduleElems = elem.elems("module")) {
                        modules.add(moduleElem.get("name"));
                    }
                }
                xParser.close();
            }
            in = pxFile.getInputStream();
            var6_7 = null;
            try {
                ModuleInfo[] line = DependencyUtil.readLine((InputStream)in);
                while (line != null) {
                    int mIndex = line.indexOf("module://") + 9;
                    if (mIndex > 9) {
                        int mEnd = line.indexOf(47, mIndex);
                        String moduleName = line.substring(mIndex, mEnd);
                        modules.add(moduleName);
                    }
                    line = DependencyUtil.readLine((InputStream)in);
                }
            }
            catch (Throwable line) {
                var6_7 = line;
                throw line;
            }
            finally {
                if (in != null) {
                    if (var6_7 != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable line) {
                            var6_7.addSuppressed(line);
                        }
                    } else {
                        ((InputStream)in).close();
                    }
                }
            }
            for (String module : modules) {
                try {
                    for (ModuleInfo moduleInfo : registry.getModules(module)) {
                        if (moduleInfo.getRuntimeProfile() == RuntimeProfile.doc || moduleInfo.getRuntimeProfile() == RuntimeProfile.se) continue;
                        String vendor = moduleInfo.getVendor();
                        Version vendorVersion = moduleInfo.getVendorVersion();
                        String dependencyVersion = useMinor ? vendorVersion.toMinorVersion().toString() : vendorVersion.toString();
                        String modulePartName = moduleInfo.getModulePartName();
                        BDependency dependency = BDependency.forModule((String)moduleInfo.getModulePartName());
                        BVersion v = new BVersion(vendor, dependencyVersion);
                        dependency.setVersion(v);
                        if (pxDependencies.contains(modulePartName)) continue;
                        pxDependencies.put(modulePartName, dependency);
                    }
                }
                catch (Exception e) {
                    NtplUtil.log.log(Level.WARNING, "Missing module: " + module, e);
                }
            }
        }
        catch (Exception e) {
            NtplUtil.log.log(Level.WARNING, "Error resolving PX file dependencies:" + e.getLocalizedMessage(), e);
        }
    }

    private static String readLine(InputStream in) {
        StringBuffer sb = new StringBuffer();
        try {
            int value = in.read();
            while (value >= 0 && value != 13 && value != 10) {
                sb.append((char)(value & 0xFF));
                value = in.read();
            }
            if (sb.length() == 0 && value < 0) {
                return null;
            }
            return sb.toString();
        }
        catch (IOException e) {
            NtplUtil.log.log(Level.WARNING, "Error reading input stream:" + e.getLocalizedMessage(), e);
            return sb.toString();
        }
    }

    public static void getBogComponentDependencies(BComponent templateRoot, Hashtable<String, BDependency> dependencies, boolean useMinor) {
        HashSet<NModule> moduleSet = new HashSet<NModule>();
        NModule niagaraModule = Nre.getModuleManager().getModuleForClass(templateRoot.getClass());
        moduleSet.add(niagaraModule);
        DependencyUtil.getFacetModuleDependenciesForComponent(templateRoot, dependencies, useMinor);
        ComponentTreeIterator iterator = new ComponentTreeIterator(templateRoot);
        while (iterator.hasNext()) {
            Entity entity = iterator.next();
            if (!(entity instanceof BComponent)) continue;
            BComponent templateComponent = (BComponent)entity;
            niagaraModule = Nre.getModuleManager().getModuleForClass(templateComponent.getClass());
            moduleSet.add(niagaraModule);
            DependencyUtil.getFacetModuleDependenciesForComponent(templateComponent, dependencies, useMinor);
        }
        moduleSet.forEach(module -> {
            Version version = module.getVendorVersion();
            String dependencyVersion = useMinor ? version.toMinorVersion().toString() : version.toString();
            dependencies.put(module.getModulePartName(), new BDependency(module.getModulePartName(), new BVersion(module.getVendor(), dependencyVersion), BVersionRelation.minimum, BModulePart.TYPE.getTypeSpec(), "*"));
        });
    }

    private static void getFacetModuleDependenciesForComponent(BComponent component, Hashtable<String, BDependency> dependencies, boolean useMinor) {
        Property myProperty = component.getPropertyInParent();
        if (myProperty != null) {
            BFacets facetsValue = component.getParent().getSlotFacets((Slot)myProperty);
            ObjectUtil.getModuleDependenciesFromFacets((BFacets)facetsValue).forEach(new ModuleAddConsumer(dependencies, useMinor));
        }
        SlotCursor propertySlotCursor = component.getProperties();
        while (propertySlotCursor.next(BFacets.class)) {
            BFacets facetsValue = (BFacets)propertySlotCursor.get();
            ObjectUtil.getModuleDependenciesFromFacets((BFacets)facetsValue).forEach(new ModuleAddConsumer(dependencies, useMinor));
        }
    }

    private static class ModuleAddConsumer
    implements Consumer<String> {
        private final Hashtable<String, BDependency> dependencies;
        private final boolean useMinor;

        ModuleAddConsumer(Hashtable<String, BDependency> dependencies, boolean useMinor) {
            this.dependencies = dependencies;
            this.useMinor = useMinor;
        }

        @Override
        public void accept(String moduleOrPartName) {
            String moduleName = moduleOrPartName;
            RuntimeProfile profile = null;
            int dashIndex = moduleOrPartName.lastIndexOf(45);
            if (dashIndex > 0 && (profile = RuntimeProfile.valueOf((String)moduleOrPartName.substring(dashIndex + 1), null)) != null) {
                moduleName = moduleOrPartName.substring(0, dashIndex);
            }
            ModuleInfo[] moduleInfos = null;
            moduleInfos = profile == null ? Sys.getRegistry().getModules(moduleName) : new ModuleInfo[]{Sys.getRegistry().getModule(moduleName, profile)};
            if (moduleInfos != null) {
                for (ModuleInfo moduleInfo : moduleInfos) {
                    String partName = moduleInfo.getModulePartName();
                    if (this.dependencies.contains(partName)) continue;
                    Version vendorVersion = this.useMinor ? moduleInfo.getVendorVersion().toMinorVersion() : moduleInfo.getVendorVersion();
                    BVersion v = new BVersion(moduleInfo.getVendor(), vendorVersion.toString());
                    this.dependencies.put(partName, new BDependency(partName, v, BModulePart.TYPE.getTypeSpec()));
                }
            }
        }
    }
}

