/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.application;

import com.tridium.install.BVersion;
import com.tridium.template.BConfigBinding;
import com.tridium.template.BTemplateConfig;
import com.tridium.template.application.NameTree;
import com.tridium.template.file.BINtplFile;
import com.tridium.template.file.BNtplFile;
import com.tridium.template.file.TemplateFileUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.fox.BFoxProxySession;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.user.BUser;
import javax.baja.util.BUuid;

public final class ApplicationTemplateUtil {
    private static String MY_USER_MACRO_NAME = "myuser";
    private static String MY_USER_MACRO_KEY = NameTree.MACRO_PREFIX + MY_USER_MACRO_NAME;
    private static NameTree defaultStationDesc;
    private static NameTree contextFreeDefaultStationDesc;

    private ApplicationTemplateUtil() {
    }

    public static BComponent[] findApplicationRoots(BStation station) {
        return ApplicationTemplateUtil.findApplicationRoots(station, ApplicationTemplateUtil.describeDefaultStation(null));
    }

    public static BComponent[] findApplicationRoots(BStation station, NameTree keepers) {
        ArrayList<BComponent> applicationRoots = new ArrayList<BComponent>();
        ApplicationTemplateUtil.gatherApplicationRootsForBranch((BComponent)station, keepers, applicationRoots);
        return applicationRoots.toArray(new BComponent[0]);
    }

    public static BComponent[] findComponents(BComponent root, NameTree toBeFound) {
        ArrayList<BComponent> components = new ArrayList<BComponent>();
        ApplicationTemplateUtil.gatherComponents(root, toBeFound, components);
        return components.toArray(new BComponent[0]);
    }

    public static void deleteComponents(BComponent parent, NameTree toBeDeleted) {
        ArrayList<BComponent> componentsToBeDeleted = new ArrayList<BComponent>();
        ApplicationTemplateUtil.gatherComponents(parent, toBeDeleted, componentsToBeDeleted);
        for (BComponent component : componentsToBeDeleted) {
            component.getParent().asComponent().remove((BComplex)component);
        }
    }

    public static NameTree describeDefaultStation(Context context) {
        if (defaultStationDesc == null) {
            defaultStationDesc = new NameTree();
            NameTree services = defaultStationDesc.get("Services");
            services.get("UserService").add(MY_USER_MACRO_KEY);
            services.add("AuthenticationService");
            services.add("DebugService");
            services.add("FoxService");
            services.add("TemplateService");
            services.add("PlatformServices");
            services.add("HistoryService");
            services.add("JobService");
            services.add("WebService");
        }
        if (context == null || context.getUser() == null || context.getUser().getName() == null) {
            if (contextFreeDefaultStationDesc == null) {
                contextFreeDefaultStationDesc = new NameTree(defaultStationDesc);
                contextFreeDefaultStationDesc.removeMacro(MY_USER_MACRO_NAME);
            }
            return contextFreeDefaultStationDesc;
        }
        String userName = context.getUser().getName();
        NameTree userDefaultStationDesc = new NameTree(defaultStationDesc);
        userDefaultStationDesc.replaceMacro(MY_USER_MACRO_NAME, userName);
        return userDefaultStationDesc;
    }

    public static NameTree makeNameTree(BOrdList slotPathOrds) {
        NameTree tree = new NameTree();
        for (BOrd ord : slotPathOrds) {
            SlotPath path;
            String[] names;
            OrdQuery last;
            OrdQuery[] queries;
            if (ord.isNull() || (queries = ord.parse()).length == 0 || !((last = queries[queries.length - 1]) instanceof SlotPath) || (names = (path = (SlotPath)last).getNames()).length == 0) continue;
            NameTree subTree = tree;
            int i = 0;
            while (i < names.length - 1) {
                subTree = subTree.get(names[i++]);
            }
            subTree.add(names[i]);
        }
        return tree;
    }

    public static void purgeBrokenConfigProperties(BTemplateConfig templateConfig, Set<Object> allHandles) {
        if (templateConfig == null) {
            return;
        }
        for (BConfigBinding configBinding : templateConfig.getConfigBindings()) {
            OrdQuery query;
            BOrd targetOrd = configBinding.getTargetOrd();
            OrdQuery[] queries = targetOrd.parse();
            if (queries.length > 0 && "h".equals((query = queries[queries.length - 1]).getScheme()) && allHandles.contains(query.getBody())) continue;
            String sourceSlot = configBinding.getSourceSlot();
            templateConfig.remove(configBinding.getPropertyInParent());
            templateConfig.remove(sourceSlot);
        }
    }

    private static void gatherApplicationRootsForBranch(BComponent subject, NameTree keepersBranch, ArrayList<BComponent> roots) {
        SlotCursor cursor = subject.getProperties();
        while (cursor.nextComponent()) {
            BComponent component = cursor.get().asComponent();
            String checkName = component.getName();
            if (keepersBranch.hasBranch(checkName)) {
                ApplicationTemplateUtil.gatherApplicationRootsForBranch(component, keepersBranch.fetch(checkName), roots);
                continue;
            }
            if (!component.getPropertyInParent().isDynamic() || keepersBranch.hasLeaf(checkName)) continue;
            roots.add(component);
        }
    }

    private static void gatherComponents(BComponent subject, NameTree branchToBeFound, ArrayList<BComponent> components) {
        SlotCursor cursor = subject.getProperties();
        while (cursor.nextComponent()) {
            BComponent component = cursor.get().asComponent();
            String checkName = component.getName();
            if (branchToBeFound.hasBranch(checkName)) {
                ApplicationTemplateUtil.gatherComponents(component, branchToBeFound.fetch(checkName), components);
                continue;
            }
            if (!component.getPropertyInParent().isDynamic() || !branchToBeFound.hasLeaf(checkName)) continue;
            components.add(component);
        }
    }

    public static boolean isSuperUser(Context cx) {
        BUser user;
        if (cx != null && (user = cx.getUser()) != null) {
            return user.getPermissions().isSuperUser();
        }
        return true;
    }

    public static BIFile copyApplicationTemplateToStation(BNtplFile sourceTemplateFile, BStation station) throws Exception {
        String sourceFileName = sourceTemplateFile.getFileName();
        ArrayList<BNtplFile.FileTransferSpec> fileTransferSpecs = new ArrayList<BNtplFile.FileTransferSpec>();
        FilePath stationFilePath = sourceTemplateFile.listFilesToBeTransferred((BComponent)station, fileTransferSpecs);
        BFileSpace stationSharedFileSpace = ((BIFile)BOrd.make((String)"file:^").get((BObject)station)).getFileSpace();
        for (BNtplFile.FileTransferSpec fileTransferSpec : fileTransferSpecs) {
            FilePath path = fileTransferSpec.getTargetPath().merge(fileTransferSpec.getNewFileName());
            try {
                BIFile file = stationSharedFileSpace.makeFile(path);
                BajaFileUtil.pipe((BIFile)fileTransferSpec.getFileToTransfer(), (BIFile)file);
            }
            catch (IOException error) {
                try {
                    stationSharedFileSpace.delete(path);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw error;
            }
        }
        return stationSharedFileSpace.makeFile(stationFilePath);
    }

    public static BNtplFile getApplicationUpgrade(BStation station) {
        BUuid applicationId = ApplicationTemplateUtil.getStationApplicationId(station);
        if (!applicationId.isNull()) {
            BVersion applicationVersion = ApplicationTemplateUtil.getStationApplicationVersion(station);
            return ApplicationTemplateUtil.getApplicationUpgrade(applicationId, applicationVersion);
        }
        return null;
    }

    public static BNtplFile getApplicationUpgrade(BUuid applicationId, BVersion applicationVersion) {
        List<BINtplFile> matchingTemplates = TemplateFileUtil.getApplicationTemplatesByUuid(applicationId);
        for (BINtplFile file : matchingTemplates) {
            BVersion templateVersion = new BVersion(file.getVersion());
            if (applicationVersion.compareTo((Object)templateVersion) >= 0) continue;
            return (BNtplFile)file;
        }
        return null;
    }

    public static BUuid getStationApplicationId(BStation station) {
        BUuid applicationId = BUuid.DEFAULT;
        BISession session = station.getSession();
        if (session instanceof BFoxProxySession) {
            Optional result = Optional.empty();
            try {
                result = ((BFoxProxySession)session).rpc(BOrd.make((String)"type:template:ApplicationService"), "getApplicationId", new Object[0]);
                if (result.isPresent()) {
                    applicationId = BUuid.make((String)((String)result.get()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return applicationId;
    }

    public static BVersion getStationApplicationVersion(BStation station) {
        BVersion applicationVersion = BVersion.makeZero();
        BISession session = station.getSession();
        if (session instanceof BFoxProxySession) {
            Optional result = Optional.empty();
            try {
                result = ((BFoxProxySession)session).rpc(BOrd.make((String)"type:template:ApplicationService"), "getApplicationVersion", new Object[0]);
                if (result.isPresent()) {
                    applicationVersion = new BVersion((String)result.get());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return applicationVersion;
    }
}

