/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.api.impl;

import com.tridium.template.api.TemplateValueSource;
import com.tridium.template.api.TemplateValueType;
import com.tridium.template.api.impl.TemplateSource;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.IntStream;
import javax.baja.security.BPassword;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BSimple;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;

public abstract class TemplateSourceWithValue
extends TemplateSource {
    protected abstract BValue getPropertyValue(int var1);

    protected abstract TemplateValueSource getValueSource();

    @Override
    public IntStream getElementKeyStream(int propertyKey) {
        return IntStream.range(0, this.getElementCountForProperty(propertyKey));
    }

    @Override
    public String getElementName(int propertyKey, int elementKey) {
        BValue propertyValue = this.getPropertyValue(propertyKey);
        if (propertyValue instanceof BStruct && !(propertyValue instanceof BStatusValue)) {
            return ((BStruct)propertyValue).getPropertiesArray()[elementKey].getName();
        }
        return null;
    }

    @Override
    public boolean hasLocalValue(int propertyKey) {
        return this.getValueSource() == TemplateValueSource.LOCAL_VALUE;
    }

    @Override
    public TemplateValueType getValueType(int propertyKey, int elementKey, TemplateValueSource valueSource) {
        if (this.clarifyValueSource(valueSource) != this.getValueSource()) {
            return TemplateValueType.MISSING;
        }
        BValue elementValue = this.getPropertyElementValue(propertyKey, elementKey);
        if (elementValue instanceof BInteger || elementValue instanceof BLong) {
            return TemplateValueType.INTEGER;
        }
        if (elementValue instanceof BNumber) {
            return TemplateValueType.NUMERIC;
        }
        if (elementValue instanceof BBoolean) {
            return TemplateValueType.BOOLEAN;
        }
        if (elementValue instanceof BEnum) {
            return TemplateValueType.ENUM;
        }
        if (elementValue instanceof BPassword) {
            return TemplateValueType.PASSWORD;
        }
        return TemplateValueType.STRING;
    }

    @Override
    public String getValueNType(int propertyKey, int elementKey, TemplateValueSource valueSource) {
        BValue propertyValue;
        BValue elementValue = propertyValue = this.getPropertyValue(propertyKey);
        if (TemplateSourceWithValue.getElementCountForPropertyValue(propertyValue) > 1) {
            elementValue = TemplateSourceWithValue.getPropertyElementValue(propertyValue, elementKey);
        }
        return elementValue.getType().toString();
    }

    @Override
    public double getNumericValue(int propertyKey, int elementKey, TemplateValueSource valueSource) {
        this.checkValueSource(valueSource);
        BValue elementValue = this.getPropertyElementValue(propertyKey, elementKey);
        if (elementValue instanceof BNumber) {
            return ((BNumber)elementValue).getDouble();
        }
        return 0.0;
    }

    @Override
    public long getIntegerValue(int propertyKey, int elementKey, TemplateValueSource valueSource) {
        this.checkValueSource(valueSource);
        BValue elementValue = this.getPropertyElementValue(propertyKey, elementKey);
        if (elementValue instanceof BNumber) {
            return ((BNumber)elementValue).getInt();
        }
        if (elementValue instanceof BEnum) {
            return ((BEnum)elementValue).getOrdinal();
        }
        return 0L;
    }

    @Override
    public boolean getBooleanValue(int propertyKey, int elementKey, TemplateValueSource valueSource) {
        this.checkValueSource(valueSource);
        BValue elementValue = this.getPropertyElementValue(propertyKey, elementKey);
        if (elementValue instanceof BBoolean) {
            return ((BBoolean)elementValue).getBoolean();
        }
        return false;
    }

    @Override
    public String getStringValue(int propertyKey, int elementKey, TemplateValueSource valueSource) {
        this.checkValueSource(valueSource);
        String result = null;
        BValue elementValue = this.getPropertyElementValue(propertyKey, elementKey);
        if (elementValue instanceof BEnum) {
            result = ((BEnum)elementValue).getTag();
        } else {
            if (elementValue instanceof BPassword) {
                return null;
            }
            if (elementValue instanceof BSimple) {
                try {
                    result = ((BSimple)elementValue).encodeToString();
                }
                catch (IOException iOException) {}
            } else {
                result = elementValue.toString();
            }
        }
        return result;
    }

    @Override
    public Map<Integer, String> getDefinedEnumValues(int propertyKey, int elementKey, TemplateValueSource valueSource) {
        this.checkValueSource(valueSource);
        BValue elementValue = this.getPropertyElementValue(propertyKey, elementKey);
        if (elementValue instanceof BEnum) {
            BEnum enumValue = (BEnum)elementValue;
            BEnumRange enumRange = enumValue.getRange();
            if (enumRange.isNull()) {
                return Collections.emptyMap();
            }
            TreeMap<Integer, String> values = new TreeMap<Integer, String>();
            for (int ordinal : enumRange.getOrdinals()) {
                values.put(ordinal, enumRange.getTag(ordinal));
            }
            return Collections.unmodifiableMap(values);
        }
        return Collections.emptyMap();
    }

    private BValue getPropertyElementValue(int propertyKey, int elementKey) {
        return TemplateSourceWithValue.getPropertyElementValue(this.getPropertyValue(propertyKey), elementKey);
    }

    private int getElementCountForProperty(int propertyKey) {
        return TemplateSourceWithValue.getElementCountForPropertyValue(this.getPropertyValue(propertyKey));
    }

    TemplateValueSource clarifyValueSource(TemplateValueSource valueSource) {
        return valueSource == TemplateValueSource.PRESENT_VALUE ? this.getValueSource() : valueSource;
    }

    private void checkValueSource(TemplateValueSource valueSource) {
        if (this.clarifyValueSource(valueSource) != this.getValueSource()) {
            throw new IllegalStateException("missing " + valueSource.toString());
        }
    }

    private static BValue getPropertyElementValue(BValue propertyValue, int elementKey) {
        if (propertyValue instanceof BStatusValue) {
            return ((BStatusValue)propertyValue).getValueValue();
        }
        if (propertyValue instanceof BStruct) {
            BStruct structValue = (BStruct)propertyValue;
            return structValue.get(structValue.getPropertiesArray()[elementKey]);
        }
        return propertyValue;
    }

    private static int getElementCountForPropertyValue(BValue propertyValue) {
        if (propertyValue instanceof BStruct && !(propertyValue instanceof BStatusValue)) {
            return ((BStruct)propertyValue).getPropertyCount();
        }
        return 1;
    }
}

