/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.api.impl;

import com.tridium.template.api.TemplateScope;
import com.tridium.template.api.impl.NewTemplateSource;
import com.tridium.template.manifest.TemplateFileSpec;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.baja.file.BDataFile;
import javax.baja.file.BDirectory;
import javax.baja.file.BIDirectory;
import javax.baja.file.types.log.BILogFile;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;

abstract class NewStationWideTemplateSource
extends NewTemplateSource {
    private static BComponent transferStrategyParams = null;
    private static final String TEMPLATE_SHARED_PATH = "shared";
    private static final String TEMPLATE_ACE_PATH = "ace";

    NewStationWideTemplateSource() {
    }

    @Override
    public TemplateScope getTemplateScope() {
        return TemplateScope.STATION_WIDE;
    }

    @Override
    protected BComponent getTransferStrategyParams() {
        if (transferStrategyParams == null) {
            transferStrategyParams = new BComponent();
            transferStrategyParams.add("exactConfig", (BValue)BBoolean.TRUE);
        }
        return transferStrategyParams;
    }

    @Override
    protected SortedSet<TemplateFileSpec> getFilesToStore() {
        BINavNode ace;
        BIDirectory sourceProtectedHomeDir;
        SortedSet<TemplateFileSpec> files = super.getFilesToStore();
        boolean createdFilesHere = false;
        BIDirectory sourceHomeDir = this.getSourceHomeDir();
        if (sourceHomeDir != null) {
            files = new TreeSet<TemplateFileSpec>(files);
            createdFilesHere = true;
            this.addStationFiles(files, this.getSourceHomeDir(), "shared/", "file:^");
        }
        if ((sourceProtectedHomeDir = this.getSourceProtectedHomeDir()) != null && (ace = sourceProtectedHomeDir.getNavChild(TEMPLATE_ACE_PATH)) instanceof BIDirectory) {
            if (!createdFilesHere) {
                files = new TreeSet<TemplateFileSpec>(files);
            }
            this.addStationFiles(files, (BIDirectory)ace, "ace/", "file:^^ace/");
        }
        return files;
    }

    protected boolean canStoreFile(BDataFile file) {
        if (file instanceof BILogFile) {
            return false;
        }
        return !file.getFileName().endsWith(".ntpl") || !((BDirectory)file.getNavParent()).getFileName().equals("stationTemplates");
    }

    private void addStationFiles(SortedSet<TemplateFileSpec> files, BIDirectory directoryToAdd, String baseName, String baseOrd) {
        this.addStationFiles(files, directoryToAdd, baseName, baseOrd, 15);
    }

    private void addStationFiles(SortedSet<TemplateFileSpec> files, BIDirectory directoryToAdd, String baseName, String baseOrd, int depth) {
        for (BINavNode child : directoryToAdd.getNavChildren()) {
            String name = child.getNavName();
            if (name == null || name.isEmpty()) continue;
            if (child instanceof BIDirectory && depth > 0) {
                this.addStationFiles(files, (BIDirectory)child, baseName + name + "/", baseOrd + name + "/", depth - 1);
                continue;
            }
            if (!(child instanceof BDataFile) || !this.canStoreFile((BDataFile)child)) continue;
            files.add(new TemplateFileSpec(baseName + name, "data", baseOrd + name, (BDataFile)child));
        }
    }
}

