/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.api.impl;

import com.tridium.template.BApplicationService;
import com.tridium.template.BTemplateConfig;
import com.tridium.template.api.TemplateType;
import com.tridium.template.api.impl.DeployedTemplateSource;
import java.util.Objects;
import javax.baja.sys.BComponent;
import javax.baja.sys.BStation;
import javax.baja.util.BServiceContainer;

public class InstalledApplicationTemplateSource
extends DeployedTemplateSource {
    static InstalledApplicationTemplateSource make(BStation station) {
        Objects.requireNonNull(station);
        InstalledApplicationTemplateSource result = null;
        station.lease();
        BServiceContainer services = station.getServices();
        services.lease();
        BApplicationService[] applicationServices = (BApplicationService[])services.getChildren(BApplicationService.class);
        if (applicationServices != null && applicationServices.length > 0 && applicationServices[0] != null) {
            BApplicationService applicationService = applicationServices[0];
            applicationService.lease();
            BTemplateConfig config = applicationService.getConfiguration();
            if (config != null) {
                result = new InstalledApplicationTemplateSource(station, config);
            }
        }
        return result;
    }

    private InstalledApplicationTemplateSource(BStation station, BTemplateConfig config) {
        super((BComponent)station, config);
    }

    @Override
    public TemplateType getTemplateType() {
        return TemplateType.APPLICATION;
    }

    @Override
    protected String getFileExtension() {
        return "napl";
    }
}

