/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.api.impl;

import com.tridium.template.BTemplateConfig;
import com.tridium.template.UpgradeUtil;
import com.tridium.template.api.TemplateSourceType;
import com.tridium.template.api.TemplateValueSource;
import com.tridium.template.api.impl.CombinedTemplateSource;
import com.tridium.template.api.impl.FileTemplateSource;
import com.tridium.template.api.impl.InstalledApplicationTemplateSource;
import com.tridium.template.api.impl.TemplateSource;
import com.tridium.template.api.impl.TemplateSourceWithConfig;
import com.tridium.template.api.impl.TemplateSourceWithValue;
import com.tridium.template.file.BNtplFile;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.nre.util.FileUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BStation;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;

public class DeployedTemplateSource
extends TemplateSourceWithConfig {
    Subscriber subscriber = new Subscriber(){

        public void event(BComponentEvent event) {
        }
    };
    private static final String STATION_TEMP_DIR = "^temp/";
    private static final String WB_TEMP_DIR = "~temp/";
    private BComponent root;
    private BTemplateConfig config;

    public static TemplateSource open(BComponent deployedTemplate) {
        TemplateSourceWithValue fileSource;
        InstalledApplicationTemplateSource templateSource = null;
        if (deployedTemplate instanceof BStation) {
            templateSource = InstalledApplicationTemplateSource.make((BStation)deployedTemplate);
        }
        TemplateSourceWithValue templateSourceWithValue = fileSource = templateSource == null ? null : super.loadFileSource();
        return templateSource == null ? null : (fileSource == null ? templateSource : new CombinedTemplateSource(templateSource, fileSource));
    }

    public DeployedTemplateSource(BComponent root, BTemplateConfig config) {
        this.root = root;
        this.subscriber.subscribe(root);
        this.config = config;
        this.subscriber.subscribe((BComponent)config);
    }

    @Override
    protected TemplateValueSource getValueSource() {
        return TemplateValueSource.LOCAL_VALUE;
    }

    @Override
    protected BTemplateConfig getConfig() {
        return this.config;
    }

    @Override
    protected BComponent getBase() {
        return this.root;
    }

    @Override
    public TemplateSourceType getSourceType() {
        return TemplateSourceType.DEPLOYED;
    }

    private TemplateSourceWithValue loadFileSource() {
        FileTemplateSource fileSource = null;
        try {
            BNtplFile tempFile = (BNtplFile)UpgradeUtil.getDeployedNtplFile(this.config, "^applicationTemplate/", "napl");
            FilePath temporaryFilePath = Sys.isStation() ? new FilePath(STATION_TEMP_DIR + tempFile.getFileName()) : new FilePath(WB_TEMP_DIR + tempFile.getFileName());
            BNtplFile templateFile = (BNtplFile)BFileSystem.INSTANCE.makeFile(temporaryFilePath);
            try (InputStream in = tempFile.getInputStream();
                 OutputStream out = templateFile.getOutputStream();){
                FileUtil.pipe((InputStream)in, (OutputStream)out);
            }
            fileSource = FileTemplateSource.load(templateFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fileSource;
    }

    @Override
    public void close() {
        this.subscriber.unsubscribeAll();
        this.subscriber = null;
        this.config = null;
        this.root = null;
        super.close();
    }
}

