/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template;

import com.tridium.platform.BPlatformService;
import com.tridium.sys.engine.LocalKnob;
import com.tridium.sys.engine.LocalRelationKnob;
import com.tridium.sys.tag.ComponentTags;
import com.tridium.sys.transfer.DeployToComp;
import com.tridium.template.BPasswordBinding;
import com.tridium.template.BRelationInfo;
import com.tridium.template.BTemplateConfig;
import com.tridium.template.BTemplateService;
import com.tridium.template.TemplateConst;
import com.tridium.template.application.ProgressTracker;
import com.tridium.template.file.BINtplFile;
import com.tridium.template.manifest.TemplateManifest;
import com.tridium.util.CompUtil;
import com.tridium.util.LinkUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import javax.baja.agent.BPxView;
import javax.baja.file.BIDeployable;
import javax.baja.file.FilePath;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.security.BPassword;
import javax.baja.space.Mark;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.RelationKnob;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.Tag;
import javax.baja.tag.TagGroupInfo;
import javax.baja.tag.TagInfo;
import javax.baja.util.BFormat;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.Lexicon;

public class UpgradeUtil
implements TemplateConst {
    public static Lexicon lex = Lexicon.make((String)"template");
    private static Type[] EXCLUDE_TYPES = new Type[]{BRelation.TYPE, BHistoryConfig.TYPE, BPlatformService.TYPE};
    private static TypeProperties[] SAVE_TYPE_PROPERTIES = new TypeProperties[]{new TypeProperties(BHistoryExt.TYPE, new String[]{BHistoryExt.historyName.getName(), BHistoryExt.enabled.getName()})};
    private static Level LOG_LEVEL = Level.FINE;
    private static final Logger LOG = Logger.getLogger("template");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void upgradeTemplates(List<BTemplateConfig> configs, List<Boolean> redeployValues, ProgressTracker progress) {
        HashSet<RelationSpec> relationSpecs = new HashSet<RelationSpec>();
        BComponent base = null;
        progress.constrain(80);
        progress.divide(configs.size());
        try {
            for (int i = 0; i < configs.size(); ++i) {
                BTemplateConfig config = configs.get(i);
                boolean isRedeploy = i < redeployValues.size() ? redeployValues.get(i) : true;
                try {
                    BComponent upgradedRoot = UpgradeUtil.upgradeTemplates(config, isRedeploy, progress, relationSpecs);
                    base = base != null || upgradedRoot == null ? base : upgradedRoot.getParent().asComponent();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                progress.cycle();
            }
        }
        finally {
            progress.conquer();
            progress.fulfill();
        }
        progress.constrain(100);
        try {
            if (base != null) {
                UpgradeUtil.rebuildRelations(base, relationSpecs);
            }
        }
        finally {
            progress.fulfill();
        }
    }

    public static void upgradeTemplates(BTemplateConfig tmplConfig, boolean isRedeploy) throws Exception {
        UpgradeUtil.upgradeTemplates(tmplConfig, isRedeploy, new ProgressTracker(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BComponent upgradeTemplates(BTemplateConfig tmplConfig, boolean isRedeploy, ProgressTracker progress, Set<RelationSpec> relationSpecs) throws Exception {
        BComponent l1Root;
        progress.constrain(80);
        try {
            l1Root = UpgradeUtil.upgradeTemplate(tmplConfig, isRedeploy, progress, relationSpecs);
        }
        finally {
            progress.fulfill();
        }
        progress.constrain(100);
        try {
            if (l1Root != null) {
                UpgradeUtil.upgradeSubtemplate(l1Root, isRedeploy, progress, relationSpecs);
            }
        }
        finally {
            progress.fulfill();
        }
        return l1Root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void upgradeSubtemplate(BComponent root, boolean isRedeploy, ProgressTracker progress, Set<RelationSpec> relationSpecs) {
        ArrayList<BComponent> newRoots = new ArrayList<BComponent>();
        progress.constrain(80);
        try {
            BTemplateConfig[] descendants;
            for (BTemplateConfig tmplConfig : descendants = (BTemplateConfig[])CompUtil.getDescendants((BComponent)root, BTemplateConfig.class)) {
                if (tmplConfig.getParent() == root || !tmplConfig.isMounted()) continue;
                try {
                    BComponent addedRoot = UpgradeUtil.upgradeTemplate(tmplConfig, isRedeploy, progress, relationSpecs);
                    if (addedRoot == null) continue;
                    newRoots.add(addedRoot);
                }
                catch (Exception e) {
                    BTemplateService.logger.log(Level.WARNING, "Error upgrading subtemplate: " + e.getLocalizedMessage(), e);
                }
            }
        }
        finally {
            progress.fulfill();
        }
        progress.constrain(100);
        try {
            progress.divide(newRoots.size());
            try {
                for (BComponent newRoot : newRoots) {
                    UpgradeUtil.upgradeSubtemplate(newRoot, isRedeploy, progress, relationSpecs);
                    progress.cycle();
                }
            }
            finally {
                progress.conquer();
            }
        }
        finally {
            progress.fulfill();
        }
    }

    private static BComponent upgradeTemplate(BTemplateConfig tmplConfig, boolean isRedeploy, ProgressTracker progress, Set<RelationSpec> relationSpecs) throws Exception {
        BComponent deployedRoot = tmplConfig.getParent().asComponent();
        progress.message("job.upgrading", deployedRoot.getSlotPath().toString());
        BComponent rootParent = deployedRoot.getParent().asComponent();
        BValue bValue = tmplConfig.get("ntplFile");
        if (bValue == null) {
            TemplateManifest manifest = tmplConfig.getManifest();
            FilePath ntplFilePath = new FilePath("^template/" + manifest.vendor).merge(tmplConfig.getTemplateName() + ".ntpl");
            BOrd ntplOrd = BOrd.make((OrdQuery)ntplFilePath);
            bValue = tmplConfig.get(tmplConfig.add("ntplFile", (BValue)ntplOrd, 5));
        }
        if (!(bValue instanceof BOrd)) {
            throw new RuntimeException("NtplFile not defined for: " + rootParent.getSlotPath());
        }
        BObject deployable = ((BOrd)bValue).get((BObject)deployedRoot);
        if (deployable == null || !deployable.getType().is(BIDeployable.TYPE)) {
            throw new RuntimeException("NtplFile not found for: " + rootParent.getSlotPath());
        }
        return UpgradeUtil.upgrade(deployedRoot, deployable, isRedeploy, progress, relationSpecs);
    }

    public static BComponent upgrade(BComponent deployedRoot, BObject ntplFile, boolean isRedeploy) throws Exception {
        return UpgradeUtil.upgrade(deployedRoot, ntplFile, isRedeploy, new ProgressTracker(), null);
    }

    public static BComponent upgrade(BComponent deployedRoot, BObject ntplFile, boolean isRedeploy, ProgressTracker progress, Set<RelationSpec> relationSpecs) throws Exception {
        String deployName = deployedRoot.getName();
        BComponent rootParent = deployedRoot.getParent().asComponent();
        if (!rootParent.isMounted()) {
            return null;
        }
        TemplateSaveData templateSavedData = UpgradeUtil.saveTemplateData(deployedRoot);
        if (relationSpecs != null) {
            UpgradeUtil.collectRelationSpecs(deployedRoot, templateSavedData, relationSpecs);
        }
        progress.message("job.dataSaved", new String[0]);
        BFormat displayName = rootParent.getDisplayNameFormat(deployedRoot.getPropertyInParent());
        try {
            Mark mark = new Mark(ntplFile, deployName);
            rootParent.remove((BComplex)deployedRoot);
            progress.message("job.removed", new String[0]);
            BComponent params = new BComponent();
            params.add("exact", (BValue)BBoolean.TRUE);
            mark.copyTo((BObject)rootParent, params, DeployToComp.NoPostLink);
        }
        catch (Exception e) {
            BTemplateService.logger.log(Level.WARNING, "Error upgrading template: " + e.getLocalizedMessage(), e);
            throw e;
        }
        progress.message("job.installed", new String[0]);
        BComponent newDeployRoot = rootParent.get(deployName).asComponent();
        if (displayName != null) {
            rootParent.setDisplayName(rootParent.getProperty(newDeployRoot.getName()), displayName, null);
        }
        BHistoryExt[] historyExtensions = (BHistoryExt[])CompUtil.getDescendants((BComponent)newDeployRoot, BHistoryExt.class);
        HashMap<String, Boolean> historyExtMap = new HashMap<String, Boolean>();
        for (BHistoryExt ext : historyExtensions) {
            historyExtMap.put(ext.getSlotPathOrd().encodeToString(), ext.getEnabled());
        }
        UpgradeUtil.restoreTemplateSaveData(templateSavedData, newDeployRoot, relationSpecs != null);
        UpgradeUtil.restoreHistoryExtensions(historyExtMap, newDeployRoot);
        progress.message("job.dataRestored", new String[0]);
        return newDeployRoot;
    }

    private static void restoreHistoryExtensions(HashMap<String, Boolean> historyMap, BComponent upgradedTemplate) {
        BHistoryExt[] staleHistoryExtensions = (BHistoryExt[])CompUtil.getDescendants((BComponent)upgradedTemplate, BHistoryExt.class);
        for (int i = 0; i < staleHistoryExtensions.length; ++i) {
            boolean enabled = historyMap.get(staleHistoryExtensions[i].getSlotPathOrd().encodeToString());
            staleHistoryExtensions[i].setEnabled(enabled);
        }
    }

    public static TemplateSaveData saveTemplateData(BComponent deployedRoot) {
        HashMap<Object, BComponent> handleMap = UpgradeUtil.getComponentHandleMap(deployedRoot);
        TemplateSaveData templateSavedData = new TemplateSaveData();
        BWsAnnotation[] wsAnnotations = (BWsAnnotation[])deployedRoot.getChildren(BWsAnnotation.class);
        if (wsAnnotations != null && wsAnnotations.length > 0) {
            templateSavedData.location = wsAnnotations[0];
        }
        BTemplateConfig templateConfig = BTemplateConfig.getConfigForRoot(deployedRoot);
        templateSavedData.rootProperties = UpgradeUtil.getRootProperties(deployedRoot);
        templateSavedData.pxEditSaveValues = UpgradeUtil.getPxEditValues(deployedRoot, templateConfig);
        templateSavedData.passwords = UpgradeUtil.getPasswords(templateConfig);
        templateSavedData.configProperties = UpgradeUtil.getConfigProperties(templateConfig);
        templateSavedData.inputLinks = UpgradeUtil.getInputLinks(deployedRoot, templateConfig);
        templateSavedData.outputKnobs = UpgradeUtil.getOutputKnobs(deployedRoot, templateConfig);
        templateSavedData.externalLinks = UpgradeUtil.getExternalLinks(deployedRoot, handleMap);
        templateSavedData.externalKnobs = UpgradeUtil.getExternalKnobs(deployedRoot, handleMap);
        templateSavedData.relationInfos = templateConfig.getRelationInfos();
        templateSavedData.outputRelations = deployedRoot.getComponentRelations();
        templateSavedData.inputRelations = UpgradeUtil.getInputRelations(deployedRoot);
        templateSavedData.externalOutputRelations = UpgradeUtil.getExternalRelations(deployedRoot, handleMap);
        templateSavedData.externalInputRelations = UpgradeUtil.getExternalRelationKnobs(deployedRoot, handleMap);
        templateSavedData.savedTags = UpgradeUtil.getComponentTags(deployedRoot);
        templateSavedData.savedPropertyValues = UpgradeUtil.getPropertyValues(deployedRoot);
        return templateSavedData;
    }

    public static void collectRelationSpecs(BComponent root, TemplateSaveData saveData, Set<RelationSpec> relationSpecs) {
        UpgradeUtil.collectInputLinks(root, saveData.inputLinks, relationSpecs);
        UpgradeUtil.collectOutputKnobs(root, saveData.outputKnobs, relationSpecs);
        UpgradeUtil.collectExternalLinks(root, saveData.externalLinks, relationSpecs);
        UpgradeUtil.collectExternalKnobs(saveData.externalKnobs, relationSpecs);
        UpgradeUtil.collectOutputRelations(root, saveData.outputRelations, saveData.relationInfos, relationSpecs);
        UpgradeUtil.collectInputRelations(root, saveData.inputRelations, relationSpecs);
        UpgradeUtil.collectExternalOutputRelations(root, saveData.externalOutputRelations, relationSpecs);
        UpgradeUtil.collectExternalInputRelations(root, saveData.externalInputRelations, relationSpecs);
    }

    private static void collectInputLinks(BComponent target, Hashtable<String, BLink> inputLinks, Set<RelationSpec> relationSpecs) {
        for (BLink link : inputLinks.values()) {
            try {
                UpgradeUtil.collectLink(target, target.getSlotPath(), link, relationSpecs);
            }
            catch (Exception exception) {}
        }
    }

    private static void collectOutputKnobs(BComponent source, Hashtable<String, LinkTarget[]> outputKnobs, Set<RelationSpec> relationSpecs) {
        for (Map.Entry<String, LinkTarget[]> outputKnobEntry : outputKnobs.entrySet()) {
            try {
                UpgradeUtil.collectKnob(Objects.requireNonNull(source.getSlotPath()), outputKnobEntry.getKey(), Arrays.asList((Object[])outputKnobEntry.getValue()), relationSpecs);
            }
            catch (Exception exception) {}
        }
    }

    private static void collectExternalLinks(BComponent base, Hashtable<BOrd, ArrayList<BLink>> externalLinks, Set<RelationSpec> relationSpecs) {
        for (Map.Entry<BOrd, ArrayList<BLink>> externalLinkEntry : externalLinks.entrySet()) {
            try {
                SlotPath targetPath = (SlotPath)externalLinkEntry.getKey().parse()[0];
                for (BLink link : externalLinkEntry.getValue()) {
                    UpgradeUtil.collectLink(base, targetPath, link, relationSpecs);
                }
            }
            catch (Exception exception) {
            }
        }
    }

    private static void collectExternalKnobs(Hashtable<BOrd, Hashtable<String, ArrayList<LinkTarget>>> externalKnobs, Set<RelationSpec> relationSpecs) {
        for (Map.Entry<BOrd, Hashtable<String, ArrayList<LinkTarget>>> externalKnobEntry : externalKnobs.entrySet()) {
            try {
                SlotPath sourcePath = (SlotPath)externalKnobEntry.getKey().parse()[0];
                for (Map.Entry<String, ArrayList<LinkTarget>> linkTargetsEntry : externalKnobEntry.getValue().entrySet()) {
                    UpgradeUtil.collectKnob(sourcePath, linkTargetsEntry.getKey(), (List<LinkTarget>)linkTargetsEntry.getValue(), relationSpecs);
                }
            }
            catch (Exception exception) {
            }
        }
    }

    private static void collectLink(BComponent base, SlotPath targetPath, BLink link, Set<RelationSpec> relationSpecs) {
        try {
            SlotPath sourcePath = Objects.requireNonNull(link.getSourceOrd().resolve((BObject)base).get().asComponent().getSlotPath());
            relationSpecs.add(RelationSpec.makeLinkSpec(sourcePath, link.getSourceSlotName(), targetPath, link.getTargetSlotName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void collectKnob(SlotPath sourcePath, String sourceName, List<LinkTarget> linkTargets, Set<RelationSpec> relationSpecs) {
        for (LinkTarget linkTarget : linkTargets) {
            try {
                SlotPath targetPath = Objects.requireNonNull(linkTarget.target.getSlotPath());
                relationSpecs.add(RelationSpec.makeLinkSpec(sourcePath, sourceName, targetPath, linkTarget.slot));
            }
            catch (Exception exception) {}
        }
    }

    private static void collectOutputRelations(BComponent target, BRelation[] relations, ArrayList<BRelationInfo> oldRelationInfos, Set<RelationSpec> relationSpecs) {
        for (BRelation relation : relations) {
            if (relation instanceof BLink) continue;
            boolean wasInOldTemplate = false;
            for (BRelationInfo oldRelationInfo : oldRelationInfos) {
                if (oldRelationInfo.getInbound() || !relation.getRelationId().equals(oldRelationInfo.relationId)) continue;
                wasInOldTemplate = true;
                break;
            }
            try {
                UpgradeUtil.collectOutputRelation(target, relation, wasInOldTemplate, Objects.requireNonNull(target.getSlotPath()), relationSpecs);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void collectInputRelations(BComponent endpoint, Hashtable<String, BComponent> relations, Set<RelationSpec> relationSpecs) {
        for (Map.Entry<String, BComponent> relationsEntry : relations.entrySet()) {
            String relationId = relationsEntry.getKey();
            BComponent target = relationsEntry.getValue();
            try {
                UpgradeUtil.collectInputRelation(relationId, Objects.requireNonNull(endpoint.getSlotPath()), target, relationSpecs);
            }
            catch (Exception exception) {}
        }
    }

    private static void collectExternalOutputRelations(BComponent base, Hashtable<BOrd, ArrayList<BRelation>> externalOutputRelations, Set<RelationSpec> relationSpecs) {
        for (Map.Entry<BOrd, ArrayList<BRelation>> relationEntry : externalOutputRelations.entrySet()) {
            try {
                SlotPath targetPath = Objects.requireNonNull(relationEntry.getKey().resolve((BObject)base).get().asComponent().getSlotPath());
                for (BRelation relation : relationEntry.getValue()) {
                    UpgradeUtil.collectOutputRelation(base, relation, false, targetPath, relationSpecs);
                }
            }
            catch (Exception exception) {
            }
        }
    }

    private static void collectExternalInputRelations(BComponent base, Hashtable<BOrd, Hashtable<String, ArrayList<BComponent>>> externalInputRelations, Set<RelationSpec> relationSpecs) {
        for (Map.Entry<BOrd, Hashtable<String, ArrayList<BComponent>>> relationsEntry : externalInputRelations.entrySet()) {
            try {
                SlotPath endpointPath = Objects.requireNonNull(relationsEntry.getKey().resolve((BObject)base).get().asComponent().getSlotPath());
                for (Map.Entry<String, ArrayList<BComponent>> relationEntry : relationsEntry.getValue().entrySet()) {
                    String relationId = relationEntry.getKey();
                    for (BComponent target : relationEntry.getValue()) {
                        UpgradeUtil.collectInputRelation(relationId, endpointPath, target, relationSpecs);
                    }
                }
            }
            catch (Exception exception) {
            }
        }
    }

    private static void collectOutputRelation(BComponent base, BRelation relation, boolean wasInOldTemplate, SlotPath targetPath, Set<RelationSpec> relationSpecs) {
        try {
            SlotPath endpointPath = Objects.requireNonNull(relation.getEndpointOrd().resolve((BObject)base).get().asComponent().getSlotPath());
            relationSpecs.add(RelationSpec.makeRelationSpec(relation.getRelationId(), wasInOldTemplate, endpointPath, targetPath));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void collectInputRelation(String relationId, SlotPath endpointPath, BComponent target, Set<RelationSpec> relationSpecs) {
        try {
            relationSpecs.add(RelationSpec.makeRelationSpec(relationId, false, endpointPath, Objects.requireNonNull(target.getSlotPath())));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void restoreTemplateSaveData(TemplateSaveData savedData, BComponent newDeployedRoot, boolean ignoreRelations) {
        newDeployedRoot.lease(Integer.MAX_VALUE);
        BTemplateConfig newTemplateConfig = BTemplateConfig.getConfigForRoot(newDeployedRoot);
        if (savedData.location != null) {
            BValue wsAnnotation = newDeployedRoot.get("wsAnnotation");
            if (wsAnnotation != null) {
                newDeployedRoot.set("wsAnnotation", (BValue)savedData.location, null);
            } else {
                newDeployedRoot.add("wsAnnotation", (BValue)savedData.location);
            }
        }
        UpgradeUtil.restoreRootProperties(newDeployedRoot, savedData.rootProperties);
        UpgradeUtil.restorePasswords(newTemplateConfig, savedData.passwords);
        UpgradeUtil.restoreConfigProperties(newDeployedRoot, savedData.configProperties);
        if (!ignoreRelations) {
            UpgradeUtil.restoreInputLinks(newDeployedRoot, savedData.inputLinks);
            UpgradeUtil.restoreOutputLinks(newDeployedRoot, savedData.outputKnobs);
            UpgradeUtil.restoreOutputRelations(newDeployedRoot, savedData.relationInfos, savedData.outputRelations);
            UpgradeUtil.restoreInputRelations(newDeployedRoot, savedData.inputRelations);
        }
        UpgradeUtil.restorePxEditValues(newDeployedRoot, savedData.pxEditSaveValues);
        UpgradeUtil.restoreComponentTags(newDeployedRoot, savedData.savedTags);
        if (!ignoreRelations) {
            UpgradeUtil.restoreExternalLinks(newDeployedRoot, savedData.externalLinks);
            UpgradeUtil.restoreExternalKnobs(newDeployedRoot, savedData.externalKnobs);
            UpgradeUtil.restoreExternalRelations(newDeployedRoot, savedData.externalOutputRelations);
            UpgradeUtil.restoreExternalRelationKnobs(newDeployedRoot, savedData.externalInputRelations);
        }
        UpgradeUtil.restorePropertyValues(newDeployedRoot, savedData.savedPropertyValues);
    }

    public static void rebuildRelations(BComponent base, Set<RelationSpec> relationSpecs) {
        for (RelationSpec relationSpec : relationSpecs) {
            if (relationSpec.isLink) {
                UpgradeUtil.rebuildLink(base, relationSpec);
                continue;
            }
            UpgradeUtil.rebuildRelation(base, relationSpec);
        }
    }

    private static void rebuildLink(BComponent base, RelationSpec relationSpec) {
        assert (relationSpec.isLink);
        try {
            BOrd sourceOrd = BOrd.make((OrdQuery)relationSpec.sourcePath);
            BComponent source = sourceOrd.resolve((BObject)base).get().asComponent();
            Slot sourceSlot = source.getSlot(relationSpec.sourceName);
            BOrd targetOrd = BOrd.make((OrdQuery)relationSpec.targetPath);
            BComponent target = targetOrd.resolve((BObject)base).get().asComponent();
            Slot targetSlot = target.getSlot(relationSpec.targetName);
            BLink link = target.makeLink(source, sourceSlot, targetSlot, null);
            target.add(null, (BValue)link);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void rebuildRelation(BComponent base, RelationSpec relationSpec) {
        assert (!relationSpec.isLink);
        try {
            BOrd targetOrd = BOrd.make((OrdQuery)relationSpec.targetPath);
            BComponent target = targetOrd.resolve((BObject)base).get().asComponent();
            boolean ignore = false;
            if (relationSpec.wasInOldTemplate) {
                ignore = true;
                BTemplateConfig config = BTemplateConfig.getConfigForRoot(target);
                if (config != null) {
                    for (BRelationInfo info : config.getRelationInfos()) {
                        if (info.getInbound() || !info.relationId.equals(relationSpec.relationId)) continue;
                        ignore = false;
                        break;
                    }
                }
            }
            if (!ignore) {
                BOrd endpointOrd = BOrd.make((OrdQuery)relationSpec.sourcePath);
                BComponent endpoint = endpointOrd.resolve((BObject)base).get().asComponent();
                BRelation relation = target.makeRelation(Id.newId((String)relationSpec.relationId), endpoint, null);
                target.add(null, (BValue)relation);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void restoreConfigProperties(BComponent root, Hashtable<String, BValue> configProps) {
        BTemplateConfig tc = BTemplateConfig.getConfigForRoot(root);
        if (tc == null) {
            return;
        }
        for (Property property : tc.getProperties()) {
            BValue bValue;
            if ((tc.getFlags((Slot)property) & 5) != 0 || (bValue = configProps.get(property.getName())) == null) continue;
            tc.set(property, bValue);
        }
    }

    private static void restoreOutputRelations(BComponent root, ArrayList<BRelationInfo> oldRelationInfos, BRelation[] relations) {
        BTemplateConfig newTc = BTemplateConfig.getConfigForRoot(root);
        if (newTc == null) {
            return;
        }
        ArrayList<BRelationInfo> newRelationInfos = newTc.getRelationInfos();
        for (BRelation relation : relations) {
            if (relation instanceof BLink) continue;
            boolean wasInOldTemplateRelation = false;
            boolean isInNewTemplateRelation = false;
            for (BRelationInfo oldRelationInfo : oldRelationInfos) {
                if (oldRelationInfo.getInbound() || !relation.getRelationId().equals(oldRelationInfo.getRelationId())) continue;
                wasInOldTemplateRelation = true;
                break;
            }
            for (BRelationInfo newRelationInfo : newRelationInfos) {
                if (newRelationInfo.getInbound() || !relation.getRelationId().equals(newRelationInfo.getRelationId())) continue;
                isInNewTemplateRelation = true;
                break;
            }
            if (wasInOldTemplateRelation && !isInNewTemplateRelation) continue;
            root.add(null, relation.newCopy(true));
        }
    }

    private static void restoreInputRelations(BComponent root, Hashtable<String, BComponent> inputRelations) {
        Enumeration<String> relationIds = inputRelations.keys();
        while (relationIds.hasMoreElements()) {
            String relationId = relationIds.nextElement();
            BComponent source = inputRelations.get(relationId);
            BRelation relation = source.makeRelation(Id.newId((String)relationId), root, null);
            source.add(null, (BValue)relation);
        }
    }

    private static void restoreInputLinks(BComponent root, Hashtable<String, BLink> inputLinks) {
        BTemplateConfig tc = BTemplateConfig.getConfigForRoot(root);
        if (tc == null) {
            return;
        }
        for (Slot slot : tc.getInputSlots()) {
            BLink link = inputLinks.get(slot.getName());
            if (link == null) continue;
            root.add(null, (BValue)link);
        }
    }

    private static void restoreOutputLinks(BComponent root, Hashtable<String, LinkTarget[]> outputLinks) {
        BTemplateConfig tc = BTemplateConfig.getConfigForRoot(root);
        if (tc == null) {
            return;
        }
        for (Slot slot : tc.getOutputSlots()) {
            LinkTarget[] linkTargets = outputLinks.get(slot.getName());
            if (linkTargets == null || linkTargets.length == 0) continue;
            for (LinkTarget linkTarget : linkTargets) {
                if (linkTarget == null) continue;
                String targetSlotName = linkTarget.slot;
                BComponent target = linkTarget.target;
                Slot targetSlot = target.getSlot(targetSlotName);
                BLink link = target.makeLink(root, slot, targetSlot, null);
                target.add(null, (BValue)link);
            }
        }
    }

    private static void restoreExternalLinks(BComponent root, Hashtable<BOrd, ArrayList<BLink>> extLinks) {
        Enumeration<BOrd> keys = extLinks.keys();
        while (keys.hasMoreElements()) {
            try {
                BOrd ord = keys.nextElement();
                BComponent target = ord.resolve((BObject)root).get().asComponent();
                ArrayList<BLink> links = extLinks.get(ord);
                for (BLink link : links) {
                    target.add(null, (BValue)link);
                }
            }
            catch (Exception e) {
                BTemplateService.logger.log(Level.WARNING, "Error restoring external links: " + e.getLocalizedMessage(), e);
            }
        }
    }

    private static void restoreExternalKnobs(BComponent root, Hashtable<BOrd, Hashtable<String, ArrayList<LinkTarget>>> extKnobs) {
        Enumeration<BOrd> keys = extKnobs.keys();
        while (keys.hasMoreElements()) {
            try {
                BOrd ord = keys.nextElement();
                BComponent source = ord.resolve((BObject)root).get().asComponent();
                Hashtable<String, ArrayList<LinkTarget>> slotKnobs = extKnobs.get(ord);
                Enumeration<String> slots = slotKnobs.keys();
                while (slots.hasMoreElements()) {
                    String slotName = slots.nextElement();
                    Slot sourceSlot = source.getSlot(slotName);
                    for (LinkTarget linkTarget : slotKnobs.get(slotName)) {
                        if (linkTarget == null) continue;
                        String targetSlotName = linkTarget.slot;
                        BComponent target = linkTarget.target;
                        Slot targetSlot = target.getSlot(targetSlotName);
                        BLink link = target.makeLink(source, sourceSlot, targetSlot, null);
                        target.add(null, (BValue)link);
                    }
                }
            }
            catch (Exception e) {
                BTemplateService.logger.log(Level.WARNING, "Error restoring external knobs: " + e.getLocalizedMessage(), e);
            }
        }
    }

    private static void restoreExternalRelations(BComponent root, Hashtable<BOrd, ArrayList<BRelation>> extRelations) {
        Enumeration<BOrd> keys = extRelations.keys();
        while (keys.hasMoreElements()) {
            try {
                BOrd ord = keys.nextElement();
                BComponent target = ord.resolve((BObject)root).get().asComponent();
                ArrayList<BRelation> relations = extRelations.get(ord);
                for (BRelation relation : relations) {
                    target.add(null, (BValue)relation);
                }
            }
            catch (Exception e) {
                BTemplateService.logger.log(Level.WARNING, "Error restoring external relations: " + e.getLocalizedMessage(), e);
            }
        }
    }

    private static void restoreExternalRelationKnobs(BComponent root, Hashtable<BOrd, Hashtable<String, ArrayList<BComponent>>> extRelKnobs) {
        Enumeration<BOrd> keys = extRelKnobs.keys();
        while (keys.hasMoreElements()) {
            try {
                BOrd ord = keys.nextElement();
                BComponent relEp = ord.resolve((BObject)root).get().asComponent();
                Hashtable<String, ArrayList<BComponent>> relIdComps = extRelKnobs.get(ord);
                Enumeration<String> ids = relIdComps.keys();
                while (ids.hasMoreElements()) {
                    String relId = ids.nextElement();
                    for (BComponent relComp : relIdComps.get(relId)) {
                        if (relComp == null) continue;
                        BRelation rel = relComp.makeRelation(Id.newId((String)relId), relEp, null);
                        relComp.add(null, (BValue)rel);
                    }
                }
            }
            catch (Exception e) {
                BTemplateService.logger.log(Level.WARNING, "Error restoring external relation knobs: " + e.getLocalizedMessage(), e);
            }
        }
    }

    private static Hashtable<String, BLink> getInputLinks(BComponent templateRoot, BTemplateConfig templateConfig) {
        Hashtable<String, BLink> inputSources = new Hashtable<String, BLink>();
        for (Slot slot : templateConfig.getInputSlots()) {
            for (BLink link : templateRoot.getLinks(slot)) {
                inputSources.put(slot.getName(), (BLink)link.newCopy());
            }
        }
        return inputSources;
    }

    private static Hashtable<String, LinkTarget[]> getOutputKnobs(BComponent templateRoot, BTemplateConfig templateConfig) {
        Hashtable<String, LinkTarget[]> outputTargets = new Hashtable<String, LinkTarget[]>();
        for (Slot slot : templateConfig.getOutputSlots()) {
            Knob[] knobs = templateRoot.getKnobs(slot);
            LinkTarget[] targets = new LinkTarget[knobs.length];
            for (int i = 0; i < knobs.length; ++i) {
                BComponent targetComponent;
                String targetSlot = knobs[i].getTargetSlotName();
                if (knobs[i] instanceof LocalKnob) {
                    targetComponent = knobs[i].getTargetComponent();
                    targets[i] = new LinkTarget(targetSlot, targetComponent);
                    continue;
                }
                targetComponent = knobs[i].getTargetOrd().resolve((BObject)templateRoot).get().asComponent();
                targets[i] = new LinkTarget(targetSlot, targetComponent);
            }
            outputTargets.put(slot.getName(), targets);
        }
        return outputTargets;
    }

    private static Hashtable<String, BComponent> getInputRelations(BComponent templateRoot) {
        Hashtable<String, BComponent> inputRelations = new Hashtable<String, BComponent>();
        for (RelationKnob relationKnob : templateRoot.getRelationKnobs()) {
            if (relationKnob instanceof LocalRelationKnob) {
                BComponent source = relationKnob.getRelation().getParent().asComponent();
                String relationId = relationKnob.getRelationId();
                inputRelations.put(relationId, source);
                continue;
            }
            BOrd relationOrd = relationKnob.getRelationOrd();
            BComponent relationComponent = relationOrd.resolve((BObject)templateRoot).get().asComponent();
            String relationId = relationKnob.getRelationId();
            inputRelations.put(relationId, relationComponent);
        }
        return inputRelations;
    }

    private static Hashtable<String, BValue> getPxEditValues(BComponent root, BTemplateConfig templateConfig) {
        Hashtable<String, BValue> editTargets = new Hashtable<String, BValue>();
        UpgradeUtil.getPxEditValues(templateConfig, editTargets);
        for (BTemplateConfig tc : (BTemplateConfig[])CompUtil.getDescendants((BComponent)root, BTemplateConfig.class)) {
            if (tc == templateConfig) continue;
            UpgradeUtil.getPxEditValues(tc, editTargets);
        }
        return editTargets;
    }

    private static void getPxEditValues(BTemplateConfig templateConfig, Hashtable<String, BValue> editTargets) {
        BComponent deployRoot = templateConfig.getParent().asComponent();
        SlotPath rootSlotPath = deployRoot.getSlotPath();
        if (rootSlotPath == null) {
            return;
        }
        String[] rootSlotPathNames = rootSlotPath.getNames();
        for (BString slotPath : (BString[])templateConfig.getPxEditBindings().getChildren(BString.class)) {
            try {
                String[] split = slotPath.toString().split("slot:");
                SlotPath editSlotPath = new SlotPath(split[1]);
                String[] editSlotPathNames = editSlotPath.getNames();
                ArrayList<String> mergeNames = new ArrayList<String>();
                Collections.addAll(mergeNames, rootSlotPathNames);
                mergeNames.addAll(Arrays.asList(editSlotPathNames).subList(1, editSlotPathNames.length));
                String[] pathNames = new String[mergeNames.size()];
                mergeNames.toArray(pathNames);
                editSlotPath = new SlotPath("slot", pathNames);
                BOrd targetOrd = BOrd.make((OrdQuery)editSlotPath);
                BObject curValue = targetOrd.resolve((BObject)deployRoot).get();
                editTargets.put(editSlotPath.getBody(), curValue.asValue());
            }
            catch (Exception e) {
                BTemplateService.logger.log(Level.WARNING, "Error resolving PX edit values: " + e.getLocalizedMessage(), e);
            }
        }
    }

    private static Hashtable<String, BValue> getConfigProperties(BTemplateConfig templateConfig) {
        Hashtable<String, BValue> configProps = new Hashtable<String, BValue>();
        for (Property property : templateConfig.getProperties()) {
            if ((templateConfig.getFlags((Slot)property) & 5) != 0) continue;
            configProps.put(property.getName(), templateConfig.get(property).newCopy(true));
        }
        return configProps;
    }

    private static Hashtable<String, BValue> getRootProperties(BComponent templateRoot) {
        Hashtable<String, BValue> rootProps = new Hashtable<String, BValue>();
        for (Property property : templateRoot.getProperties()) {
            BValue curVal;
            if ((templateRoot.getFlags((Slot)property) & 2) != 0 || property.getName().startsWith("ntpl$3a") || (curVal = templateRoot.get(property)) instanceof BPxView || curVal instanceof BLink || curVal instanceof BComponent) continue;
            rootProps.put(property.getName(), curVal);
        }
        return rootProps;
    }

    private static Hashtable<BOrd, ArrayList<Tag>> getComponentTags(BComponent templateRoot) {
        BComponent[] comps;
        Hashtable<BOrd, ArrayList<Tag>> compTags = new Hashtable<BOrd, ArrayList<Tag>>();
        for (BComponent comp : comps = (BComponent[])CompUtil.getDescendants((BComponent)templateRoot, BComponent.class)) {
            BOrd ord;
            ArrayList<Tag> tags = new ArrayList<Tag>();
            for (Tag tag : new ComponentTags(comp)) {
                String qName;
                Property prop;
                if (tag.getId().getDictionary().equals("ntpl") || Flags.isUserDefined4((BComplex)comp, (Slot)(prop = comp.getProperty(qName = SlotPath.escape((String)tag.getId().getQName()))))) continue;
                tags.add(tag);
            }
            for (BRelation relation : (BRelation[])comp.getChildren(BRelation.class)) {
                Entity endpoint;
                Property pip;
                BComplex parent;
                if (!relation.getRelationId().equals("n:tagGroup") || Flags.isUserDefined4((BComplex)(parent = relation.getParent()), (Slot)(pip = relation.getPropertyInParent())) || (endpoint = relation.getEndpoint()) == null || !(endpoint instanceof TagGroupInfo)) continue;
                TagGroupInfo tgi = (TagGroupInfo)endpoint;
                if (tgi instanceof BComponent) {
                    ((BComponent)tgi).lease(2);
                }
                Iterator tgiTags = tgi.getTags();
                while (tgiTags.hasNext()) {
                    TagInfo tagInfo = (TagInfo)tgiTags.next();
                    tags.add(tagInfo.makeTag());
                }
            }
            if (tags.size() <= 0 || (ord = comp.getSlotPathOrd()) == null) continue;
            compTags.put(ord, tags);
        }
        return compTags;
    }

    private static Hashtable<BOrd, ArrayList<BLink>> getExternalLinks(BComponent root, HashMap<Object, BComponent> handleMap) {
        BComponent[] components;
        Hashtable<BOrd, ArrayList<BLink>> compExtLinks = new Hashtable<BOrd, ArrayList<BLink>>();
        for (BComponent comp : components = (BComponent[])CompUtil.getDescendants((BComponent)root, BComponent.class)) {
            ArrayList<BLink> extLinks = new ArrayList<BLink>();
            for (BLink link : comp.getLinks()) {
                Property linkPIP;
                BComplex linkParent;
                String ord;
                if (LinkUtil.isCompositeLink((BLink)link) || !(ord = link.getSourceOrd().toString()).startsWith("h:") || handleMap.containsKey(link.getSourceOrd()) || Flags.isTransient((BComplex)(linkParent = link.getParent()), (Slot)(linkPIP = link.getPropertyInParent()))) continue;
                extLinks.add((BLink)link.newCopy());
            }
            if (extLinks.size() <= 0) continue;
            compExtLinks.put(comp.getSlotPathOrd(), extLinks);
        }
        return compExtLinks;
    }

    private static Hashtable<BOrd, Hashtable<String, ArrayList<LinkTarget>>> getExternalKnobs(BComponent root, HashMap<Object, BComponent> handleMap) {
        BComponent[] components;
        Hashtable<BOrd, Hashtable<String, ArrayList<LinkTarget>>> outputTargets = new Hashtable<BOrd, Hashtable<String, ArrayList<LinkTarget>>>();
        for (BComponent comp : components = (BComponent[])CompUtil.getDescendants((BComponent)root, BComponent.class)) {
            try {
                ArrayList<String> processed = new ArrayList<String>();
                Hashtable compLinks = new Hashtable();
                for (Knob knob : comp.getKnobs()) {
                    Knob[] slotKnobs;
                    String sourceSlot = knob.getSourceSlotName();
                    if (processed.contains(sourceSlot)) continue;
                    processed.add(sourceSlot);
                    ArrayList<LinkTarget> extLinks = new ArrayList<LinkTarget>();
                    for (Knob slotKnob : slotKnobs = comp.getKnobs(comp.getSlot(sourceSlot))) {
                        BComponent targetComponent;
                        BOrd targetOrd = slotKnob.getTargetOrd();
                        String ord = targetOrd.toString();
                        if (!ord.startsWith("h:") || handleMap.containsKey(targetOrd)) continue;
                        String targetSlot = slotKnob.getTargetSlotName();
                        if (slotKnob instanceof LocalKnob) {
                            targetComponent = slotKnob.getTargetComponent();
                            extLinks.add(new LinkTarget(targetSlot, targetComponent));
                            continue;
                        }
                        targetComponent = slotKnob.getTargetOrd().resolve((BObject)root).get().asComponent();
                        extLinks.add(new LinkTarget(targetSlot, targetComponent));
                    }
                    if (extLinks.size() <= 0) continue;
                    compLinks.put(sourceSlot, extLinks);
                }
                if (compLinks.size() <= 0) continue;
                outputTargets.put(comp.getSlotPathOrd(), compLinks);
            }
            catch (Exception e) {
                BTemplateService.logger.log(Level.WARNING, "Error resolving external knobs: " + e.getLocalizedMessage(), e);
            }
        }
        return outputTargets;
    }

    private static Hashtable<BOrd, ArrayList<BRelation>> getExternalRelations(BComponent root, HashMap<Object, BComponent> handleMap) {
        BComponent[] components;
        Hashtable<BOrd, ArrayList<BRelation>> compExtRelation = new Hashtable<BOrd, ArrayList<BRelation>>();
        for (BComponent comp : components = (BComponent[])CompUtil.getDescendants((BComponent)root, BComponent.class)) {
            ArrayList<BRelation> extRelations = new ArrayList<BRelation>();
            for (BRelation relation : comp.getComponentRelations()) {
                Property pip;
                String ord;
                if (relation instanceof BLink || !(ord = relation.getEndpointOrd().toString()).startsWith("h:") || handleMap.containsKey(relation.getSourceOrd()) || Flags.isUserDefined4((BComplex)comp, (Slot)(pip = relation.getPropertyInParent())) || Flags.isTransient((BComplex)comp, (Slot)pip)) continue;
                extRelations.add((BRelation)relation.newCopy());
            }
            if (extRelations.size() <= 0) continue;
            compExtRelation.put(comp.getSlotPathOrd(), extRelations);
        }
        return compExtRelation;
    }

    private static Hashtable<BOrd, Hashtable<String, ArrayList<BComponent>>> getExternalRelationKnobs(BComponent root, HashMap<Object, BComponent> handleMap) {
        BComponent[] components;
        Hashtable<BOrd, Hashtable<String, ArrayList<BComponent>>> inputRelations = new Hashtable<BOrd, Hashtable<String, ArrayList<BComponent>>>();
        for (BComponent comp : components = (BComponent[])CompUtil.getDescendants((BComponent)root, BComponent.class)) {
            try {
                ArrayList<String> idList = new ArrayList<String>();
                Hashtable compRelations = new Hashtable();
                RelationKnob[] relationKnobs = comp.getRelationKnobs();
                for (RelationKnob rKnob : relationKnobs) {
                    String id = rKnob.getRelationId();
                    if (idList.contains(id)) continue;
                    idList.add(id);
                }
                if (idList.size() == 0) continue;
                for (String id : idList) {
                    ArrayList<BComponent> extRelationComps = new ArrayList<BComponent>();
                    for (RelationKnob relationKnob : relationKnobs) {
                        if (!relationKnob.getRelationId().equals(id)) continue;
                        BComponent relationComp = relationKnob.getRelationComponent();
                        extRelationComps.add(relationComp);
                    }
                    if (extRelationComps.size() <= 0) continue;
                    compRelations.put(id, extRelationComps);
                }
                inputRelations.put(comp.getSlotPathOrd(), compRelations);
            }
            catch (Exception e) {
                BTemplateService.logger.log(Level.WARNING, "Error resolving external relation knobs: " + e.getLocalizedMessage(), e);
            }
        }
        return inputRelations;
    }

    private static void restoreComponentTags(BComponent root, Hashtable<BOrd, ArrayList<Tag>> compTags) {
        BComponent[] comps;
        for (BComponent comp : comps = (BComponent[])CompUtil.getDescendants((BComponent)root, BComponent.class)) {
            ArrayList<Tag> tags;
            BOrd slotPathOrd = comp.getSlotPathOrd();
            if (slotPathOrd == null || (tags = compTags.get(slotPathOrd)) == null) continue;
            for (Tag tag : tags) {
                if (tag == null) continue;
                try {
                    new ComponentTags(comp).set(tag);
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void restorePxEditValues(BComponent root, Hashtable<String, BValue> pxEditValues) {
        Enumeration<String> slotPathBodys = pxEditValues.keys();
        while (slotPathBodys.hasMoreElements()) {
            try {
                String body = slotPathBodys.nextElement();
                BValue savedValue = pxEditValues.get(body);
                SlotPath slotPath = new SlotPath("slot", body);
                BObject targetValue = BOrd.make((OrdQuery)slotPath).resolve((BObject)root).get();
                if (savedValue.isSimple()) {
                    SlotPath parentPath = slotPath.getParent();
                    String propStr = slotPath.nameAt(slotPath.depth() - 1);
                    BComplex parent = BOrd.make((OrdQuery)parentPath).resolve((BObject)root).get().asComplex();
                    parent.set(propStr, savedValue);
                    continue;
                }
                if (!savedValue.isComplex()) continue;
                Property prop = targetValue.asComplex().getPropertyInParent();
                BComplex parent = targetValue.asComplex().getParent();
                parent.set(prop, savedValue.newCopy());
            }
            catch (Exception exception) {}
        }
    }

    private static void restoreRootProperties(BComponent root, Hashtable<String, BValue> rootProps) {
        for (Property property : root.getProperties()) {
            BValue bValue = rootProps.get(property.getName());
            if (bValue == null) continue;
            root.set(property, bValue.newCopy(true));
        }
    }

    private static Hashtable<String, BPassword> getPasswords(BTemplateConfig templateConfig) {
        BPasswordBinding[] pswBindings;
        Hashtable<String, BPassword> passwords = new Hashtable<String, BPassword>();
        for (BPasswordBinding pswBinding : pswBindings = (BPasswordBinding[])templateConfig.getChildren(BPasswordBinding.class)) {
            Optional<BComponent> target = pswBinding.getTarget();
            if (!target.isPresent()) continue;
            BComponent targetComp = target.get();
            targetComp.lease();
            BValue bValue = targetComp.get(pswBinding.getPswSlot());
            if (!(bValue instanceof BPassword)) continue;
            passwords.put(pswBinding.getName(), (BPassword)bValue);
        }
        return passwords;
    }

    private static void restorePasswords(BTemplateConfig templateConfig, Hashtable<String, BPassword> passwords) {
        BPasswordBinding[] pswBindings;
        for (BPasswordBinding pswBinding : pswBindings = (BPasswordBinding[])templateConfig.getChildren(BPasswordBinding.class)) {
            Optional<BComponent> target;
            BPassword savedPsw = passwords.get(pswBinding.getName());
            if (savedPsw == null || !(target = pswBinding.getTarget()).isPresent()) continue;
            BComponent targetComp = target.get();
            String pswSlot = pswBinding.getPswSlot();
            targetComp.lease();
            BValue bValue = targetComp.get(pswSlot);
            if (!(bValue instanceof BPassword)) continue;
            targetComp.set(pswSlot, (BValue)savedPsw);
        }
    }

    private static Hashtable<BOrd, ArrayList<PropertyValue>> getPropertyValues(BComponent root) {
        Hashtable<BOrd, ArrayList<PropertyValue>> typePropertyValues = new Hashtable<BOrd, ArrayList<PropertyValue>>();
        for (TypeProperties saveTypeProperty : SAVE_TYPE_PROPERTIES) {
            for (Object o : CompUtil.getDescendants((BComponent)root, (Class)saveTypeProperty.type.getTypeClass())) {
                ArrayList<PropertyValue> values = new ArrayList<PropertyValue>();
                if (o instanceof BComponent) {
                    BComponent comp = (BComponent)o;
                    for (String property : saveTypeProperty.properties) {
                        BValue bValue = comp.get(property);
                        if (bValue == null) continue;
                        values.add(new PropertyValue(property, bValue));
                    }
                }
                if (values.size() <= 0) continue;
                typePropertyValues.put(((BComponent)o).getSlotPathOrd(), values);
            }
        }
        return typePropertyValues;
    }

    private static void restorePropertyValues(BComponent root, Hashtable<BOrd, ArrayList<PropertyValue>> propertyValues) {
        for (BOrd ord : propertyValues.keySet()) {
            try {
                BObject bObject = ord.resolve((BObject)root).get();
                if (bObject == null || !bObject.isComponent()) continue;
                BComponent comp = bObject.asComponent();
                for (PropertyValue propertyValue : propertyValues.get(ord)) {
                    comp.set(propertyValue.property, propertyValue.value);
                }
            }
            catch (Exception exception) {
            }
        }
    }

    public static BINtplFile getDeployedNtplFile(BTemplateConfig tmplConfig) throws Exception {
        return UpgradeUtil.getDeployedNtplFile(tmplConfig, "^template/", "ntpl");
    }

    public static BINtplFile getDeployedNtplFile(BTemplateConfig tmplConfig, String filepathBase, String extension) {
        BValue bValue = tmplConfig.get("ntplFile");
        if (bValue == null) {
            TemplateManifest manifest = tmplConfig.getManifest();
            FilePath ntplFilePath = new FilePath(filepathBase + manifest.vendor).merge(tmplConfig.getTemplateName() + '.' + extension);
            BOrd ntplOrd = BOrd.make((OrdQuery)ntplFilePath);
            bValue = tmplConfig.get(tmplConfig.add("ntplFile", (BValue)ntplOrd, 5));
        }
        if (!(bValue instanceof BOrd)) {
            throw new RuntimeException("NtplFile not defined for: " + tmplConfig.getSlotPath());
        }
        BObject deployable = ((BOrd)bValue).get((BObject)tmplConfig);
        if (deployable == null || !deployable.getType().is(BINtplFile.TYPE)) {
            throw new RuntimeException("NtplFile not found for: " + tmplConfig.getSlotPath());
        }
        return (BINtplFile)deployable;
    }

    public static void deleteTemplateInputRelations(BComponent template, List<String[]> templateDefs) {
        for (RelationKnob relationKnob : template.getRelationKnobs()) {
            String relationId = relationKnob.getRelationId();
            if (!UpgradeUtil.isValidTemplateRelation(relationId, "Inbound", templateDefs)) continue;
            if (relationKnob instanceof LocalRelationKnob) {
                BComponent source = relationKnob.getRelation().getParent().asComponent();
                Optional relationToRemove = source.relations().get(Id.newId((String)relationId));
                relationToRemove.ifPresent(relation -> {
                    LOG.log(LOG_LEVEL, String.format("Deleting LocalRelationKnob input relation %s ", relation.getId().getQName()));
                    source.relations().remove(relation);
                });
                continue;
            }
            BOrd relationOrd = relationKnob.getRelationOrd();
            BComponent relationComponent = relationOrd.resolve((BObject)template).get().asComponent();
            Optional relationToRemove = relationComponent.relations().get(Id.newId((String)relationId));
            relationToRemove.ifPresent(relation -> {
                LOG.log(LOG_LEVEL, String.format("Deleting ProxyRelationKnob input relation %s ", relation.getId().getQName()));
                relationComponent.relations().remove(relation);
            });
        }
    }

    public static void deleteTemplateOutputRelations(BComponent template, List<String[]> templateDefs) {
        BTemplateConfig templateConfig = BTemplateConfig.getConfigForRoot(template);
        if (templateConfig == null) {
            return;
        }
        ArrayList<BRelationInfo> relationInfos = templateConfig.getRelationInfos();
        List<BRelation> relations = Arrays.asList(template.getComponentRelations());
        block0: for (BRelation relation : relations) {
            if (relation instanceof BLink) continue;
            for (BRelationInfo relationInfo : relationInfos) {
                if (relationInfo.getInbound() || !relation.getRelationId().equals(relationInfo.getRelationId()) || !UpgradeUtil.isValidTemplateRelation(relationInfo.getRelationId(), "Outbound", templateDefs)) continue;
                LOG.log(LOG_LEVEL, String.format("Deleting output relation %s ", relation.getId().getQName()));
                template.relations().remove((Relation)relation);
                continue block0;
            }
        }
    }

    public static void deleteTemplateInputLinks(BComponent template, List<String[]> inputDefs) {
        BTemplateConfig templateConfig = BTemplateConfig.getConfigForRoot(template);
        if (templateConfig == null) {
            return;
        }
        for (Slot slot : templateConfig.getInputSlots()) {
            if (!UpgradeUtil.isValidTemplateSlot(slot, inputDefs)) continue;
            for (BLink link : template.getLinks(slot)) {
                if (link == null) continue;
                LOG.log(LOG_LEVEL, String.format("Deleting input link %s <-> %s", link.getSourceSlotName(), link.getTargetSlotName()));
                template.remove((BComplex)link);
            }
        }
    }

    public static void deleteTemplateOutputLinks(BComponent template, List<String[]> outputDefs) {
        BTemplateConfig templateConfig = BTemplateConfig.getConfigForRoot(template);
        if (templateConfig == null) {
            return;
        }
        for (Slot slot : templateConfig.getOutputSlots()) {
            Knob[] knobs;
            if (!UpgradeUtil.isValidTemplateSlot(slot, outputDefs)) continue;
            for (Knob knob : knobs = template.getKnobs(slot)) {
                String targetSlotName = knob.getTargetSlotName();
                BComponent targetComponent = knob instanceof LocalKnob ? knob.getTargetComponent() : knob.getTargetOrd().resolve((BObject)template).get().asComponent();
                Slot targetSlot = targetComponent.getSlot(targetSlotName);
                for (BLink link : targetComponent.getLinks(targetSlot)) {
                    if (!link.getSourceSlotName().contentEquals(slot.getName())) continue;
                    LOG.log(LOG_LEVEL, String.format("Deleting output link %s <-> %s", link.getSourceSlotName(), link.getTargetSlotName()));
                    targetComponent.remove((BComplex)link);
                }
            }
        }
    }

    private static boolean isValidTemplateRelation(String relationId, String direction, List<String[]> templateDefs) {
        for (String[] relationDef : templateDefs) {
            if (relationDef.length < 4 || relationDef[1] == null || relationDef[3] == null) continue;
            String id = relationDef[1];
            String dir = relationDef[3];
            if (!id.contentEquals(relationId) || !dir.contentEquals(direction)) continue;
            return true;
        }
        return false;
    }

    private static boolean isValidTemplateSlot(Slot slot, List<String[]> templateDefs) {
        for (String[] slotDefs : templateDefs) {
            String slotName = slotDefs[0];
            if (!slot.getName().contentEquals(slotName)) continue;
            return true;
        }
        return false;
    }

    public static long getTemplateSignature(BComponent root) {
        HashMap<Object, BComponent> handleMap = UpgradeUtil.getComponentHandleMap(root);
        CRC32 crc = new CRC32();
        int internalLinkCount = 0;
        int complexCount = 0;
        ArrayList<String> names = new ArrayList<String>();
        for (BComplex bComplex : (BComplex[])CompUtil.getDescendants((BComponent)root, BComplex.class)) {
            int FLAGS;
            int flags;
            if (UpgradeUtil.isSubtemplateComp(root, bComplex)) continue;
            BComplex parent = bComplex.getParent();
            Property pip = bComplex.getPropertyInParent();
            if (pip == null || pip.isFrozen() || ((flags = parent.getFlags((Slot)pip)) & (FLAGS = 81922)) != 0) continue;
            if (bComplex.getType().is(BLink.TYPE)) {
                BLink link = (BLink)bComplex;
                String ord = link.getSourceOrd().toString();
                if (!ord.startsWith("h:") || !handleMap.containsKey(link.getSourceOrd())) continue;
                ++internalLinkCount;
                continue;
            }
            if (UpgradeUtil.isExcludeType(bComplex)) continue;
            ++complexCount;
            String s = bComplex.getName() + "_" + bComplex.getType().getDisplayName(null);
            BTemplateService.logger.finest(root.getSlotPath() + " name =" + s);
            names.add(s);
        }
        Collections.sort(names);
        for (String name : names) {
            crc.update(name.getBytes());
        }
        BTemplateService.logger.finest(root.getSlotPath() + " internalLinkCount=" + internalLinkCount);
        BTemplateService.logger.finest(root.getSlotPath() + " complexCount     =" + complexCount);
        crc.update(internalLinkCount);
        return crc.getValue();
    }

    private static boolean isExcludeType(BComplex complex) {
        BComplex parent = complex.getParent();
        Type parentType = parent == null ? null : parent.getType();
        for (Type excludeType : EXCLUDE_TYPES) {
            if (excludeType.is(complex.getType())) {
                return true;
            }
            if (parentType == null || !excludeType.is(parentType)) continue;
            return true;
        }
        return false;
    }

    private static HashMap<Object, BComponent> getComponentHandleMap(BComponent root) {
        BComponent[] components;
        HashMap<Object, BComponent> handleMap = new HashMap<Object, BComponent>();
        handleMap.put(root.getHandleOrd(), root);
        for (BComponent component : components = (BComponent[])CompUtil.getDescendants((BComponent)root, BComponent.class)) {
            handleMap.put(component.getHandleOrd(), component);
        }
        return handleMap;
    }

    private static boolean isSubtemplateComp(BComponent root, BComplex child) {
        BComponent comp = UpgradeUtil.getParentTemplate(child);
        return comp != null && comp != root;
    }

    public static BComponent getParentTemplate(BComplex child) {
        for (BComplex parent = child.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.isComponent() || parent.asComponent().get(ROOT_TAG_NAME) == null) continue;
            return parent.asComponent();
        }
        return null;
    }

    public static class TemplateSaveData {
        BWsAnnotation location = null;
        Hashtable<String, BValue> rootProperties = null;
        Hashtable<String, BValue> pxEditSaveValues = null;
        Hashtable<String, BPassword> passwords = null;
        Hashtable<String, BValue> configProperties = null;
        Hashtable<String, BLink> inputLinks = null;
        Hashtable<BOrd, ArrayList<BLink>> externalLinks = null;
        Hashtable<String, LinkTarget[]> outputKnobs = null;
        Hashtable<BOrd, Hashtable<String, ArrayList<LinkTarget>>> externalKnobs = null;
        ArrayList<BRelationInfo> relationInfos = null;
        BRelation[] outputRelations = null;
        Hashtable<String, BComponent> inputRelations = null;
        Hashtable<BOrd, ArrayList<BRelation>> externalOutputRelations = null;
        Hashtable<BOrd, Hashtable<String, ArrayList<BComponent>>> externalInputRelations = null;
        Hashtable<BOrd, ArrayList<Tag>> savedTags = null;
        Hashtable<BOrd, ArrayList<PropertyValue>> savedPropertyValues = null;
    }

    private static class PropertyValue {
        String property;
        BValue value;

        PropertyValue(String property, BValue value) {
            this.property = property;
            this.value = value;
        }
    }

    private static class TypeProperties {
        Type type;
        String[] properties;

        TypeProperties(Type type, String[] properties) {
            this.type = type;
            this.properties = properties;
        }
    }

    public static class RelationSpec {
        final boolean isLink;
        final String relationId;
        final boolean wasInOldTemplate;
        final SlotPath sourcePath;
        final String sourceName;
        final SlotPath targetPath;
        final String targetName;

        public static RelationSpec makeLinkSpec(SlotPath sourcePath, String sourceName, SlotPath targetPath, String targetName) {
            return new RelationSpec(true, "n:dataLink", false, sourcePath, sourceName, targetPath, targetName);
        }

        public static RelationSpec makeRelationSpec(String relationId, boolean wasInOldTemplate, SlotPath endpointPath, SlotPath targetPath) {
            return new RelationSpec(false, relationId, wasInOldTemplate, endpointPath, "", targetPath, "");
        }

        private RelationSpec(boolean isLink, String relationId, boolean wasInOldTemplate, SlotPath sourcePath, String sourceName, SlotPath targetPath, String targetName) {
            this.isLink = isLink;
            this.relationId = relationId;
            this.wasInOldTemplate = wasInOldTemplate;
            this.sourcePath = Objects.requireNonNull(sourcePath);
            this.sourceName = Objects.requireNonNull(sourceName);
            this.targetPath = Objects.requireNonNull(targetPath);
            this.targetName = Objects.requireNonNull(targetName);
        }

        public int hashCode() {
            return Objects.hash(this.isLink, this.relationId, this.wasInOldTemplate, this.sourcePath.toString(), this.sourceName, this.targetPath.toString(), this.targetName);
        }

        public boolean equals(Object o) {
            return o instanceof RelationSpec && this.isLink == ((RelationSpec)o).isLink && this.relationId.equals(((RelationSpec)o).relationId) && this.wasInOldTemplate == ((RelationSpec)o).wasInOldTemplate && this.sourcePath.toString().equals(((RelationSpec)o).sourcePath.toString()) && this.sourceName.equals(((RelationSpec)o).sourceName) && this.targetPath.toString().equals(((RelationSpec)o).targetPath.toString()) && this.targetName.equals(((RelationSpec)o).targetName);
        }

        public String toString() {
            if (this.isLink) {
                return this.sourcePath + "." + this.sourceName + "->" + this.targetPath + "." + this.targetName;
            }
            return this.relationId + ":" + this.sourcePath + "->" + this.targetPath;
        }
    }

    private static class LinkTarget {
        String slot;
        BComponent target;

        LinkTarget(String slot, BComponent target) {
            this.slot = slot;
            this.target = target;
        }
    }
}

