/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BRelationInfo
extends BSimple {
    public static final BRelationInfo DEFAULT = new BRelationInfo(false, "", "", "");
    public static final Type TYPE = Sys.loadType(BRelationInfo.class);
    boolean inbound = false;
    String relationId = "";
    String relateHints = "";
    String userTip = "";

    public Type getType() {
        return TYPE;
    }

    public static BRelationInfo make(boolean inbound, String relationId, String relateHints, String userTip) {
        return new BRelationInfo(inbound, relationId, relateHints, userTip);
    }

    private BRelationInfo(boolean inbound, String relationId, String relateHints, String userTip) {
        this.inbound = inbound;
        this.relationId = relationId;
        this.relateHints = relateHints;
        this.userTip = userTip;
    }

    public String getRelationId() {
        return this.relationId;
    }

    public String getRelateHints() {
        return this.relateHints;
    }

    public boolean getInbound() {
        return this.inbound;
    }

    public String getUserTip() {
        return this.userTip;
    }

    public void setRelateHints(String hints) {
        this.relateHints = hints;
    }

    public void setInbound(boolean inbound) {
        this.inbound = inbound;
    }

    public void setUserTip(String userTip) {
        this.userTip = userTip;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BRelationInfo)) {
            return false;
        }
        BRelationInfo other = (BRelationInfo)((Object)obj);
        return other.inbound == this.inbound && other.relationId.equals(this.relationId) && other.relateHints.equals(this.relateHints) && other.userTip.equals(this.userTip);
    }

    public void encode(DataOutput encoder) throws IOException {
        encoder.writeBoolean(this.inbound);
        encoder.writeUTF(this.relationId);
        encoder.writeUTF(this.relateHints);
        encoder.writeUTF(this.userTip);
    }

    public BObject decode(DataInput decoder) throws IOException {
        boolean inbound = decoder.readBoolean();
        String relationId = decoder.readUTF();
        String relateHints = decoder.readUTF();
        String userTip = decoder.readUTF();
        return new BRelationInfo(inbound, relationId, relateHints, userTip);
    }

    public String encodeToString() throws IOException {
        return this.toString();
    }

    public BObject decodeFromString(String s) throws IOException {
        boolean inbound = false;
        String relateId = "";
        String relateHints = "";
        String userTip = "";
        String[] parms = s.split(",");
        int numParms = 4;
        if (parms.length < 4) {
            numParms = parms.length;
        }
        block0 : switch (numParms) {
            case 4: {
                userTip = parms[3].trim();
            }
            case 3: {
                relateHints = parms[2].trim();
            }
            case 2: {
                relateId = parms[1].trim();
            }
            case 1: {
                switch (parms[0]) {
                    case "In": {
                        inbound = true;
                        break block0;
                    }
                    case "Out": {
                        inbound = false;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Invalid boolean: " + s);
            }
        }
        return new BRelationInfo(inbound, relateId, relateHints, userTip);
    }

    public boolean hasValidRelateHints() {
        return !this.getRelateHints().isEmpty();
    }

    public String toString(Context cx) {
        return (this.inbound ? "In," : "Out,") + this.relationId + "," + this.relateHints + "," + this.userTip;
    }
}

