/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt.se;

import com.tridium.gx.GeomPeer;
import com.tridium.gx.GraphPaper;
import com.tridium.gx.Hatching;
import com.tridium.gx.awt.AwtEnv;
import com.tridium.gx.awt.se.AwtGeomPeer;
import com.tridium.gx.awt.se.AwtGraphPaper;
import com.tridium.gx.awt.se.AwtHatching;
import com.tridium.gx.awt.se.AwtImagePaint;
import com.tridium.gx.awt.se.AwtLinearGradient;
import com.tridium.gx.awt.se.AwtRadialGradient;
import com.tridium.gx.awt.se.AwtSeGraphics;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.gx.BBrush;
import javax.baja.gx.BPen;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.naming.BOrd;
import javax.baja.util.Lexicon;

public class AwtSeEnv
extends AwtEnv {
    private final GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
    private volatile String[] fontFamilyNames = emptyArray;
    private static final String[] emptyArray = new String[0];
    private static final HashMap<String, String> LOGICAL_FONTS = new HashMap();

    public AwtSeEnv() {
        try {
            String fontPath = "module://gx/fonts";
            BOrd ord = BOrd.make((String)fontPath);
            BIDirectory dir = (BIDirectory)ord.get();
            BIFile[] fonts = dir.listFiles();
            for (int i = 0; i < fonts.length; ++i) {
                BIFile file = fonts[i];
                if (!file.getExtension().equalsIgnoreCase("ttf")) continue;
                this.loadFont(file.getInputStream());
            }
        }
        catch (Throwable th) {
            Logger.getLogger("gx").log(Level.WARNING, "Could not load fonts from gx module. ", th);
        }
    }

    @Override
    public Graphics makeGraphics(Graphics2D g) {
        return new AwtSeGraphics(g);
    }

    @Override
    public Image makeBufferedImage(double w, double h) {
        return new BufferedImage((int)w, (int)h, 2);
    }

    public boolean isRotationSupported() {
        return true;
    }

    public GeomPeer makeGeomPeer(IGeom geom) {
        return AwtSeEnv.peer(geom);
    }

    public static Paint peer(BBrush brush) {
        Paint peer = (Paint)brush.fw(201, null, null, null, null);
        if (peer == null) {
            peer = AwtSeEnv.makePeer(brush);
            brush.fw(202, (Object)peer, null, null, null);
        }
        return peer;
    }

    public static AwtGeomPeer peer(IGeom geom) {
        AwtGeomPeer peer = (AwtGeomPeer)((Object)geom.fw(201, null, null, null, null));
        if (peer == null) {
            peer = (AwtGeomPeer)AwtGeomPeer.make(geom);
            geom.fw(202, (Object)peer, null, null, null);
        }
        return peer;
    }

    public static Stroke peer(BPen pen) {
        Stroke peer = (Stroke)pen.fw(201, null, null, null, null);
        if (peer == null) {
            peer = AwtSeEnv.makePeer(pen);
            pen.fw(202, (Object)peer, null, null, null);
        }
        return peer;
    }

    public static AffineTransform peer(BTransform transform) {
        AffineTransform peer = (AffineTransform)transform.fw(201, null, null, null, null);
        if (peer == null) {
            peer = AwtSeEnv.makePeer(transform);
            transform.fw(202, (Object)peer, null, null, null);
        }
        return peer;
    }

    private static Paint makePeer(BBrush brush) {
        BBrush.Paint paint = brush.getPaint();
        if (paint instanceof BBrush.Solid) {
            return AwtSeEnv.peer(((BBrush.Solid)paint).getColor());
        }
        if (paint instanceof BBrush.LinearGradient) {
            return new AwtLinearGradient((BBrush.LinearGradient)paint);
        }
        if (paint instanceof BBrush.RadialGradient) {
            return new AwtRadialGradient((BBrush.RadialGradient)paint);
        }
        if (paint instanceof BBrush.Image) {
            return AwtImagePaint.make((BBrush.Image)paint);
        }
        throw new IllegalStateException("Unsupported BBrush.Paint type");
    }

    private static Stroke makePeer(BPen p) {
        int join;
        int cap;
        float width = (float)p.getWidth();
        switch (p.getCap()) {
            case 103: {
                cap = 1;
                break;
            }
            case 102: {
                cap = 2;
                break;
            }
            default: {
                cap = 0;
            }
        }
        switch (p.getJoin()) {
            case 203: {
                join = 2;
                break;
            }
            case 202: {
                join = 1;
                break;
            }
            default: {
                join = 0;
            }
        }
        double[] dash = p.getDash();
        if (dash.length == 0) {
            return new BasicStroke(width, cap, join);
        }
        float[] fdash = new float[dash.length];
        for (int i = 0; i < fdash.length; ++i) {
            fdash[i] = width * (float)dash[i];
        }
        return new BasicStroke(width, cap, join, 10.0f, fdash, 0.0f);
    }

    private static AffineTransform makePeer(BTransform transform) {
        AffineTransform affine = new AffineTransform();
        BTransform.Transform[] transforms = transform.getTransforms();
        block7: for (int i = 0; i < transforms.length; ++i) {
            BTransform.Transform t = transforms[i];
            switch (t.getTransformCase()) {
                case 1: {
                    BTransform.Translate translate = (BTransform.Translate)t;
                    affine.translate(translate.getX(), translate.getY());
                    continue block7;
                }
                case 2: {
                    BTransform.Scale scale = (BTransform.Scale)t;
                    affine.scale(scale.getX(), scale.getY());
                    continue block7;
                }
                case 3: {
                    BTransform.Rotate rotate = (BTransform.Rotate)t;
                    affine.rotate(AwtSeEnv.toRadians(rotate.getAngle()));
                    continue block7;
                }
                case 4: {
                    BTransform.SkewX skewX = (BTransform.SkewX)t;
                    affine.shear(Math.tan(AwtSeEnv.toRadians(skewX.getAngle())), 0.0);
                    continue block7;
                }
                case 5: {
                    BTransform.SkewY skewY = (BTransform.SkewY)t;
                    affine.shear(0.0, Math.tan(AwtSeEnv.toRadians(skewY.getAngle())));
                    continue block7;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return affine;
    }

    static double toRadians(double degrees) {
        return degrees / 180.0 * Math.PI;
    }

    public GraphPaper makeGraphPaper() {
        return new AwtGraphPaper();
    }

    public Hatching makeHatching() {
        return new AwtHatching();
    }

    public void loadFont(InputStream in) {
        try {
            Font font = Font.createFont(0, in);
            this.env.registerFont(font);
            this.fontFamilyNames = emptyArray;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getValidFontName(String fontList) {
        String existingFont = this.getFirstExistingFont(fontList);
        if (existingFont != null && LOGICAL_FONTS.containsKey(existingFont.toLowerCase())) {
            String lexEntry = Lexicon.make((String)"bajaui").get("font." + existingFont.toLowerCase(), LOGICAL_FONTS.get(existingFont.toLowerCase()));
            existingFont = this.getFirstExistingFont(lexEntry + "," + existingFont);
        }
        if (existingFont == null) {
            existingFont = "Open Sans";
        }
        return existingFont;
    }

    private String getFirstExistingFont(String fontList) {
        StringTokenizer tokenizer = new StringTokenizer(fontList, ",;");
        while (tokenizer.hasMoreTokens()) {
            String name = tokenizer.nextToken().trim();
            if (name.length() <= 0) continue;
            if (name.startsWith("\"")) {
                name = name.substring(1, name.length());
            }
            if (name.endsWith("\"")) {
                name = name.substring(0, name.length() - 1);
            }
            if (name.startsWith("'")) {
                name = name.substring(1, name.length());
            }
            if (name.endsWith("'")) {
                name = name.substring(0, name.length() - 1);
            }
            if (this.hasFont(name)) {
                return name;
            }
            if (!LOGICAL_FONTS.containsKey(name.toLowerCase())) continue;
            return name.toLowerCase();
        }
        return null;
    }

    public void overrideFontFamily(String fontFamily, String valueName) {
        if (fontFamily == null) {
            throw new InvalidParameterException("Font family name required");
        }
        if (!LOGICAL_FONTS.containsKey(fontFamily.toLowerCase())) {
            throw new InvalidParameterException("Not a valid font family: " + fontFamily);
        }
        String existingFont = this.getValidFontName(valueName + "," + fontFamily);
        LOGICAL_FONTS.put(fontFamily.toLowerCase(), existingFont);
    }

    public boolean hasFont(String fontName) {
        int i;
        Object[] names = this.fontFamilyNames;
        if (names.length == 0) {
            names = this.env.getAvailableFontFamilyNames(Locale.ENGLISH);
            Arrays.sort(names);
            for (i = 0; i < names.length; ++i) {
                names[i] = ((String)names[i]).intern();
            }
            this.fontFamilyNames = names;
        }
        fontName = fontName.intern();
        for (i = 0; i < names.length; ++i) {
            if (names[i] != fontName) continue;
            return true;
        }
        return false;
    }

    static {
        Lexicon lex = Lexicon.make((String)"bajaui");
        LOGICAL_FONTS.put("Serif".toLowerCase(), lex.get("font.serif", "PT Serif"));
        LOGICAL_FONTS.put("SansSerif".toLowerCase(), lex.get("font.sansserif", "Open Sans"));
        LOGICAL_FONTS.put("Monospaced".toLowerCase(), lex.get("font.monospaced", "Droid Sans Mono"));
        LOGICAL_FONTS.put("Dialog".toLowerCase(), lex.get("font.dialog", "Open Sans"));
        LOGICAL_FONTS.put("DialogInput".toLowerCase(), lex.get("font.dialoginput", "Open Sans"));
    }
}

