/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDataRecovery.block;

import com.tridium.platDataRecovery.block.DataRecoveryBlock;

public final class UsedDataRecoveryBlock
extends DataRecoveryBlock {
    public UsedDataRecoveryBlock(byte sourceSpace, int dataRecoveryKeySize, byte[] dataRecoveryKey, int payloadSize, byte[] payload) throws Exception {
        if (payloadSize < 0) {
            throw new Exception("Invalid used payload size!");
        }
        if (payloadSize != payload.length) {
            throw new Exception("Payload size does not match payload.length!");
        }
        if (dataRecoveryKeySize < 0) {
            throw new Exception("Invalid key size!");
        }
        if (dataRecoveryKeySize > Short.MAX_VALUE) {
            throw new Exception("Key size is greater than Short.MAX_VALUE, key too large!");
        }
        if (dataRecoveryKeySize != dataRecoveryKey.length) {
            throw new Exception("Key size does not match key.length!");
        }
        this.sourceSpace = sourceSpace;
        this.payloadSize = payloadSize;
        this.payload = payload;
        this.keyInSourceSpaceSize = dataRecoveryKeySize;
        this.keyInSourceSpace = dataRecoveryKey;
    }

    @Override
    public DataRecoveryBlock coalesce(DataRecoveryBlock toMerge) {
        throw new UnsupportedOperationException("Can not merge anything with a Used block");
    }

    @Override
    public byte getBlockState() {
        return 1;
    }
}

