/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rdb.history;

import com.tridium.rdb.BRdbmsDiscoverTablesJob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.baja.driver.history.BHistoryDeviceExt;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.naming.BOrd;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.history.BRdbmsHistoryExport;
import javax.baja.rdb.history.BRdbmsHistoryImport;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BRdbmsHistoryDeviceExt
extends BHistoryDeviceExt {
    public static final Property useLastTimestamp = BRdbmsHistoryDeviceExt.newProperty((int)0, (boolean)false, null);
    public static final Property useHistoryConfigTimeZone = BRdbmsHistoryDeviceExt.newProperty((int)0, (boolean)false, null);
    public static final Action submitRdbTableDiscoveryJob = BRdbmsHistoryDeviceExt.newAction((int)4, null);
    public static final Action updateLastTimestamp = BRdbmsHistoryDeviceExt.newAction((int)132, null);
    public static final Action clearLastTimestamp = BRdbmsHistoryDeviceExt.newAction((int)132, null);
    public static final Type TYPE = Sys.loadType(BRdbmsHistoryDeviceExt.class);
    private static final Logger LOG = Logger.getLogger("rdb");

    public boolean getUseLastTimestamp() {
        return this.getBoolean(useLastTimestamp);
    }

    public void setUseLastTimestamp(boolean v) {
        this.setBoolean(useLastTimestamp, v, null);
    }

    public boolean getUseHistoryConfigTimeZone() {
        return this.getBoolean(useHistoryConfigTimeZone);
    }

    public void setUseHistoryConfigTimeZone(boolean v) {
        this.setBoolean(useHistoryConfigTimeZone, v, null);
    }

    public BOrd submitRdbTableDiscoveryJob() {
        return (BOrd)this.invoke(submitRdbTableDiscoveryJob, null, null);
    }

    public void updateLastTimestamp() {
        this.invoke(updateLastTimestamp, null, null);
    }

    public void clearLastTimestamp() {
        this.invoke(clearLastTimestamp, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getImportDescriptorType() {
        return BRdbmsHistoryImport.TYPE;
    }

    public boolean supportsGenericArchiveFolder() {
        return true;
    }

    public BOrd doSubmitRdbTableDiscoveryJob(Context cx) {
        if (this.getDevice().isFatalFault() || this.getDevice().isDown() || this.getDevice().isDisabled()) {
            return null;
        }
        return new BRdbmsDiscoverTablesJob(this).submit(cx);
    }

    public void doUpdateLastTimestamp() {
        LOG.fine("Beginning timestamp update...");
        long t0 = System.currentTimeMillis();
        BRdbms db = (BRdbms)this.getDevice();
        BHistoryDatabase localDb = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
        if (db.getExportMode().getOrdinal() == 0) {
            throw new BajaRuntimeException("updateLastTimestamp does not work when the export mode is set to BY_HISTORY_ID.");
        }
        Map<String, BAbsTime> timestampMap = this.makeTimestampMap(db);
        BRdbmsHistoryExport[] exports = (BRdbmsHistoryExport[])this.getChildren(BRdbmsHistoryExport.class);
        for (int i = 0; i < exports.length; ++i) {
            BHistoryId id = exports[i].getHistoryId();
            BAbsTime timestamp = timestampMap.get(id.toString());
            exports[i].setLastTimestamp(timestamp == null ? BAbsTime.NULL : timestamp);
        }
        long ms = System.currentTimeMillis() - t0;
        LOG.fine("Updated " + exports.length + " timestamps (" + ms + "ms)");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, BAbsTime> makeTimestampMap(BRdbms db) {
        try {
            HashMap<String, BAbsTime> map = new HashMap<String, BAbsTime>();
            try (Connection con = db.getConnection(db.getUserName(), db.getPassword());
                 ResultSet tables = con.createStatement().executeQuery("SELECT DISTINCT TABLE_NAME FROM HISTORY_TYPE_MAP");){
                while (tables.next()) {
                    ResultSet rs;
                    block37: {
                        rs = con.createStatement().executeQuery("SELECT MAX(TIMESTAMP) AS MAX_TIMESTAMP, HISTORY_ID FROM " + tables.getString("TABLE_NAME") + " GROUP BY HISTORY_ID");
                        Throwable throwable = null;
                        try {
                            while (rs.next()) {
                                BAbsTime timestamp = BAbsTime.make((long)rs.getTimestamp("MAX_TIMESTAMP").getTime());
                                map.put(rs.getString("HISTORY_ID"), timestamp);
                            }
                            if (rs == null) continue;
                            if (throwable == null) break block37;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (rs == null) throw throwable3;
                                if (throwable != null) {
                                    try {
                                        rs.close();
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                        throw throwable3;
                                    }
                                }
                                rs.close();
                                throw throwable3;
                            }
                        }
                        try {
                            rs.close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    rs.close();
                }
                return map;
            }
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void doClearLastTimestamp() {
        BRdbmsHistoryExport[] exports = (BRdbmsHistoryExport[])this.getChildren(BRdbmsHistoryExport.class);
        for (int i = 0; i < exports.length; ++i) {
            exports[i].setLastTimestamp(BAbsTime.NULL);
        }
        LOG.fine("Cleared " + exports.length + " timestamps.");
    }

    public String getUserName(BRdbms database, BRdbmsHistoryExport descriptor) {
        String str = descriptor.getUserName();
        if (str != null && !str.equals("")) {
            return str;
        }
        str = database.getUserName();
        if (str != null && !str.equals("")) {
            return str;
        }
        return "";
    }

    public BPassword getPassword(BRdbms database, BRdbmsHistoryExport descriptor) {
        BPassword password = descriptor.getPassword();
        if (password != null && !password.equals((Object)BPassword.DEFAULT)) {
            return password;
        }
        password = database.getPassword();
        if (password != null && !password.equals((Object)BPassword.DEFAULT)) {
            return password;
        }
        return BPassword.DEFAULT;
    }
}

