/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rdb;

import java.sql.Connection;
import java.sql.SQLException;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.BSession;
import javax.baja.naming.OrdQuery;
import javax.baja.nav.BINavNode;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.BRdbmsScheme;
import javax.baja.rdb.RdbmsQuery;
import javax.baja.security.AuthenticationException;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.status.BStatus;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BRdbmsSession
extends BSession
implements AuthenticationRealm {
    public static final Type TYPE = Sys.loadType(BRdbmsSession.class);
    private static final BIcon iconConnected = BIcon.std((String)"database.png");
    private static final BIcon iconDisconnected = BIcon.std((String)"databaseDisconnected.png");
    private BHost host;
    private RdbmsQuery query;
    private BRdbmsScheme scheme;
    private BOrd ordInHost;
    private BOrd absOrd;
    private BRdbms database;
    private Connection connection;
    private BUsernameAndPassword credentials;

    public Type getType() {
        return TYPE;
    }

    public static BRdbmsSession make(BHost host, RdbmsQuery query, BRdbmsScheme scheme) {
        String navName = query.getNavName();
        BRdbmsSession session = (BRdbmsSession)host.getNavChild(navName);
        if (session == null) {
            session = new BRdbmsSession(host, query, scheme);
            host.addNavChild((BINavNode)session);
        }
        return session;
    }

    private BRdbmsSession(BHost host, RdbmsQuery query, BRdbmsScheme scheme) {
        super(query.getNavName());
        this.host = host;
        this.query = query;
        this.scheme = scheme;
        this.ordInHost = BOrd.make((OrdQuery)query.duplicate());
        this.absOrd = BOrd.make((BOrd)host.getAbsoluteOrd(), (BOrd)this.ordInHost);
        this.database = scheme.newDatabase(host, query);
        this.connection = null;
        this.credentials = null;
    }

    public boolean isConnected() {
        return this.connection != null;
    }

    public void connect() throws Exception {
        if (this.isConnected()) {
            return;
        }
        try {
            this.connection = this.database.getConnection(this.credentials == null ? "" : this.credentials.getUsername(), this.credentials == null ? BPassword.DEFAULT : this.credentials.getPassword());
            this.database.setStatus(BStatus.makeDown((BStatus)this.database.getStatus(), (boolean)false));
        }
        catch (SQLException e) {
            this.database.setStatus(BStatus.makeDown((BStatus)this.database.getStatus(), (boolean)true));
            throw new AuthenticationException((AuthenticationRealm)this, (Throwable)e);
        }
    }

    public void disconnect() {
        if (this.connection == null) {
            return;
        }
        try {
            if (!this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.connection = null;
    }

    public void close() {
        this.disconnect();
        this.host.removeNavChild((BINavNode)this);
    }

    public BHost getHost() {
        return this.host;
    }

    public BOrd getAbsoluteOrd() {
        return this.absOrd;
    }

    public BOrd getOrdInHost() {
        return this.ordInHost;
    }

    public String getAuthenticationRealmName() {
        return this.absOrd.toString();
    }

    public String getAuthenticationScheme() {
        return this.scheme.getAuthName();
    }

    public BICredentials makeCredentials() {
        return new BUsernameAndPassword();
    }

    public BICredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(BICredentials credentials) {
        this.credentials = (BUsernameAndPassword)credentials;
    }

    public String getNavDisplayName(Context cx) {
        String string = this.scheme.getAuthName() + ":" + this.getHost().toString() + ":" + this.query.getBody();
        if (this.isConnected()) {
            return string + " [Connected]";
        }
        return string + " [Disconnected]";
    }

    public BOrd getNavOrd() {
        return this.absOrd;
    }

    public String getHostName() {
        return this.host.toString();
    }

    public RdbmsQuery getQuery() {
        return this.query;
    }

    public BRdbmsScheme getScheme() {
        return this.scheme;
    }

    public BRdbms getDatabase() {
        return this.database;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public BIcon getIcon() {
        return this.isConnected() ? iconConnected : iconDisconnected;
    }
}

