/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.util;

import com.tridium.rdb.BRdbmsDeprecatedDialect;
import com.tridium.rdb.util.BRdbmsUpdater;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.util.BDescriptor;
import javax.baja.driver.util.BDescriptorDeviceExt;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrdList;
import javax.baja.naming.BatchResolve;
import javax.baja.nre.util.Array;
import javax.baja.rdb.BRdbms;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BRdbmsUpdateJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BRdbmsUpdateJob.class);
    protected BRdbmsUpdater updater;
    protected Context cx;
    protected BRdbms database;
    protected Connection conn;
    protected DatabaseMetaData metadata;
    protected BRdbmsDeprecatedDialect dialect;
    protected Statement statement;
    protected boolean transactionCommitted;

    public Type getType() {
        return TYPE;
    }

    public BRdbmsUpdateJob() {
    }

    public BRdbmsUpdateJob(BRdbmsUpdater updater) {
        this.updater = updater;
    }

    public void run(Context cx) throws Exception {
        BRdbms[] databases = this.resolveDatabases(cx);
        for (int i = 0; i < databases.length; ++i) {
            BRdbms database = databases[i];
            if (!database.getStatus().isValid()) {
                this.log().message("Skipping update for " + database.getDisplayName(cx) + ". Status is " + database.getStatus());
                continue;
            }
            this.updateStarting(database, cx);
            this.log().message("Updating tables for database: " + database.getDisplayName(cx));
            this.updateTables();
            this.progress((int)((double)(i + 1) * 1.0 / (double)databases.length * 100.0));
            this.log().success("Table updates for database: " + database.getDisplayName(cx) + " complete");
            this.updateEnding();
        }
    }

    protected void updateStarting(BRdbms database, Context cx) throws SQLException {
        this.database = database;
        this.cx = cx;
        this.conn = database.getConnection();
        this.metadata = this.conn.getMetaData();
        this.dialect = BRdbmsDeprecatedDialect.make(database);
        this.statement = this.conn.createStatement();
        this.conn.setAutoCommit(false);
        this.transactionCommitted = false;
        this.disableDatabaseDescriptors(database);
    }

    protected void updateEnding() {
        try {
            this.log().message("Committing transaction..");
            this.conn.commit();
            this.log().message("Transaction comitted..");
            this.statement.close();
            this.conn.setAutoCommit(true);
            this.transactionCommitted = true;
        }
        catch (SQLException e) {
            this.failed(e);
        }
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                this.failed(e);
            }
        }
        this.enableDatabaseDescriptors(this.database);
    }

    private BRdbms[] resolveDatabases(Context cx) {
        BObject[] targetObjects;
        BOrdList dbOrds = this.updater.getDatabaseOrds();
        BatchResolve br = new BatchResolve(dbOrds.toArray()).resolve((BObject)this, cx);
        Array databases = new Array(BRdbms.class);
        for (BObject targetObj : targetObjects = br.getTargetObjects()) {
            databases.add((Object)((BRdbms)targetObj));
        }
        return (BRdbms[])databases.trim();
    }

    private void updateTables() {
        if (!this.database.getStatus().isValid()) {
            this.log().message("Skipping update for database: " + this.database.getDisplayName(this.cx) + ". Status is " + this.database.getStatus());
            return;
        }
        try {
            String[] tables = this.getTableNamesToUpdate();
            for (int i = 0; i < tables.length; ++i) {
                this.updateTable(tables[i]);
            }
        }
        catch (Exception e) {
            this.failed(e);
            try {
                this.log().message("Rolling back changes");
                this.conn.rollback();
            }
            catch (SQLException e1) {
                this.failed(e1);
            }
        }
    }

    protected abstract String[] getTableNamesToUpdate() throws Exception;

    protected abstract void updateTable(String var1) throws Exception;

    protected void enableDatabaseDescriptors(BRdbms database) {
        this.setDescriptorsEnabledState(database, true);
    }

    protected void disableDatabaseDescriptors(BRdbms database) {
        this.setDescriptorsEnabledState(database, false);
    }

    private void setDescriptorsEnabledState(BRdbms database, boolean enabled) {
        BDeviceExt[] exts = database.getDeviceExts();
        for (int i = 0; i < exts.length; ++i) {
            if (!(exts[i] instanceof BDescriptorDeviceExt)) continue;
            BDescriptorDeviceExt descriptionDeviceExt = (BDescriptorDeviceExt)exts[i];
            BDescriptor[] descriptors = descriptionDeviceExt.getDescriptors();
            for (int j = 0; j < descriptors.length; ++j) {
                descriptors[j].setEnabled(enabled);
            }
        }
    }
}

