/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.jdbc.trans;

import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.rdb.jdbc.RdbmsResultSet;
import com.tridium.rdb.jdbc.trans.BColumnTranslator;
import com.tridium.rdb.jdbc.trans.BSqlType;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BIntegerTranslator
extends BColumnTranslator {
    public static final Type TYPE = Sys.loadType(BIntegerTranslator.class);

    public BIntegerTranslator(RdbmsDialect dialect, BValue defaultValue) {
        super(dialect, defaultValue);
    }

    @Override
    public BSqlType getSqlType() {
        return BSqlType.sqlInt;
    }

    @Override
    public void setPreparedStatementValue(RdbmsPreparedStatement prep, int index, BValue value, Context context) {
        prep.setInt(index, ((BInteger)value).getInt());
    }

    @Override
    public BValue getResultSetValue(RdbmsResultSet rs, int index, Context context) {
        return BInteger.make((int)rs.getInt(index));
    }

    public Type getType() {
        return TYPE;
    }
}

