/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.jdbc.trans;

import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.rdb.jdbc.RdbmsResultSet;
import com.tridium.rdb.jdbc.trans.BColumnTranslator;
import com.tridium.rdb.jdbc.trans.BSqlType;
import java.sql.Date;
import java.sql.Timestamp;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDate;
import javax.baja.sys.BMonth;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BDateTranslator
extends BColumnTranslator {
    public static final Type TYPE = Sys.loadType(BDateTranslator.class);

    public BDateTranslator(RdbmsDialect dialect, BValue defaultValue) {
        super(dialect, defaultValue);
    }

    @Override
    public BSqlType getSqlType() {
        return BSqlType.sqlDate;
    }

    @Override
    public void setPreparedStatementValue(RdbmsPreparedStatement prep, int index, BValue value, Context context) {
        BDate date = (BDate)value;
        BAbsTime time = BAbsTime.make((int)date.getYear(), (BMonth)date.getMonth(), (int)date.getDay());
        if (this.getDialect().supportsDateType()) {
            prep.setDate(index, new Date(time.getMillis()));
        } else {
            prep.setTimestamp(index, new Timestamp(time.getMillis()));
        }
    }

    @Override
    public BValue getResultSetValue(RdbmsResultSet rs, int index, Context context) {
        if (this.getDialect().supportsDateType()) {
            return BDate.make((BAbsTime)BAbsTime.make((long)rs.getDate(index).getTime()));
        }
        return BDate.make((BAbsTime)BAbsTime.make((long)rs.getTimestamp(index).getTime()));
    }

    public Type getType() {
        return TYPE;
    }
}

