/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.jdbc.orm;

import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.rdb.jdbc.RdbmsResultSet;
import com.tridium.rdb.jdbc.orm.OrmTranslatorFactory;
import com.tridium.rdb.jdbc.trans.BColumnTranslator;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Type;

public class OrmColumn {
    private final String name;
    private BValue value;
    private final BColumnTranslator translator;

    public OrmColumn(RdbmsDialect dialect, String name, BValue value) {
        if (dialect == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.value = value;
        this.translator = OrmTranslatorFactory.get(dialect, value);
    }

    public OrmColumn(RdbmsDialect dialect, String name, Type valueType) {
        if (dialect == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (valueType == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.value = null;
        this.translator = OrmTranslatorFactory.get(dialect, (BValue)valueType.getInstance());
    }

    public String toString() {
        return "[OrmColumn name:" + this.name + ", translator:" + this.translator.getType() + ", value:" + this.value + "]";
    }

    public void setPreparedValue(RdbmsPreparedStatement prep, int index, BValue value) {
        this.translator.setPreparedStatementValue(prep, index, value, null);
    }

    public void setPreparedValue(RdbmsPreparedStatement prep, int index, BValue value, Context context) {
        this.translator.setPreparedStatementValue(prep, index, value, context);
    }

    public BValue getResultValue(RdbmsResultSet rs, int index) {
        return this.translator.getResultSetValue(rs, index, null);
    }

    public BValue getResultValue(RdbmsResultSet rs, int index, Context context) {
        return this.translator.getResultSetValue(rs, index, context);
    }

    public String getName() {
        return this.name;
    }

    public BValue getValue() {
        return this.value;
    }

    public BColumnTranslator getTranslator() {
        return this.translator;
    }

    public void setValue(BValue value) {
        this.value = value;
    }
}

