/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.fox;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.rdb.BResultSetTable;
import com.tridium.rdb.fox.BSqlSchemeResultEncoder;
import java.io.DataInput;
import java.io.DataInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.DataTypes;
import javax.baja.io.BIEncodable;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.rdb.sql.BSqlScheme;
import javax.baja.rdb.sql.SqlQuery;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BTypeSpec;

@NiagaraType
public class BSqlSchemeChannel
extends BFoxChannel {
    public static final Type TYPE = Sys.loadType(BSqlSchemeChannel.class);
    public static final Logger LOG = Logger.getLogger("rdb");
    public static final String CHANNEL_NAME = "sql";

    public Type getType() {
        return TYPE;
    }

    public BSqlSchemeChannel() {
        super("rdb");
    }

    public FoxResponse process(FoxRequest req) throws Throwable {
        throw new InvalidCommandException(req.command);
    }

    public void circuitOpened(FoxCircuit circuit) throws Exception {
        String command = circuit.command;
        if (command == "resolve") {
            this.resolve(circuit);
            return;
        }
        throw new InvalidCommandException(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrdTarget resolve(OrdTarget base) throws Exception {
        try (FoxCircuit circuit = this.openCircuit("resolve");){
            FoxMessage req = new FoxMessage();
            req.add("base", base.getOrd().toString());
            circuit.writeMessage(req);
            circuit.flush();
            FoxMessage resp = circuit.readMessage();
            if (resp.getString("exception", null) != null) {
                Exception e = Fox.exceptionTranslator.messageToException(resp);
                throw e;
            }
            boolean resolved = resp.getBoolean("resolved", false);
            if (!resolved) {
                String msg = "Could not resolve " + base;
                throw new UnresolvedException(msg);
            }
            DataInputStream in = new DataInputStream(circuit.getInputStream());
            Array rows = new Array(BComponent.class);
            int colCount = in.readInt();
            if (colCount > 0) {
                String[] colNames = new String[colCount];
                int[] typeSymbols = new int[colCount];
                Type[] colTypes = new Type[colCount];
                for (int ci = 0; ci < colCount; ++ci) {
                    colNames[ci] = in.readUTF();
                    typeSymbols[ci] = in.readInt();
                    if (typeSymbols[ci] == 0) {
                        String dataType = in.readUTF();
                        colTypes[ci] = BTypeSpec.make((String)dataType).getResolvedType();
                        continue;
                    }
                    colTypes[ci] = DataTypes.getBySymbol((char)((char)typeSymbols[ci]));
                }
                boolean done = false;
                while (!done) {
                    BComponent row = new BComponent();
                    for (int col = 0; col < colCount; ++col) {
                        BIEncodable decodable = (BIEncodable)colTypes[col].getInstance();
                        row.add(colNames[col], (BValue)decodable.decode((DataInput)in), null);
                    }
                    rows.add((Object)row);
                    done = in.readBoolean();
                }
            }
            BResultSetTable result = new BResultSetTable((BComponent[])rows.trim());
            OrdTarget ordTarget = new OrdTarget(base, result);
            return ordTarget;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolve(FoxCircuit circuit) throws Exception {
        FoxMessage req = circuit.readMessage();
        String ordBaseText = req.getString("base");
        if (ordBaseText == null) {
            circuit.writeMessage(BSqlSchemeChannel.unresolved());
            circuit.flush();
            return;
        }
        BOrd ord = BOrd.make((String)ordBaseText).getOrd().relativizeToSession();
        OrdQuery[] parts = ord.parse();
        int sqlSchemeIndex = 2;
        for (int p = 1; p < parts.length; ++p) {
            OrdQuery part = parts[p];
            if (!(part instanceof SqlQuery)) continue;
            sqlSchemeIndex = p;
            break;
        }
        BOrd dbOrd = ord.getSubOrd(0, sqlSchemeIndex);
        BUser user = circuit.session().getUser();
        OrdTarget db = user == null ? dbOrd.resolve() : dbOrd.resolve((BObject)user);
        BSqlSchemeResultEncoder encoder = new BSqlSchemeResultEncoder();
        try {
            encoder.init(circuit);
            BSqlScheme.INSTANCE.resolve(encoder, db, parts[sqlSchemeIndex]);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getLocalizedMessage(), e);
            if (!encoder.isResolved()) {
                circuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)e));
            }
            circuit.flush();
            return;
        }
        finally {
            encoder.destroy();
        }
    }

    private static FoxMessage unresolved() {
        return BSqlSchemeChannel.unresolved(null);
    }

    private static FoxMessage unresolved(String msg) {
        FoxMessage m = new FoxMessage();
        m.add("resolved", false);
        if (msg != null) {
            m.add("msg", msg);
        }
        return m;
    }
}

