/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.baja.driver.BDevice;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.BRdbmsNetwork;
import javax.baja.security.dashboard.BISecurityDashboardProviderAgent;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.security.dashboard.SecurityDashboardItemBuilder;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"rdb:RdbmsNetwork"})})
public final class BRdbmsSecurityDashboardProviderAgent
extends BObject
implements BISecurityDashboardProviderAgent {
    public static final Type TYPE = Sys.loadType(BRdbmsSecurityDashboardProviderAgent.class);
    private static final int SECURITY_DASHBOARD_ITEMS_VERSION = 1;
    private SecurityDashboardItemBuilder builder;
    private BRdbmsNetwork network;
    private String SECTION_HEADER = "securityDashboard.rdbmsNetwork.sectionHeader";
    private String TLS_ENABLED_SUMMARY = "securityDashboard.rdbmsNetwork.tls.enabled.summary";
    private String TLS_DISABLED_SUMMARY = "securityDashboard.rdbmsNetwork.tls.disabled.summary";
    private String TLS_DESCRIPTION = "securityDashboard.rdbmsNetwork.tls.description";

    public Type getType() {
        return TYPE;
    }

    public void setSecurityDashboardItemsSource(BIObject object) {
        this.network = (BRdbmsNetwork)object;
        this.builder = new SecurityDashboardItemBuilder((BIObject)this);
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make((Type)TYPE, (String)this.SECTION_HEADER);
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return this.network.getNavOrd().relativizeToSession();
    }

    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        items.addAll(this.getEncryptionStatus(cx));
        return Collections.unmodifiableList(items);
    }

    private List<SecurityDashboardItem> getEncryptionStatus(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        List children = this.network.getBDeviceList();
        ArrayList<String> dbEnabledNames = new ArrayList<String>();
        ArrayList<String> dbDisabledNames = new ArrayList<String>();
        for (BDevice child : children) {
            BRdbms device = (BRdbms)child;
            if (device.getUseEncryptedConnection()) {
                dbEnabledNames.add(device.getDisplayName(cx));
                continue;
            }
            dbDisabledNames.add(device.getDisplayName(cx));
        }
        if (dbEnabledNames.size() > 0) {
            items.add(this.builder.makeOk().withSummary(this.TLS_ENABLED_SUMMARY, new Object[]{String.join((CharSequence)", ", dbEnabledNames)}).withDescription(this.TLS_DESCRIPTION, new Object[0]));
        }
        if (dbDisabledNames.size() > 0) {
            items.add(this.builder.makeAlert().withSummary(this.TLS_DISABLED_SUMMARY, new Object[]{String.join((CharSequence)", ", dbDisabledNames)}).withDescription(this.TLS_DESCRIPTION, new Object[0]));
        }
        return items;
    }
}

