/*
 * Decompiled with CFR 0.152.
 */
package tools.net.sourceforge.jtds.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

class DumpThread
extends Thread {
    private Socket client;
    private Socket server;
    private byte[] buf = new byte[4096];

    DumpThread(Socket client) {
        this.client = client;
    }

    String hex(int value, int len) {
        String res = Integer.toHexString(value);
        while (res.length() < len) {
            res = '0' + res;
        }
        return res.toUpperCase();
    }

    String packetType(int value) {
        switch (value) {
            case 1: {
                return "4.2 or 7.0 query";
            }
            case 2: {
                return "4.2 or 7.0 login packet";
            }
            case 4: {
                return "Server response";
            }
            case 6: {
                return "Cancel";
            }
            case 15: {
                return "5.0 query";
            }
            case 16: {
                return "7.0 login packet";
            }
        }
        return "Unknown (0x" + this.hex(value, 2) + ')';
    }

    int passByte(InputStream in, OutputStream out) throws IOException {
        int res = in.read();
        out.write(res);
        return res;
    }

    void skip(int len, InputStream in, OutputStream out) throws IOException {
        while (len > 0) {
            int rd = in.read(this.buf, 0, len > this.buf.length ? this.buf.length : len);
            out.write(this.buf, 0, rd);
            len -= rd;
        }
    }

    boolean nextPacket(InputStream in, OutputStream out) throws IOException {
        int type = this.passByte(in, out);
        int last = this.passByte(in, out);
        int size = this.passByte(in, out) << 8 | this.passByte(in, out);
        this.buf[0] = (byte)this.passByte(in, out);
        this.buf[1] = (byte)this.passByte(in, out);
        this.buf[2] = (byte)this.passByte(in, out);
        this.buf[3] = (byte)this.passByte(in, out);
        System.out.println("Packet type: " + this.packetType(type));
        System.out.println("Packet size: " + size + " (0x" + this.hex(size, 4) + ")");
        System.out.print("Rest of header:");
        for (int i = 0; i < 4; ++i) {
            System.out.print(" 0x" + this.hex(this.buf[i] & 0xFF, 2));
        }
        System.out.println();
        this.skip(size - 8, in, out);
        return last == 0;
    }

    @Override
    public void run() {
        try {
            this.server = new Socket("server", 1433);
            InputStream cIn = this.client.getInputStream();
            OutputStream cOut = this.client.getOutputStream();
            InputStream sIn = this.server.getInputStream();
            OutputStream sOut = this.server.getOutputStream();
            while (true) {
                if (this.nextPacket(cIn, sOut)) {
                    continue;
                }
                System.out.println("--- Client done. ---\n");
                while (this.nextPacket(sIn, cOut)) {
                }
                System.out.println("--- Server done. ---\n");
            }
        }
        catch (IOException ex) {
            try {
                this.client.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.server.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.out.println("Disconnected.");
            return;
        }
    }
}

