/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarmOrion;

import com.tridium.alarmOrion.OrionObjectCache;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.PropertyValue;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmService;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BOrionAlarmClass
extends BOrionObject {
    public static final Property id = BOrionAlarmClass.newProperty((int)9, (int)-1, (BFacets)ID_KEY);
    public static final Property alarmClass = BOrionAlarmClass.newProperty((int)8, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"unique", (boolean)true), (BFacets)BFacets.make((String)"width", (int)64)));
    public static final Property unackedAlarmCount = BOrionAlarmClass.newProperty((int)8, (int)0, null);
    public static final Property openAlarmCount = BOrionAlarmClass.newProperty((int)8, (int)0, null);
    public static final Property inAlarmCount = BOrionAlarmClass.newProperty((int)8, (int)0, null);
    public static final Property totalAlarmCount = BOrionAlarmClass.newProperty((int)8, (int)0, null);
    public static final Property timeOfLastAlarm = BOrionAlarmClass.newProperty((int)8, (BValue)BAbsTime.NULL, null);
    public static final Type TYPE = Sys.loadType(BOrionAlarmClass.class);
    public static final OrionType ORION_TYPE = (OrionType)TYPE;
    private static OrionObjectCache cache = new OrionObjectCache(100);

    public int getId() {
        return this.getInt(id);
    }

    public void setId(int v) {
        this.setInt(id, v, null);
    }

    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    public void setAlarmClass(String v) {
        this.setString(alarmClass, v, null);
    }

    public int getUnackedAlarmCount() {
        return this.getInt(unackedAlarmCount);
    }

    public void setUnackedAlarmCount(int v) {
        this.setInt(unackedAlarmCount, v, null);
    }

    public int getOpenAlarmCount() {
        return this.getInt(openAlarmCount);
    }

    public void setOpenAlarmCount(int v) {
        this.setInt(openAlarmCount, v, null);
    }

    public int getInAlarmCount() {
        return this.getInt(inAlarmCount);
    }

    public void setInAlarmCount(int v) {
        this.setInt(inAlarmCount, v, null);
    }

    public int getTotalAlarmCount() {
        return this.getInt(totalAlarmCount);
    }

    public void setTotalAlarmCount(int v) {
        this.setInt(totalAlarmCount, v, null);
    }

    public BAbsTime getTimeOfLastAlarm() {
        return (BAbsTime)this.get(timeOfLastAlarm);
    }

    public void setTimeOfLastAlarm(BAbsTime v) {
        this.set(timeOfLastAlarm, (BValue)v, null);
    }

    public Type getType() {
        return this.getTypeFromSpace(TYPE);
    }

    public static BOrionAlarmClass get(String alarmClassName, OrionSession session) {
        BOrionAlarmClass alarmClass;
        if (cache.contains(alarmClassName)) {
            return (BOrionAlarmClass)cache.get(alarmClassName);
        }
        OrionCursor cursor = session.select(ORION_TYPE, new PropertyValue(BOrionAlarmClass.alarmClass, (BValue)BString.make((String)alarmClassName)));
        if (cursor.next()) {
            alarmClass = (BOrionAlarmClass)((Object)cursor.get());
            cursor.close();
        } else {
            alarmClass = new BOrionAlarmClass();
            alarmClass.setAlarmClass(alarmClassName);
            session.insert((BIOrionObject)alarmClass);
        }
        cache.put(alarmClassName, (BIOrionObject)alarmClass);
        return alarmClass;
    }

    public void afterDelete(OrionSession session) {
        cache.remove(this.getAlarmClass());
    }

    public void afterInsert(OrionSession session) {
        cache.put(this.getAlarmClass(), (BIOrionObject)this);
        this.updateAlarmClass();
    }

    public void afterUpdate(OrionSession session) {
        cache.update(this.getAlarmClass(), (BIOrionObject)this);
        this.updateAlarmClass();
    }

    public void updateAlarmClass() {
        BAlarmService service = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BAlarmClass[] alarmClasses = service.getAlarmClasses();
        for (int i = 0; i < alarmClasses.length; ++i) {
            if (!alarmClasses[i].getName().equals(this.getAlarmClass())) continue;
            alarmClasses[i].setUnackedAlarmCount(this.getUnackedAlarmCount());
            alarmClasses[i].setOpenAlarmCount(this.getOpenAlarmCount());
            alarmClasses[i].setInAlarmCount(this.getInAlarmCount());
            alarmClasses[i].setTotalAlarmCount(this.getTotalAlarmCount());
            alarmClasses[i].setTimeOfLastAlarm(this.getTimeOfLastAlarm());
            break;
        }
    }
}

