/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarmOrion.transactions;

import com.tridium.alarmOrion.transactions.AlarmRecordTransaction;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.OrionSession;
import com.tridium.orion.sql.BatchStatement;
import java.io.IOException;
import java.util.logging.Level;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarmOrion.BOrionAlarmClass;
import javax.baja.alarmOrion.BOrionAlarmDatabase;
import javax.baja.alarmOrion.BOrionAlarmFacetValue;
import javax.baja.alarmOrion.BOrionAlarmRecord;
import javax.baja.alarmOrion.BOrionAlarmService;
import javax.baja.alarmOrion.BOrionAlarmSourceOrder;
import javax.baja.alarmOrion.OrionAlarmDbConnection;
import javax.baja.data.DataUtil;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ICoalesceable;

public class AppendAlarmRecord
extends AlarmRecordTransaction
implements ICoalesceable {
    protected BAlarmRecord alarmRecord;

    public AppendAlarmRecord(BAlarmRecord alarmRecord) {
        this.alarmRecord = alarmRecord;
    }

    public ICoalesceable coalesce(ICoalesceable c) {
        return c;
    }

    public Object getCoalesceKey() {
        return this.alarmRecord.getUuid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRun() {
        BOrionAlarmService service = (BOrionAlarmService)Sys.getService((Type)BOrionAlarmService.TYPE);
        BOrionAlarmDatabase database = (BOrionAlarmDatabase)service.getAlarmDb();
        Object object = database.exclusiveAccessMutex;
        synchronized (object) {
            OrionSession session = null;
            try (OrionAlarmDbConnection conn = (OrionAlarmDbConnection)database.getDbConnection(null);){
                session = conn.getOrionSession();
                session.setAutoCommit(false);
                BOrionAlarmRecord orionNewAlarm = BOrionAlarmRecord.make(this.alarmRecord, session);
                session.insert((BIOrionObject)orionNewAlarm);
                BOrdList alarmSource = this.alarmRecord.getSource();
                BatchStatement inserter = session.batchInsert(BOrionAlarmSourceOrder.ORION_TYPE);
                for (int i = 0; i < alarmSource.size(); ++i) {
                    BOrionAlarmSourceOrder orionAlarmSource = BOrionAlarmSourceOrder.make(alarmSource.get(i), i, orionNewAlarm, session);
                    inserter.add((BIOrionObject)orionAlarmSource);
                }
                inserter.execute();
                BFacets alarmFacets = this.alarmRecord.getAlarmData();
                String[] facetKeys = alarmFacets.list();
                BatchStatement inserter2 = session.batchInsert(BOrionAlarmFacetValue.ORION_TYPE);
                for (int i = 0; i < facetKeys.length; ++i) {
                    BObject value = alarmFacets.get(facetKeys[i]);
                    try {
                        String encodedValue;
                        try {
                            encodedValue = DataUtil.marshal((BObject)value);
                        }
                        catch (IOException ioe) {
                            throw new BajaRuntimeException("Facet " + facetKeys[i] + " can not be marshalled.", (Throwable)ioe);
                        }
                        if (encodedValue.length() > BOrionAlarmFacetValue.value.getFacets().geti("width", 0)) {
                            BOrionAlarmService.logger.warning("Facet " + facetKeys[i] + " too big, " + encodedValue.length() + ">" + BOrionAlarmFacetValue.value.getFacets().geti("width", 0));
                            continue;
                        }
                        BOrionAlarmFacetValue orionAlarmData = BOrionAlarmFacetValue.make(facetKeys[i], encodedValue, orionNewAlarm, session);
                        inserter2.add((BIOrionObject)orionAlarmData);
                        continue;
                    }
                    catch (Exception e) {
                        if (!BOrionAlarmService.logger.isLoggable(Level.FINE)) continue;
                        BOrionAlarmService.logger.log(Level.WARNING, "Unable to save alarm facet", e);
                    }
                }
                inserter2.execute();
                BOrionAlarmClass alarmClass = orionNewAlarm.resolveAlarmClass(session);
                alarmClass.setTotalAlarmCount(alarmClass.getTotalAlarmCount() + 1);
                if (!this.alarmRecord.isAcknowledged()) {
                    alarmClass.setUnackedAlarmCount(alarmClass.getUnackedAlarmCount() + 1);
                }
                if (!this.alarmRecord.isNormal()) {
                    alarmClass.setInAlarmCount(alarmClass.getInAlarmCount() + 1);
                }
                if (this.alarmRecord.isOpen()) {
                    alarmClass.setOpenAlarmCount(alarmClass.getOpenAlarmCount() + 1);
                }
                alarmClass.setTimeOfLastAlarm(BAbsTime.now());
                if (alarmClass.getTimeOfLastAlarm().isBefore(this.alarmRecord.getTimestamp())) {
                    alarmClass.setTimeOfLastAlarm(this.alarmRecord.getTimestamp());
                }
                session.update((BIOrionObject)alarmClass);
                session.commit();
            }
            catch (RuntimeException e) {
                if (session != null) {
                    session.rollback();
                }
                BOrionAlarmDatabase.log.log(Level.SEVERE, "Unable to append alarm " + this.alarmRecord.getUuid(), e);
            }
        }
    }
}

