/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarmOrion.conversion.rdb;

import com.tridium.alarm.BTextOp;
import com.tridium.alarmOrion.conversion.BAlarmConversion;
import com.tridium.alarmOrion.conversion.BAlarmConversionJob;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.model.BDynamicOrionObject;
import com.tridium.orion.priv.model.DynamicOrionProperty;
import com.tridium.orion.priv.model.DynamicOrionType;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BSourceState;
import javax.baja.alarmOrion.BOrionAlarmDatabase;
import javax.baja.alarmOrion.BOrionAlarmService;
import javax.baja.alarmOrion.OrionAlarmDbConnection;
import javax.baja.data.BIDataValue;
import javax.baja.job.JobLogItem;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.Queue;

public class BRdbAlarmConversionJob
extends BAlarmConversionJob {
    public static final Type TYPE = Sys.loadType(BRdbAlarmConversionJob.class);
    private boolean running = true;
    private static final Property timestamp = new DynamicOrionProperty("TIMESTAMP", BString.TYPE, (BValue)BString.DEFAULT, BFacets.DEFAULT, 0);
    private static final Property uuid = new DynamicOrionProperty("UUID", BString.TYPE, (BValue)BString.DEFAULT, BFacets.DEFAULT, 0);
    private static final Property sourceState = new DynamicOrionProperty("SOURCESTATE", BString.TYPE, (BValue)BString.DEFAULT, BFacets.DEFAULT, 0);
    private static final Property ackState = new DynamicOrionProperty("ACKSTATE", BString.TYPE, (BValue)BString.DEFAULT, BFacets.DEFAULT, 0);
    private static final Property ackRequired = new DynamicOrionProperty("ACKREQUIRED", BBoolean.TYPE, (BValue)BBoolean.DEFAULT, BFacets.DEFAULT, 0);
    private static final Property source = new DynamicOrionProperty("SOURCE", BString.TYPE, (BValue)BString.DEFAULT, BFacets.DEFAULT, 0);
    private static final Property alarmClass = new DynamicOrionProperty("ALARMCLASS", BString.TYPE, (BValue)BString.DEFAULT, BFacets.DEFAULT, 0);
    private static final Property priority = new DynamicOrionProperty("PRIORITY", BInteger.TYPE, (BValue)BInteger.DEFAULT, BFacets.DEFAULT, 0);
    private static final Property normalTime = new DynamicOrionProperty("NORMALTIME", BString.TYPE, (BValue)BString.DEFAULT, BFacets.DEFAULT, 0);
    private static final Property ackTime = new DynamicOrionProperty("ACKTIME", BString.TYPE, (BValue)BString.DEFAULT, BFacets.DEFAULT, 0);
    private static final Property user = new DynamicOrionProperty("USER", BString.TYPE, (BValue)BString.DEFAULT, BFacets.DEFAULT, 0);
    private static final Property alarmData = new DynamicOrionProperty("ALARMDATA", BString.TYPE, (BValue)BString.DEFAULT, BFacets.DEFAULT, 0);
    private static final Property alarmTransition = new DynamicOrionProperty("ALARMTRANSITION", BString.TYPE, (BValue)BString.DEFAULT, BFacets.DEFAULT, 0);
    private static final Property lastUpdate = new DynamicOrionProperty("LASTUPDATE", BString.TYPE, (BValue)BString.DEFAULT, BFacets.DEFAULT, 0);
    private static final DynamicOrionType dynamicOrionType = DynamicOrionType.makeTemporary((Property[])new Property[]{timestamp, uuid, sourceState, ackState, ackRequired, source, alarmClass, priority, normalTime, ackTime, user, alarmData, alarmTransition, lastUpdate});
    private BAlarmConversion conversion;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BRdbAlarmConversionJob() {
    }

    public BRdbAlarmConversionJob(BAlarmConversion conversion) {
        this.conversion = conversion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(Context cx) {
        service = (BOrionAlarmService)Sys.getService((Type)BOrionAlarmService.TYPE);
        database = (BOrionAlarmDatabase)service.getAlarmDb();
        orionConn = (OrionAlarmDbConnection)database.getDbConnection(cx);
        var5_5 = null;
        try {
            session = orionConn.getOrionSession();
            queue = (Queue)service.fw(601);
            this.log().start("Conversion started");
            this.recordsConverted = 0.0;
            this.recordsFailed = 0.0;
            this.running = true;
            try {
                conn = database.getDbConnection(cx);
                var9_11 = null;
                try {
                    block88: {
                        block85: {
                            block86: {
                                block87: {
                                    countRecordType = DynamicOrionType.makeTemporary((Property[])new Property[]{new DynamicOrionProperty("recordCount", BInteger.TYPE, (BValue)BInteger.DEFAULT, BFacets.DEFAULT, 0)});
                                    countCursor = session.select((OrionType)countRecordType, "SELECT count(1) AS recordCount FROM AlarmRecord");
                                    var12_19 = null;
                                    if (countCursor.next()) break block85;
                                    this.recordsConverted = 0.0;
                                    this.recordsFailed = 0.0;
                                    this.recordsTotal = 0.0;
                                    this.failed((Throwable)new BajaRuntimeException("No data found to convert."));
                                    if (countCursor == null) break block86;
                                    if (var12_19 == null) break block87;
                                    try {
                                        countCursor.close();
                                    }
                                    catch (Throwable var13_20) {
                                        var12_19.addSuppressed(var13_20);
                                    }
                                    break block86;
                                }
                                countCursor.close();
                            }
                            if (conn == null) return;
                            if (var9_11 != null) {
                                try {
                                    conn.close();
                                    return;
                                }
                                catch (Throwable var13_21) {
                                    var9_11.addSuppressed(var13_21);
                                    return;
                                }
                            }
                            conn.close();
                            return;
                        }
                        try {
                            this.recordsTotal = ((BInteger)((BIOrionObject)countCursor.get()).get("recordCount")).getDouble();
                            this.log().message("Discovered " + (int)this.recordsTotal + " records for conversion");
                            {
                                formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSSSS");
                                cursor = session.select((OrionType)BRdbAlarmConversionJob.dynamicOrionType, "SELECT * FROM AlarmRecord");
                                var12_19 = null;
                                break block88;
                                catch (Throwable var13_25) {
                                    var12_19 = var13_25;
                                    throw var13_25;
                                }
                                catch (Throwable var14_29) {
                                    throw var14_29;
                                }
                                ** finally { 
lbl61:
                                // 1 sources

                                if (countCursor != null) {
                                    if (var12_19 != null) {
                                        try {
                                            countCursor.close();
                                        }
                                        catch (Throwable var13_24) {
                                            var12_19.addSuppressed(var13_24);
                                        }
                                    } else {
                                        countCursor.close();
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            this.recordsConverted = 0.0;
                            this.recordsFailed = 0.0;
                            this.recordsTotal = 0.0;
                            this.failed((Throwable)new BajaRuntimeException("Unable to count rdb alarm records.", (Throwable)e));
                            if (conn != null) {
                                if (var9_11 != null) {
                                    try {
                                        conn.close();
                                    }
                                    catch (Throwable countCursor) {
                                        var9_11.addSuppressed(countCursor);
                                    }
                                } else {
                                    conn.close();
                                }
                            }
                            session.close();
                            if (orionConn == null) return;
                            if (var5_5 == null) {
                                orionConn.close();
                                return;
                            }
                            try {
                                orionConn.close();
                                return;
                            }
                            catch (Throwable countCursor) {
                                var5_5.addSuppressed(countCursor);
                                return;
                            }
                        }
                    }
                    try {
                        while (cursor.next() != false) {
                            if (this.running == false) return;
                            record = new BAlarmRecord(BUuid.DEFAULT);
                            rdbRecord = (BDynamicOrionObject)cursor.get();
                            this.progress();
                            try {
                                record.setTimestamp(BAbsTime.make((long)formatter.parse(rdbRecord.get(BRdbAlarmConversionJob.timestamp).toString()).getTime()));
                                record.setUuid(BUuid.make((String)rdbRecord.get(BRdbAlarmConversionJob.uuid).toString()));
                                record.setSourceState(BSourceState.make((String)rdbRecord.get(BRdbAlarmConversionJob.sourceState).toString()));
                                record.setAckState(BAckState.make((String)rdbRecord.get(BRdbAlarmConversionJob.ackState).toString()));
                                record.setAckRequired(((BBoolean)rdbRecord.get(BRdbAlarmConversionJob.ackRequired)).getBoolean());
                                record.setSource(BOrdList.make((String)rdbRecord.get(BRdbAlarmConversionJob.source).toString()));
                                record.setAlarmClass(rdbRecord.get(BRdbAlarmConversionJob.alarmClass).toString());
                                record.setPriority(((BInteger)rdbRecord.get(BRdbAlarmConversionJob.priority)).getInt());
                                record.setNormalTime(BAbsTime.make((long)formatter.parse(rdbRecord.get(BRdbAlarmConversionJob.normalTime).toString()).getTime()));
                                record.setAckTime(BAbsTime.make((long)formatter.parse(rdbRecord.get(BRdbAlarmConversionJob.ackTime).toString()).getTime()));
                                record.setUser(rdbRecord.get(BRdbAlarmConversionJob.user).toString());
                                record.setAlarmData(BFacets.make((String)rdbRecord.get(BRdbAlarmConversionJob.alarmData).toString()));
                                record.setAlarmTransition(BSourceState.make((String)rdbRecord.get(BRdbAlarmConversionJob.alarmTransition).toString()));
                                if (this.conversion.getChangeLastUpdated()) {
                                    record.setLastUpdate(Clock.time());
                                } else {
                                    record.setLastUpdate(BAbsTime.make((long)formatter.parse(rdbRecord.get(BRdbAlarmConversionJob.lastUpdate).toString()).getTime()));
                                }
                                alarmClass = this.conversion.getAlarmClass();
                                if (alarmClass != null && !alarmClass.equals("")) {
                                    record.setAlarmClass(SlotPath.escape((String)TextUtil.replace((String)alarmClass, (String)"%alarmClass%", (String)SlotPath.unescape((String)record.getAlarmClass()))));
                                }
                                if ((sourceName = (BString)record.getAlarmData().get("sourceName")) != null) {
                                    newName = this.conversion.getSourceName().customize(sourceName.toString());
                                    record.setAlarmData(BFacets.make((BFacets)record.getAlarmData(), (String)"sourceName", (BIDataValue)BString.make((String)newName)));
                                } else if (this.conversion.getSourceName().getOp() == BTextOp.replace) {
                                    newName = this.conversion.getSourceName().customize("");
                                    record.setAlarmData(BFacets.make((BFacets)record.getAlarmData(), (String)"sourceName", (BIDataValue)BString.make((String)newName)));
                                }
                                conn.update(record);
                                try {
                                    while (queue.size() > 250) {
                                        Thread.sleep(1000L);
                                    }
                                }
                                catch (InterruptedException alarmClass) {
                                    // empty catch block
                                }
                                this.recordsConverted += 1.0;
                            }
                            catch (IOException e) {
                                this.log().add(new JobLogItem(0, e.getMessage(), (Throwable)e));
                                this.recordsFailed += 1.0;
                            }
                            catch (ParseException e) {
                                this.log().add(new JobLogItem(0, e.getMessage(), (Throwable)e));
                                this.recordsFailed += 1.0;
                            }
                        }
                        return;
                    }
                    catch (Throwable var13_28) {
                        var12_19 = var13_28;
                        throw var13_28;
                    }
                    finally {
                        if (cursor != null) {
                            if (var12_19 != null) {
                                try {
                                    cursor.close();
                                }
                                catch (Throwable var13_27) {
                                    var12_19.addSuppressed(var13_27);
                                }
                            } else {
                                cursor.close();
                            }
                        }
                    }
                }
                catch (Throwable var10_15) {
                    var9_11 = var10_15;
                    throw var10_15;
                }
                catch (Throwable var20_40) {
                    throw var20_40;
                }
            }
            finally {
                session.close();
            }
        }
        catch (Throwable var6_8) {
            var5_5 = var6_8;
            throw var6_8;
        }
        finally {
            if (orionConn != null) {
                if (var5_5 != null) {
                    try {
                        orionConn.close();
                    }
                    catch (Throwable var13_23) {
                        var5_5.addSuppressed(var13_23);
                    }
                } else {
                    orionConn.close();
                }
            }
        }
    }

    public void doCancel(Context cx) {
        this.running = false;
    }
}

