/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarmOrion.conversion;

import com.tridium.alarmOrion.conversion.BAlarmConversion;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.job.JobLogItem;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BAlarmConversionJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BAlarmConversionJob.class);
    protected double recordsConverted = 0.0;
    protected double recordsFailed = 0.0;
    protected double recordsTotal = 0.0;

    public Type getType() {
        return TYPE;
    }

    public BAlarmConversionJob() {
    }

    public BAlarmConversionJob(BAlarmConversion conversion) {
    }

    public void doRun() {
        try {
            ((BJob)this.getType().getInstance()).submit(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void progress() {
        this.progress((int)((this.getSucceeded() + this.getFailed()) / this.recordsTotal * 100.0));
    }

    public void success() {
        this.log().success("Conversion Success [" + (int)this.getSucceeded() + " converted, " + (int)this.getFailed() + " failed]");
        this.complete(BJobState.success);
    }

    public void canceled() {
        this.log().add(new JobLogItem(2, "Conversion Canceled [" + (int)this.getSucceeded() + " converted, " + (int)this.getFailed() + " failed]"));
        this.complete(BJobState.canceled);
    }

    public void failed(Throwable cause) {
        if (this.getJobState() == BJobState.canceling || cause instanceof InterruptedException || cause instanceof JobCancelException) {
            this.canceled();
            return;
        }
        this.log().failed("Conversion Failed [" + (int)this.getSucceeded() + " converted, " + (int)this.getFailed() + " failed]", cause);
        this.complete(BJobState.failed);
    }

    public double getRemaining() {
        return this.recordsTotal - (this.recordsConverted + this.recordsFailed);
    }

    public double getSucceeded() {
        return this.recordsConverted;
    }

    public double getFailed() {
        return this.recordsFailed;
    }
}

