/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarmOrion.conversion;

import com.tridium.alarm.BTextCustomizer;
import com.tridium.alarm.BTextOp;
import com.tridium.alarmOrion.conversion.BAlarmConversionJob;
import javax.baja.alarmOrion.BOrionAlarmService;
import javax.baja.data.BIDataValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

public abstract class BAlarmConversion
extends BComponent {
    public static final Property running = BAlarmConversion.newProperty((int)11, (boolean)false, null);
    public static final Property remaining = BAlarmConversion.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"precision", (int)0));
    public static final Property succeeded = BAlarmConversion.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"precision", (int)0));
    public static final Property failed = BAlarmConversion.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"precision", (int)0));
    public static final Property alarmClass = BAlarmConversion.newProperty((int)0, (String)"%alarmClass%", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:DeviceExtAlarmClassFE")));
    public static final Property sourceName = BAlarmConversion.newProperty((int)0, (BValue)new BTextCustomizer(BTextOp.useExisting, BFormat.make((String)"%displayName%:")), null);
    public static final Property changeLastUpdated = BAlarmConversion.newProperty((int)0, (boolean)false, null);
    public static final Action run = BAlarmConversion.newAction((int)0, null);
    public static final Action update = BAlarmConversion.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BAlarmConversion.class);
    private static final BIcon icon = BIcon.std((String)"fileConverter.png");
    private Clock.Ticket ticket;
    private BAlarmConversionJob job = null;

    public boolean getRunning() {
        return this.getBoolean(running);
    }

    public void setRunning(boolean v) {
        this.setBoolean(running, v, null);
    }

    public double getRemaining() {
        return this.getDouble(remaining);
    }

    public void setRemaining(double v) {
        this.setDouble(remaining, v, null);
    }

    public double getSucceeded() {
        return this.getDouble(succeeded);
    }

    public void setSucceeded(double v) {
        this.setDouble(succeeded, v, null);
    }

    public double getFailed() {
        return this.getDouble(failed);
    }

    public void setFailed(double v) {
        this.setDouble(failed, v, null);
    }

    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    public void setAlarmClass(String v) {
        this.setString(alarmClass, v, null);
    }

    public BTextCustomizer getSourceName() {
        return (BTextCustomizer)this.get(sourceName);
    }

    public void setSourceName(BTextCustomizer v) {
        this.set(sourceName, (BValue)v, null);
    }

    public boolean getChangeLastUpdated() {
        return this.getBoolean(changeLastUpdated);
    }

    public void setChangeLastUpdated(boolean v) {
        this.setBoolean(changeLastUpdated, v, null);
    }

    public void run() {
        this.invoke(run, null, null);
    }

    public void update() {
        this.invoke(update, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent.getType().is(BOrionAlarmService.TYPE);
    }

    protected abstract BAlarmConversionJob getAlarmConversionJob();

    public void doRun() {
        if (!this.isRunning()) {
            throw new BajaRuntimeException("Converter must be on alarm service to run.");
        }
        this.setRemaining(0.0);
        this.setSucceeded(0.0);
        this.setFailed(0.0);
        this.setRunning(true);
        this.job = this.getAlarmConversionJob();
        this.job.submit(null);
        Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)1), (Action)update, null);
        this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)3), (Action)update, null);
    }

    public void doUpdate() {
        if (!this.isRunning()) {
            throw new BajaRuntimeException("Converter must be on alarm service to run.");
        }
        if (this.job != null && this.job.isAlive()) {
            this.setRunning(true);
            this.setRemaining(this.job.getRemaining());
            this.setSucceeded(this.job.getSucceeded());
            this.setFailed(this.job.getFailed());
            if (!this.job.isAlive() && this.ticket != null && !this.ticket.isExpired()) {
                this.ticket.cancel();
            }
        } else {
            this.setRunning(false);
            this.setRemaining(0.0);
            this.setSucceeded(0.0);
            this.setFailed(0.0);
            if (this.ticket != null && !this.ticket.isExpired()) {
                this.ticket.cancel();
            }
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

