/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarmOrion;

import com.tridium.orion.BIOrionObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class OrionObjectCache {
    protected Map<Object, BIOrionObject> map = new HashMap<Object, BIOrionObject>();
    protected LinkedList<Object> list = new LinkedList();
    protected int maxSize;

    public OrionObjectCache() {
        this(16);
    }

    public OrionObjectCache(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getSize() {
        return this.list.size();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        Map<Object, BIOrionObject> map = this.map;
        synchronized (map) {
            while (this.list.size() > maxSize) {
                this.map.remove(this.list.getLast());
                this.list.removeLast();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object key, BIOrionObject object) {
        Map<Object, BIOrionObject> map = this.map;
        synchronized (map) {
            if (!this.map.containsKey(key)) {
                while (this.list.size() > this.maxSize) {
                    this.map.remove(this.list.getLast());
                    this.list.removeLast();
                }
                this.map.put(key, object);
                this.list.addFirst(key);
                return;
            }
        }
        this.update(key, object);
    }

    public void update(Object key, BIOrionObject object) {
        this.remove(key);
        this.put(key, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BIOrionObject get(Object key) {
        Map<Object, BIOrionObject> map = this.map;
        synchronized (map) {
            if (!this.map.containsKey(key)) {
                return null;
            }
            this.list.remove(key);
            this.list.addFirst(key);
        }
        return this.map.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BIOrionObject remove(Object key) {
        BIOrionObject obj;
        Map<Object, BIOrionObject> map = this.map;
        synchronized (map) {
            if (!this.map.containsKey(key)) {
                return null;
            }
            obj = this.map.get(key);
            this.list.remove(key);
            this.map.remove(key);
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Map<Object, BIOrionObject> map = this.map;
        synchronized (map) {
            this.map = new HashMap<Object, BIOrionObject>();
            this.list = new LinkedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object key) {
        Map<Object, BIOrionObject> map = this.map;
        synchronized (map) {
            return this.map.containsKey(key);
        }
    }
}

