/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sms.util;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.nre.util.TextUtil;
import javax.baja.util.Lexicon;

public final class SmsToolkit {
    public static final Logger log = Logger.getLogger("sms");
    private static final Lexicon lex = Lexicon.make(SmsToolkit.class);
    public static final HashMap<String, Integer> escapeCharHashTable = new HashMap();

    public static boolean isValidPhoneNumber(String phoneNumber) {
        char[] digits = SmsToolkit.removeSpaceCharacters(phoneNumber).toCharArray();
        if (digits.length == 0) {
            return false;
        }
        for (int i = 0; i < digits.length; ++i) {
            char d = digits[i];
            if (i == 0 && d == '+' || d == '0' || d == '1' || d == '2' || d == '3' || d == '4' || d == '5' || d == '6' || d == '7' || d == '8' || d == '9') continue;
            return false;
        }
        return true;
    }

    public static String removeSpaceCharacters(String phoneNumber) {
        phoneNumber = TextUtil.replace((String)phoneNumber, (String)" ", (String)"");
        phoneNumber = TextUtil.replace((String)phoneNumber, (String)"-", (String)"");
        phoneNumber = TextUtil.replace((String)phoneNumber, (String)".", (String)"");
        phoneNumber = TextUtil.replace((String)phoneNumber, (String)"(", (String)"");
        phoneNumber = TextUtil.replace((String)phoneNumber, (String)")", (String)"");
        phoneNumber = TextUtil.replace((String)phoneNumber, (String)",", (String)"");
        return phoneNumber;
    }

    public static byte[] filterForEscapeCharacters(String str) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Filtering this escape bytes: " + ByteArrayUtil.toHexString((byte[])str.getBytes(), (int)0, (int)str.getBytes().length));
        }
        ByteBuffer buff = new ByteBuffer(str.length());
        Integer currentInt = null;
        for (int i = 0; i < str.length(); ++i) {
            currentInt = escapeCharHashTable.get(String.valueOf(str.charAt(i)));
            if (currentInt != null) {
                buff.write((int)((byte)(0xFF & currentInt)));
                continue;
            }
            buff.write((int)((byte)(0xFF & str.charAt(i))));
        }
        byte[] retBytes = buff.toByteArray();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Filtered this escape bytes: " + ByteArrayUtil.toHexString((byte[])retBytes, (int)0, (int)retBytes.length) + " with length: " + retBytes.length);
        }
        return retBytes;
    }

    public static String getText(String lexStr) {
        return lex.getText(lexStr);
    }

    static {
        escapeCharHashTable.put("@", new Integer(0));
        escapeCharHashTable.put("\u00a3", new Integer(1));
        escapeCharHashTable.put("$", new Integer(2));
        escapeCharHashTable.put("\u00a5", new Integer(3));
        escapeCharHashTable.put("\u00e8", new Integer(4));
        escapeCharHashTable.put("\u00e9", new Integer(5));
        escapeCharHashTable.put("\u00f9", new Integer(6));
        escapeCharHashTable.put("\u00ec", new Integer(7));
        escapeCharHashTable.put("\u00f2", new Integer(8));
        escapeCharHashTable.put("\u00c7", new Integer(9));
        escapeCharHashTable.put("\u00d8", new Integer(11));
        escapeCharHashTable.put("\u00f8", new Integer(12));
        escapeCharHashTable.put("\u00c5", new Integer(14));
        escapeCharHashTable.put("\u00e5", new Integer(15));
        escapeCharHashTable.put("\u2206", new Integer(16));
        escapeCharHashTable.put("_", new Integer(17));
        escapeCharHashTable.put("\u0424", new Integer(18));
        escapeCharHashTable.put("\u0393", new Integer(19));
        escapeCharHashTable.put("\u039b", new Integer(20));
        escapeCharHashTable.put("\u03a9", new Integer(21));
        escapeCharHashTable.put("\u03c0", new Integer(22));
        escapeCharHashTable.put("\u03a8", new Integer(23));
        escapeCharHashTable.put("\u03a3", new Integer(24));
        escapeCharHashTable.put("\u0398", new Integer(25));
        escapeCharHashTable.put("\u039e", new Integer(26));
        escapeCharHashTable.put("\u00c6", new Integer(28));
        escapeCharHashTable.put("\u00e6", new Integer(29));
        escapeCharHashTable.put("\u00df", new Integer(30));
        escapeCharHashTable.put("\u00c8", new Integer(31));
        escapeCharHashTable.put("\u00c4", new Integer(91));
        escapeCharHashTable.put("\u00d6", new Integer(92));
        escapeCharHashTable.put("\u00d1", new Integer(93));
        escapeCharHashTable.put("\u00dc", new Integer(94));
        escapeCharHashTable.put("\u00a7", new Integer(95));
        escapeCharHashTable.put("\u00bf", new Integer(95));
        escapeCharHashTable.put("\u00e4", new Integer(123));
        escapeCharHashTable.put("\u00f6", new Integer(124));
        escapeCharHashTable.put("\u00f1", new Integer(125));
        escapeCharHashTable.put("\u00fc", new Integer(126));
        escapeCharHashTable.put("\u00e0", new Integer(127));
    }
}

