/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sms.serial;

import com.tridium.sms.BAbstractSmsTransport;
import com.tridium.sms.BSmsMessage;
import com.tridium.sms.BSmsService;
import com.tridium.sms.SmsException;
import com.tridium.sms.serial.CommTransaction;
import com.tridium.sms.serial.SmsCommReceiver;
import com.tridium.sms.serial.command.SmsCommand;
import com.tridium.sms.serial.command.SmsDeleteMessageCommand;
import com.tridium.sms.serial.command.SmsPingCommand;
import com.tridium.sms.serial.command.SmsReadMessagesCommand;
import com.tridium.sms.serial.command.SmsSendMsgCommand;
import com.tridium.sms.serial.command.SmsSignalStrengthCommand;
import com.tridium.sms.serial.command.SmsStartupCheckCommand;
import com.tridium.sms.util.SmsToolkit;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.serial.BISerialHelperParent;
import javax.baja.serial.BISerialPort;
import javax.baja.serial.BISerialService;
import javax.baja.serial.BSerialHelper;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public final class BSerialSmsTransport
extends BAbstractSmsTransport
implements BISerialHelperParent,
SmsCommand.ICommsImplementer {
    public static final Property serialPortConfig = BSerialSmsTransport.newProperty((int)0, (BValue)new BSerialHelper(), null);
    public static final Property responseTimeout = BSerialSmsTransport.newProperty((int)4, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    public static final Property interMessageDelay = BSerialSmsTransport.newProperty((int)0, (BValue)BRelTime.make((long)10L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.makeSeconds((int)1)));
    public static final Property deleteReadMessages = BSerialSmsTransport.newProperty((int)0, (boolean)true, null);
    public static final Action runStartupCommands = BSerialSmsTransport.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BSerialSmsTransport.class);
    private BISerialPort serialPort = null;
    private InputStream in = null;
    private OutputStream out = null;
    private Thread rxThread = null;
    private boolean active = false;
    private final SmsCommReceiver commReceiver = new SmsCommReceiver();
    private static final String CHAR_ENCODING = "ISO-8859-1";

    public BSerialHelper getSerialPortConfig() {
        return (BSerialHelper)this.get(serialPortConfig);
    }

    public void setSerialPortConfig(BSerialHelper v) {
        this.set(serialPortConfig, (BValue)v, null);
    }

    public BRelTime getResponseTimeout() {
        return (BRelTime)this.get(responseTimeout);
    }

    public void setResponseTimeout(BRelTime v) {
        this.set(responseTimeout, (BValue)v, null);
    }

    public BRelTime getInterMessageDelay() {
        return (BRelTime)this.get(interMessageDelay);
    }

    public void setInterMessageDelay(BRelTime v) {
        this.set(interMessageDelay, (BValue)v, null);
    }

    public boolean getDeleteReadMessages() {
        return this.getBoolean(deleteReadMessages);
    }

    public void setDeleteReadMessages(boolean v) {
        this.setBoolean(deleteReadMessages, v, null);
    }

    public void runStartupCommands() {
        this.invoke(runStartupCommands, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BSerialSmsTransport() {
        this.getSerialPortConfig().setSerialHelperParent((BISerialHelperParent)this);
    }

    @Override
    public void send(String phoneNumbers, String msg) throws SmsException {
        SmsSendMsgCommand cmd = new SmsSendMsgCommand(this, phoneNumbers, msg);
        if (!cmd.run()) {
            throw new SmsException(SmsToolkit.getText("serialSmsTransport.commandFailed") + ": " + cmd);
        }
    }

    @Override
    public void ping() throws SmsException {
        SmsPingCommand cmd = new SmsPingCommand(this);
        if (!cmd.run()) {
            this.reopenPort();
            cmd = new SmsPingCommand(this);
            if (!cmd.run()) {
                throw new SmsException(SmsToolkit.getText("service.pingFailed"));
            }
        }
    }

    @Override
    public double getSignalStrength() throws SmsException {
        double val = -1.0;
        SmsSignalStrengthCommand cmd = new SmsSignalStrengthCommand(this);
        boolean success = cmd.run();
        if (!success) {
            throw new SmsException(SmsToolkit.getText("serialSmsTransport.commandFailed") + ": " + cmd);
        }
        val = cmd.getSignalStrength();
        return val;
    }

    private BSmsService getService() {
        return (BSmsService)this.getParent();
    }

    public void started() throws Exception {
        if (Sys.isStationStarted()) {
            this.init();
        }
    }

    public void stationStarted() throws Exception {
        this.init();
    }

    private final void init() {
        this.reopenPort();
        if (SmsToolkit.log.isLoggable(Level.FINE)) {
            SmsToolkit.log.fine("Sms async thread started");
        }
    }

    public void stopped() {
        this.stopComm();
        if (SmsToolkit.log.isLoggable(Level.FINE)) {
            SmsToolkit.log.fine("Sms async thread stopped");
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        this.getService().getWorker().post((Runnable)new Invocation((BComponent)this, action, argument, cx));
        return null;
    }

    public synchronized void reopenPort() {
        if (!this.getService().isFatalFault()) {
            String newPort;
            if (SmsToolkit.log.isLoggable(Level.FINE)) {
                SmsToolkit.log.fine(this.getName() + " *** Restarting serial comm ***");
            }
            if ((newPort = this.getSerialPortConfig().getPortName()).equals("none")) {
                this.getService().pingFail(SmsToolkit.getText("transport.noPortSelected"));
                this.stopComm();
            } else {
                this.stopComm();
                this.startComm();
            }
        }
    }

    private synchronized void startComm() {
        try {
            BISerialService platSvc = (BISerialService)Sys.getService((Type)BISerialService.TYPE);
            this.serialPort = this.getSerialPortConfig().open(this.getService().getName());
            this.serialPort.enableReceiveTimeout(platSvc.getMinTimeout());
            this.in = this.serialPort.getInputStream();
            this.out = this.serialPort.getOutputStream();
            this.commReceiver.setInputStream(this.in);
            this.commReceiver.setCancelled(false);
            this.rxThread = new Thread((Runnable)this.commReceiver, "SerialRcv:" + this.getService().getName());
            this.rxThread.start();
            this.active = true;
            this.runStartupCommands();
            if (SmsToolkit.log.isLoggable(Level.FINE)) {
                SmsToolkit.log.fine("Started comms and read thread");
            }
        }
        catch (Exception e) {
            this.active = false;
            try {
                if (this.in != null) {
                    try {
                        this.in.close();
                        this.in = null;
                    }
                    catch (Exception x) {
                        SmsToolkit.log.log(Level.SEVERE, "Unable to close serial input stream.", x);
                    }
                }
                if (this.out != null) {
                    try {
                        this.out.close();
                        this.out = null;
                    }
                    catch (Exception x) {
                        SmsToolkit.log.log(Level.SEVERE, "Unable to close serial output stream.", x);
                    }
                }
                if (this.serialPort != null) {
                    this.serialPort.close();
                    this.serialPort = null;
                }
            }
            catch (Exception e2) {
                SmsToolkit.log.log(Level.SEVERE, "Fatal error shutting down serial port objects on start up!", e2);
            }
            SmsToolkit.log.log(Level.SEVERE, "Error starting the serial port", e);
            this.getService().pingFail(SmsToolkit.getText("transport.couldNotOpenPort"));
        }
    }

    private synchronized void stopComm() {
        this.active = false;
        try {
            if (this.rxThread != null) {
                this.commReceiver.setCancelled(true);
                this.rxThread.join();
                this.rxThread = null;
            }
            if (this.in != null) {
                try {
                    this.in.close();
                    this.in = null;
                }
                catch (Exception x) {
                    SmsToolkit.log.log(Level.SEVERE, "Unable to close serial input stream.", x);
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                    this.out = null;
                }
                catch (Exception x) {
                    SmsToolkit.log.log(Level.SEVERE, "Unable to close serial output stream.", x);
                }
            }
            if (this.serialPort != null) {
                this.serialPort.close();
                this.serialPort = null;
            }
        }
        catch (Exception e) {
            SmsToolkit.log.log(Level.SEVERE, "Error stopping the serial port", e);
            this.getService().pingFail(SmsToolkit.getText("transport.couldNotOpenPort"));
        }
    }

    @Override
    public synchronized boolean isCommsActive() {
        return this.active;
    }

    public void doRunStartupCommands() {
        if (!this.getService().isDisabled() && !this.getService().isFatalFault()) {
            SmsStartupCheckCommand cmd = new SmsStartupCheckCommand(this);
            if (cmd.run()) {
                this.getService().pingOk();
            } else {
                this.getService().pingFail(SmsToolkit.getText("serialSmsTransport.commandFailed") + ": " + cmd);
            }
        }
    }

    @Override
    public String write(String outStr, String inStr) throws IOException {
        return this.write(outStr, inStr, this.getResponseTimeout());
    }

    @Override
    public synchronized String write(String outStr, String inStr, BRelTime responseTimeout) throws IOException {
        if (this.out != null && this.rxThread != null && this.isRunning()) {
            CommTransaction t;
            block7: {
                if (SmsToolkit.log.isLoggable(Level.FINE)) {
                    SmsToolkit.log.fine("*** Writing: " + this.removeNewLines(outStr) + " attempting read: " + this.removeNewLines(inStr) + " ***");
                }
                t = new CommTransaction(inStr);
                this.commReceiver.setTransaction(t);
                this.out.write(outStr.getBytes(CHAR_ENCODING));
                int count = 0;
                while (!t.isCompleted() && (long)(count += t.waitForTransaction()) < responseTimeout.getMillis()) {
                }
                long delay = this.getInterMessageDelay().getMillis();
                if (delay > 0L) {
                    try {
                        this.wait(delay);
                    }
                    catch (InterruptedException e) {
                        if (!SmsToolkit.log.isLoggable(Level.FINE)) break block7;
                        SmsToolkit.log.fine("Interrupt exception thrown for write");
                    }
                }
            }
            if (t.isCompleted()) {
                return t.getRecStr();
            }
            throw new IOException("Sms command error! Did not get message!");
        }
        throw new IOException("Sms serial not open!");
    }

    private String removeNewLines(String s) {
        return s.replace('\n', ' ').replace('\r', ' ').replace('\t', ' ').trim();
    }

    @Override
    public BSmsMessage[] readMessages() throws SmsException {
        BSmsMessage[] msgs = new BSmsMessage[]{};
        if (!(this.getService().isDisabled() || this.getService().isFatalFault() || this.getService().isDown())) {
            SmsReadMessagesCommand cmd = new SmsReadMessagesCommand(this);
            if (cmd.run()) {
                msgs = cmd.getMessages();
                if (this.getDeleteReadMessages()) {
                    for (int i = 0; i < msgs.length; ++i) {
                        this.deleteMessage(msgs[i].getId());
                    }
                }
            } else {
                throw new SmsException(SmsToolkit.getText("serialSmsTransport.commandFailed") + ": " + cmd);
            }
        }
        return msgs;
    }

    private void deleteMessage(int id) throws SmsException {
        SmsDeleteMessageCommand cmd = new SmsDeleteMessageCommand(this, id);
        if (!cmd.run()) {
            throw new SmsException(SmsToolkit.getText("serialSmsTransport.commandFailed") + ": " + cmd);
        }
    }
}

