/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sms;

import com.tridium.sms.BSmsMessage;
import com.tridium.sms.BSmsService;
import com.tridium.sms.util.SmsToolkit;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatusString;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

public final class BSms
extends BComponent {
    public static final Property phoneNumbers = BSms.newProperty((int)8, (BValue)new BStatusString(), (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"sms:PhoneNumbersFE")));
    public static final Property defaultMessage = BSms.newProperty((int)0, (BValue)BFormat.make((String)"default message"), null);
    public static final Action sendDefaultMessage = BSms.newAction((int)16, null);
    public static final Action sendMessage = BSms.newAction((int)16, (BValue)BString.make((String)""), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Type TYPE = Sys.loadType(BSms.class);
    private static final BIcon icon = BIcon.make((String)"module://sms/res/sms.png");

    public BStatusString getPhoneNumbers() {
        return (BStatusString)this.get(phoneNumbers);
    }

    public void setPhoneNumbers(BStatusString v) {
        this.set(phoneNumbers, (BValue)v, null);
    }

    public BFormat getDefaultMessage() {
        return (BFormat)this.get(defaultMessage);
    }

    public void setDefaultMessage(BFormat v) {
        this.set(defaultMessage, (BValue)v, null);
    }

    public void sendDefaultMessage() {
        this.invoke(sendDefaultMessage, null, null);
    }

    public void sendMessage(BString arg) {
        this.invoke(sendMessage, (BValue)arg, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doSendDefaultMessage() {
        this.doSendMessage(BString.make((String)""));
    }

    public void doSendMessage(BString arg) {
        String newMsgStr = arg.getString();
        if (newMsgStr.length() <= 0) {
            newMsgStr = this.getDefaultMessage().format((Object)this);
        }
        BSms.sendSMSMessage(this.getPhoneNumbers().getValue(), newMsgStr);
    }

    public static void sendSMSMessage(String phoneNumbers, String message) {
        BSmsService service = BSmsService.getService();
        if (service != null) {
            if (SmsToolkit.log.isLoggable(Level.FINE)) {
                SmsToolkit.log.fine("BSms.sendSMSMessage(String): With arg: " + message);
            }
            try {
                if (SmsToolkit.log.isLoggable(Level.FINE)) {
                    SmsToolkit.log.fine("BSms.sendSMSMessage(String): About to send text message");
                }
                service.send(new BSmsMessage(phoneNumbers, message));
            }
            catch (Exception e) {
                SmsToolkit.log.log(Level.SEVERE, "BSms.sendSMSMessage(String): Error sending message. Exception thrown", e);
            }
        } else {
            SmsToolkit.log.log(Level.SEVERE, "BSms.sendSMSMessage(String): Could not find valid Sms service object");
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

